/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * BindingSubTypePanel.java
 *
 * Created on August 30, 2006, 7:04 PM
 */

package org.netbeans.modules.xml.wsdl.ui.view;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplate;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplateGroup;


/**
 *
 * @author  skini
 */
public class BindingSubTypePanel extends javax.swing.JPanel {
    
    private LocalizedTemplateGroup mLtg;
    
    private List<TemplatePanel> mPanels = new ArrayList<TemplatePanel>();
    
    private ActionListener mButtonActionListener;
    
    /** Creates new form BindingSubTypePanel */
    public BindingSubTypePanel(LocalizedTemplateGroup ltg, ActionListener buttonActionListener) {
        this.mLtg = ltg;
        this.mButtonActionListener = buttonActionListener;
        initComponents();
        initGUI();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        buttonGroup1 = new javax.swing.ButtonGroup();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

    }// </editor-fold>//GEN-END:initComponents
   
    private void initGUI() {
        boolean isDefaultAvailable = false;
        
        LocalizedTemplate[] templates = this.mLtg.getTemplate();
        for (int i = 0; i < templates.length; i++) {
            LocalizedTemplate template = templates[i];
            TemplatePanel panel = new TemplatePanel(template, buttonGroup1);
            panel.getRadioButton().addActionListener(this.mButtonActionListener);
            mPanels.add(panel);
            this.add(panel);
            if(template.getDelegate().isDefault()) {
                setSelectedTemplateName(templates[i].getName());
                isDefaultAvailable = true;
            }
        }
        if (!isDefaultAvailable && templates.length > 0) {
            setSelectedTemplateName(templates[0].getName());
        }
    }
        
    public LocalizedTemplate getBindingSubType() {
        Iterator<TemplatePanel> it = this.mPanels.iterator();
        while(it.hasNext()) {
            TemplatePanel p = it.next();
            if(p.isSelected()) {
                return p.getTemplate();
            }
        }
        return null;
    }
    
    public void reset(LocalizedTemplateGroup ltg) {
        this.removeAll();
        Iterator<TemplatePanel> it =  mPanels.iterator();
        while(it.hasNext()) {
        	TemplatePanel panel = it.next();
        	panel.getRadioButton().removeActionListener(this.mButtonActionListener);
        	
        }
        mPanels.clear();
        
        this.mLtg = ltg;
        initGUI();
        revalidate();
    }
    
    public void setSelectedTemplateName(String templateName) {
        Enumeration<AbstractButton> buttons = buttonGroup1.getElements();
        if (buttons != null) {
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                if (button.getActionCommand().equals(templateName)) {
                    button.setSelected(true);
                }
            }
        }
    }
    
    public ButtonGroup getButtonGroup() {
        return this.buttonGroup1;
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    // End of variables declaration//GEN-END:variables
    
}
