/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.web.core.syntax.completion;

import java.net.URL;
import java.util.List;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLCompletionQuery.HTMLResultItem;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;


/** JSP completion provider implementation
 *
 * @author Marek.Fukala@Sun.COM
 */
public class JspCompletionProvider implements CompletionProvider {
    
    /** Creates a new instance of JavaDocCompletionProvider */
    public JspCompletionProvider() {
    }
    
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        int type = JspSyntaxSupport.get(component.getDocument()).checkCompletion(component, typedText, false);
        if(type == ExtSyntaxSupport.COMPLETION_POPUP) {
            return COMPLETION_QUERY_TYPE + DOCUMENTATION_QUERY_TYPE;
        } else return 0;
    }
    
    public CompletionTask createTask(int type, JTextComponent component) {
        if ((type & COMPLETION_QUERY_TYPE & COMPLETION_ALL_QUERY_TYPE) != 0) {
            return new AsyncCompletionTask(new Query(component.getCaret().getDot()), component);
        } else if (type == DOCUMENTATION_QUERY_TYPE) {
            return new AsyncCompletionTask(new DocQuery(null), component);
        }
        return null;
    }
    
    static final class Query extends AbstractQuery {
        
        private JTextComponent component;
        
        private int creationCaretOffset;
        
        Query(int caretOffset) {
            this.creationCaretOffset = caretOffset;
        }
        
        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }
        
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            CompletionQuery.Result res = queryImpl(component, caretOffset);
            if(res != null) {
                List/*<CompletionItem>*/ results = res.getData();
                resultSet.addAllItems(results);
                resultSet.setTitle(res.getTitle());
                resultSet.setAnchorOffset(((JspCompletionQuery.SubstituteOffsetProvider)res).getSubstituteOffset());
            }
        }
    }
    
    static class DocQuery extends AbstractQuery {
        
        private JTextComponent component;
        private ResultItem item;
        
        public  DocQuery(ResultItem item) {
            this.item = item;
        }
        
        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }
        
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            CompletionQuery.Result res = queryImpl(component, caretOffset);
            if(item == null) {
                if(res != null) {
                    List result = res.getData();
                    if(result != null && result.size() > 0) {
                        Object resultObj = result.get(0);
                        if(resultObj instanceof ResultItem) {
                            item = (ResultItem)resultObj;
                        } else if(resultObj instanceof HTMLResultItem) {
                            HTMLResultItem htmlItem = (HTMLResultItem)resultObj;
                            if(htmlItem != null && htmlItem.getHelpID() != null) {
                                resultSet.setDocumentation(new HTMLCompletionQuery.DocItem(htmlItem));
                                resultSet.setTitle(res.getTitle());
                                return ;
                            }
                        }
                    }
                }
            }
            if(item != null &&
                    !(item instanceof JspCompletionItem.ELItem) &&
                    (item.getHelp() != null || item.getHelpURL() != null)) {
                resultSet.setDocumentation(new DocItem(item));
                if(res != null) {
                    resultSet.setTitle(res.getTitle());
                }
            }
        }
    }
    
    static class DocItem implements CompletionDocumentation {
        private ResultItem ri;
        
        public DocItem(ResultItem ri) {
            this.ri = ri;
        }
        
        public String getText() {
            return ri.getHelp();
        }
        
        public URL getURL() {
            return ri.getHelpURL();
        }
        
        public CompletionDocumentation resolveLink(String link) {
            //????
            return null;
        }
        
        public Action getGotoSourceAction() {
            return null;
        }
    }
    
    static CompletionQuery.Result queryImpl(JTextComponent component, int offset) {
        Class kitClass = Utilities.getKitClass(component);
        if (kitClass != null) {
            return new JspCompletionQuery().query(component, offset);
        } else {
            return null;
        }
    }
    
    private static abstract class AbstractQuery extends AsyncCompletionQuery {
        
        protected void preQueryUpdate(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            checkHideCompletion((BaseDocument)doc, caretOffset);
        }
        
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            //weird, but in some situations null is passed from the framework. Seems to be a bug in active component handling
            if(doc != null) {
                checkHideCompletion((BaseDocument)doc, caretOffset);
            }
            doQuery(resultSet, doc, caretOffset);
            resultSet.finish();
        }
        
        abstract void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset);
        
    }
    
    private static void checkHideCompletion(BaseDocument doc, int caretOffset) {
        //test whether we are just in text and eventually close the opened completion
        //this is handy after end tag autocompletion when user doesn't complete the
        //end tag and just types a text
        int adjustedOffset = caretOffset == 0 ? 0 : caretOffset - 1;
        doc.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get(doc);
            TokenSequence tokenSequence = JspSyntaxSupport.tokenSequence(tokenHierarchy, HTMLTokenId.language(), adjustedOffset);
            if(tokenSequence != null) {
                tokenSequence.move(adjustedOffset);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return; //no token found
                }
                
                Token tokenItem = tokenSequence.token();
                if(tokenSequence.embedded() == null && tokenItem.id() == HTMLTokenId.TEXT && !tokenItem.text().toString().startsWith("<") && !tokenItem.text().toString().startsWith("&")) {
                    hideCompletion();
                }
            }
        } finally {
            doc.readUnlock();
        }
    }
    
    private static void hideCompletion() {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
    }
    
}
