/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.uml.ui.swing.drawingarea;

import com.tomsawyer.editor.TSENode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author Craig Conover, craig.conover@sun.com
 */
public class ResizeElementsPanel extends javax.swing.JPanel
    implements DocumentListener, VetoableChangeListener, ActionListener
{
    private long resizeHeight = 0;
    private long resizeWidth = 0;
    private int anchorPoint = ADDrawingAreaControl.RESIZE_ANCHOR_POINT_CENTER;
    
    private StatisticsTable statisticsTable = null;
    private String statusMsg = " "; // NOI18N
    private boolean enableOk = false;
    
    
    public ResizeElementsPanel(
        long initHeight, 
        long initWidth, 
        int defaultAnchorPoint, 
        ETList<IPresentationElement> presentationElements)
    {
        resizeHeight = initHeight;
        resizeWidth = initWidth;
        anchorPoint = defaultAnchorPoint;
        
        initComponents();
        
        statusLabel.setText(statusMsg);
        heightText.setText(String.valueOf(resizeHeight));
        widthText.setText(String.valueOf(resizeWidth));

        updateAnchorPointGroup(defaultAnchorPoint);
        populateStatsTable(presentationElements);
        
        heightText.getDocument().addDocumentListener(this);
        widthText.getDocument().addDocumentListener(this);
    }

    @Override
    public void requestFocus()
    {
        heightText.requestFocus();
        updateValidStatus();
    }


    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        anchorPointGroup = new javax.swing.ButtonGroup();
        heightLabel = new javax.swing.JLabel();
        heightText = new javax.swing.JTextField();
        widthLabel = new javax.swing.JLabel();
        widthText = new javax.swing.JTextField();
        statsPanel = new javax.swing.JPanel();
        statsTableLabel = new javax.swing.JLabel();
        statsScrollPane = new javax.swing.JScrollPane();
        statsTable = new javax.swing.JTable();
        statusLabel = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        anchorPointLabel = new javax.swing.JLabel();
        anchorCenterRadio = new javax.swing.JRadioButton();
        anchorTLRadio = new javax.swing.JRadioButton();
        anchorBLRadio = new javax.swing.JRadioButton();
        anchorTRRadio = new javax.swing.JRadioButton();
        anchorBRRadio = new javax.swing.JRadioButton();

        heightLabel.setLabelFor(heightText);
        org.openide.awt.Mnemonics.setLocalizedText(heightLabel, org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "LBL_HeightLabel")); // NOI18N

        heightText.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                heightTextFocusGained(evt);
            }
        });

        widthLabel.setLabelFor(widthText);
        org.openide.awt.Mnemonics.setLocalizedText(widthLabel, org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "LBL_WidthLabel")); // NOI18N

        widthText.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                widthTextFocusGained(evt);
            }
        });

        statsTableLabel.setLabelFor(statsTable);
        statsTableLabel.setText(org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "LBL_StatisticsTableLabel")); // NOI18N

        statsScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        statsScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
        statsScrollPane.setEnabled(false);
        statsScrollPane.setWheelScrollingEnabled(false);

        statsTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {"  Height:", null, null, null},
                {"  Width:", null, null, null}
            },
            new String [] {
                "Size Stats", "Min", "Avg ", "Max"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.Double.class, java.lang.Double.class, java.lang.Double.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        statsTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_ALL_COLUMNS);
        statsTable.setColumnSelectionAllowed(true);
        statsTable.setEnabled(false);
        statsTable.setMaximumSize(new java.awt.Dimension(2147483647, 2147483647));
        statsTable.setRowSelectionAllowed(false);
        statsScrollPane.setViewportView(statsTable);

        org.jdesktop.layout.GroupLayout statsPanelLayout = new org.jdesktop.layout.GroupLayout(statsPanel);
        statsPanel.setLayout(statsPanelLayout);
        statsPanelLayout.setHorizontalGroup(
            statsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(statsPanelLayout.createSequentialGroup()
                .add(statsTableLabel)
                .addContainerGap(102, Short.MAX_VALUE))
            .add(statsScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 294, Short.MAX_VALUE)
        );
        statsPanelLayout.setVerticalGroup(
            statsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(statsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(statsTableLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(statsScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 126, Short.MAX_VALUE)
                .addContainerGap())
        );

        statusLabel.setForeground(new java.awt.Color(255, 0, 0));
        statusLabel.setText("<error status>");

        org.openide.awt.Mnemonics.setLocalizedText(anchorPointLabel, org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "LBL_ResizeAnchorPointLabel")); // NOI18N

        anchorPointGroup.add(anchorCenterRadio);
        anchorCenterRadio.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(anchorCenterRadio, org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "LBL_AnchorPointCenter")); // NOI18N
        anchorCenterRadio.setAlignmentY(0.0F);
        anchorCenterRadio.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        anchorCenterRadio.setMargin(new java.awt.Insets(0, 0, 0, 0));
        anchorCenterRadio.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                anchorCenterRadioItemStateChanged(evt);
            }
        });

        anchorPointGroup.add(anchorTLRadio);
        org.openide.awt.Mnemonics.setLocalizedText(anchorTLRadio, org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "LBL_AnchorPointTopLeft")); // NOI18N
        anchorTLRadio.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        anchorTLRadio.setMargin(new java.awt.Insets(0, 0, 0, 0));
        anchorTLRadio.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                anchorTLRadioItemStateChanged(evt);
            }
        });

        anchorPointGroup.add(anchorBLRadio);
        org.openide.awt.Mnemonics.setLocalizedText(anchorBLRadio, org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "LBL_AnchorPointBottomLeft")); // NOI18N
        anchorBLRadio.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        anchorBLRadio.setMargin(new java.awt.Insets(0, 0, 0, 0));
        anchorBLRadio.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                anchorBLRadioItemStateChanged(evt);
            }
        });

        anchorPointGroup.add(anchorTRRadio);
        org.openide.awt.Mnemonics.setLocalizedText(anchorTRRadio, org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "LBL_AnchorPointTopRight")); // NOI18N
        anchorTRRadio.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        anchorTRRadio.setMargin(new java.awt.Insets(0, 0, 0, 0));
        anchorTRRadio.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                anchorTRRadioItemStateChanged(evt);
            }
        });

        anchorPointGroup.add(anchorBRRadio);
        org.openide.awt.Mnemonics.setLocalizedText(anchorBRRadio, org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "LBL_AnchorPointBottomRight")); // NOI18N
        anchorBRRadio.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        anchorBRRadio.setMargin(new java.awt.Insets(0, 0, 0, 0));
        anchorBRRadio.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                anchorBRRadioItemStateChanged(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(anchorTLRadio)
                            .add(anchorBLRadio))
                        .add(37, 37, 37)
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(anchorBRRadio)
                            .add(anchorTRRadio)))
                    .add(anchorPointLabel)
                    .add(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(anchorCenterRadio)))
                .addContainerGap(95, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(anchorPointLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(anchorCenterRadio)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(anchorTRRadio)
                    .add(anchorTLRadio))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(anchorBRRadio)
                    .add(anchorBLRadio))
                .addContainerGap())
        );

        anchorPointLabel.getAccessibleContext().setAccessibleName("");
        anchorCenterRadio.getAccessibleContext().setAccessibleName("");
        anchorCenterRadio.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "ACSD_AnchorPointCenter")); // NOI18N
        anchorTLRadio.getAccessibleContext().setAccessibleName("");
        anchorTLRadio.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "ACSD_AnchorPointTopLeft")); // NOI18N
        anchorBLRadio.getAccessibleContext().setAccessibleName("");
        anchorBLRadio.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "ACSD_AnchorPointBottomLeft")); // NOI18N
        anchorTRRadio.getAccessibleContext().setAccessibleName("");
        anchorTRRadio.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "ACSD_AnchorPointTopRight")); // NOI18N
        anchorBRRadio.getAccessibleContext().setAccessibleName("");
        anchorBRRadio.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "ACSD_AnchorPointBottomRight")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(heightLabel)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(heightText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 59, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(17, 17, 17)
                                .add(widthLabel)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(widthText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 63, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(statusLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 294, Short.MAX_VALUE))
                        .addContainerGap())
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(statsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addContainerGap())))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(heightLabel)
                    .add(heightText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(widthLabel)
                    .add(widthText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(statsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(statusLabel))
        );

        heightLabel.getAccessibleContext().setAccessibleName("");
        heightLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "ACSD_HeightLabel")); // NOI18N
        widthLabel.getAccessibleContext().setAccessibleName("");
        widthLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ResizeElementsPanel.class, "ACSD_WidthLabel")); // NOI18N
        statusLabel.getAccessibleContext().setAccessibleName("");
    }// </editor-fold>//GEN-END:initComponents

    private void widthTextFocusGained(java.awt.event.FocusEvent evt)//GEN-FIRST:event_widthTextFocusGained
    {//GEN-HEADEREND:event_widthTextFocusGained
        widthText.selectAll();
    }//GEN-LAST:event_widthTextFocusGained

    private void heightTextFocusGained(java.awt.event.FocusEvent evt)//GEN-FIRST:event_heightTextFocusGained
    {//GEN-HEADEREND:event_heightTextFocusGained
        heightText.selectAll();
    }//GEN-LAST:event_heightTextFocusGained

    private void anchorCenterRadioItemStateChanged(java.awt.event.ItemEvent evt)//GEN-FIRST:event_anchorCenterRadioItemStateChanged
    {//GEN-HEADEREND:event_anchorCenterRadioItemStateChanged
        anchorPoint = ADDrawingAreaControl.RESIZE_ANCHOR_POINT_CENTER;
    }//GEN-LAST:event_anchorCenterRadioItemStateChanged

    private void anchorBRRadioItemStateChanged(java.awt.event.ItemEvent evt)//GEN-FIRST:event_anchorBRRadioItemStateChanged
    {//GEN-HEADEREND:event_anchorBRRadioItemStateChanged
        anchorPoint = ADDrawingAreaControl.RESIZE_ANCHOR_POINT_BOTTOMRIGHT;
    }//GEN-LAST:event_anchorBRRadioItemStateChanged

    private void anchorBLRadioItemStateChanged(java.awt.event.ItemEvent evt)//GEN-FIRST:event_anchorBLRadioItemStateChanged
    {//GEN-HEADEREND:event_anchorBLRadioItemStateChanged
        anchorPoint = ADDrawingAreaControl.RESIZE_ANCHOR_POINT_BOTTOMLEFT;
    }//GEN-LAST:event_anchorBLRadioItemStateChanged

    private void anchorTRRadioItemStateChanged(java.awt.event.ItemEvent evt)//GEN-FIRST:event_anchorTRRadioItemStateChanged
    {//GEN-HEADEREND:event_anchorTRRadioItemStateChanged
        anchorPoint = ADDrawingAreaControl.RESIZE_ANCHOR_POINT_TOPRIGHT;
    }//GEN-LAST:event_anchorTRRadioItemStateChanged

    private void anchorTLRadioItemStateChanged(java.awt.event.ItemEvent evt)//GEN-FIRST:event_anchorTLRadioItemStateChanged
    {//GEN-HEADEREND:event_anchorTLRadioItemStateChanged
        anchorPoint = ADDrawingAreaControl.RESIZE_ANCHOR_POINT_TOPLEFT;
    }//GEN-LAST:event_anchorTLRadioItemStateChanged


    private void updateAnchorPointGroup(int defaultAnchorPoint)
    {
        switch (defaultAnchorPoint)
        {
            case ADDrawingAreaControl.RESIZE_ANCHOR_POINT_TOPLEFT:
                anchorTLRadio.setSelected(true);
                break;
                
            case ADDrawingAreaControl.RESIZE_ANCHOR_POINT_TOPRIGHT:
                anchorTRRadio.setSelected(true);
                break;
                
            case ADDrawingAreaControl.RESIZE_ANCHOR_POINT_BOTTOMLEFT:
                anchorBLRadio.setSelected(true);
                break;
                
            case ADDrawingAreaControl.RESIZE_ANCHOR_POINT_BOTTOMRIGHT:
                anchorBRRadio.setSelected(true);
                break;
                
            default: // center
                anchorCenterRadio.setSelected(true);
                break;
        }
    }

    public double getResizeHeight()
    {
        return resizeHeight;
    }

    public double getResizeWidth()
    {
        return resizeWidth;
    }

    public int getAnchorPoint()
    {
        return anchorPoint;
    }

    private void populateStatsTable(
        ETList<IPresentationElement> presentationElements)
    {
        if (presentationElements == null || presentationElements.size() == 0)
            return;
        
        if (presentationElements.size() > 1)
        {
            heightText.setText(""); // NOI18N
            widthText.setText(""); // NOI18N
            resizeHeight = 0;
            resizeWidth = 0;
            enableOk = false;
            
            if (statisticsTable == null)
                statisticsTable = new StatisticsTable();

            statisticsTable.computeStats(presentationElements);
            
            StatsTableModel stm = new StatsTableModel(
                statisticsTable.getStatsData());
            
            statsTable.setModel(stm);
            statsPanel.setVisible(true);
            updateValidStatus();
        }
        
        else
        {
            resizeHeight = 
                ((INodePresentation)presentationElements.get(0)).getHeight();
            
            resizeWidth = 
                ((INodePresentation)presentationElements.get(0)).getWidth();
            
            heightText.setText(String.valueOf(resizeHeight)); // NOI18N
            widthText.setText(String.valueOf(resizeWidth)); // NOI18N
            
            statsPanel.setVisible(false);
        }
    }

    
    public void insertUpdate(DocumentEvent evt)
    {
        updateSizeFields(evt);
    }

    public void removeUpdate(DocumentEvent evt)
    {
        updateSizeFields(evt);
    }

    public void changedUpdate(DocumentEvent evt)
    {
        updateSizeFields(evt);
    }

    private void updateSizeFields(DocumentEvent evt)
    {
        Document doc = evt.getDocument(); 
        
        if (doc == heightText.getDocument())
        {
            if (validNumber(heightText.getText()))
                resizeHeight = Long.valueOf(heightText.getText()).longValue();
            
            else
                resizeHeight = 0;
    
            updateValidStatus();
        }
        
        else if (doc == widthText.getDocument())
        {
            if (validNumber(widthText.getText()))
                resizeWidth = Long.valueOf(widthText.getText()).longValue();
            
            else
                resizeWidth = 0;

            updateValidStatus();
        }
    }


    private boolean validNumber(String dimStrVal)
    {
        if (dimStrVal == null || dimStrVal.length() == 0)
            return false;
            
        try
        {
            return (Long.valueOf(dimStrVal) > 0);
        }
        
        catch (NumberFormatException ex)
        {
           return false;
        }
    }
    
    private boolean updateValidStatus()
    {
        enableOk = true;
        statusMsg = " "; // NOI18N
        
        if (resizeHeight < 5 || resizeWidth < 5)
        {
           enableOk = Boolean.FALSE;
           statusMsg = "MSG_STATUS_InvalidDimensions"; // NOI18N

           return notifyPropertyListeners();
        }
        
        return notifyPropertyListeners();
    }
    
    private boolean notifyPropertyListeners()
    {
        firePropertyChange(
            NotifyDescriptor.PROP_VALID, !enableOk, enableOk);
        
        if (!statusMsg.equals(" ")) // NOI18N
            statusMsg = NbBundle.getMessage(
                ResizeElementsPanel.class, statusMsg);
        
        statusLabel.setText(statusMsg);
        return enableOk;
    }

    public void vetoableChange(PropertyChangeEvent evt) 
        throws PropertyVetoException
    {
        if (evt.getSource() == heightText)
        {
            if (heightText.getText() != null && 
                heightText.getText().length() > 0)
            {
                if (!validNumber(heightText.getText()))
                    throw new PropertyVetoException(
                        "Must be positive, whole number", evt); // NOI18N
            }
        }
        
        else if (evt.getSource() == widthText)
        {
            if (widthText.getText() != null && 
                widthText.getText().length() > 0)
            {
                if (!validNumber(widthText.getText()))
                    throw new PropertyVetoException(
                        "Must be positive, whole number", evt); // NOI18N
            }
        }
    }

    public void actionPerformed(ActionEvent e)
    {
    }

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton anchorBLRadio;
    private javax.swing.JRadioButton anchorBRRadio;
    private javax.swing.JRadioButton anchorCenterRadio;
    private javax.swing.ButtonGroup anchorPointGroup;
    private javax.swing.JLabel anchorPointLabel;
    private javax.swing.JRadioButton anchorTLRadio;
    private javax.swing.JRadioButton anchorTRRadio;
    private javax.swing.JLabel heightLabel;
    private javax.swing.JTextField heightText;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel statsPanel;
    private javax.swing.JScrollPane statsScrollPane;
    private javax.swing.JTable statsTable;
    private javax.swing.JLabel statsTableLabel;
    private javax.swing.JLabel statusLabel;
    private javax.swing.JLabel widthLabel;
    private javax.swing.JTextField widthText;
    // End of variables declaration//GEN-END:variables
    
    private class StatisticsTable
    {
        long widthMin = 0;
        long widthAvg = 0;
        long widthMax = 0;
        long heightMin = 0;
        long heightAvg = 0;
        long heightMax = 0;
        
        Object[][] getStatsData()
        {
            Object[][] data = new Object[2][4];
            
            data[0][0] = NbBundle.getMessage(
                ResizeElementsPanel.class, "TXT_HeightRowValue"); // NOI18N
            data[0][1] = new Long(heightMin);
            data[0][2] = new Long(heightAvg);
            data[0][3] = new Long(heightMax);

            
            data[1][0] = NbBundle.getMessage(
                ResizeElementsPanel.class, "TXT_WidthRowValue"); // NOI18N
            data[1][1] = new Long(widthMin);
            data[1][2] = new Long(widthAvg);
            data[1][3] = new Long(widthMax);
            
            return data;
        }
        
        void computeStats(ETList<IPresentationElement> presElems)
        {
            long heightSum = 0;
            long widthSum = 0;
            int nodeCount = 0;
            
            for (IPresentationElement pres: presElems)
            {
                if (!(pres instanceof INodePresentation))
                    continue;
                
                INodePresentation nodePres = (INodePresentation)pres;
                TSENode tsNode = nodePres.getTSNode();
                
                nodeCount++;
                long curheight = Math.round(tsNode.getHeight());
                long curwidth = Math.round(tsNode.getWidth());

                heightSum+= curheight;
                
                heightMin = (heightMin == 0)
                    ? curheight 
                    : Math.min(curheight, heightMin);
                
                heightMax = Math.max(curheight, heightMax);

                widthSum+= curwidth;
                
                widthMin = (widthMin == 0)
                    ? curwidth
                    : Math.min(curwidth, widthMin);
                
                widthMax = Math.max(curwidth, widthMax);
            }
            
            heightAvg = Math.round(heightSum / nodeCount);
            widthAvg = Math.round(widthSum / nodeCount);
        }
    }

    public static class StatsTableModel extends DefaultTableModel
    {
        static String colStatName =
            (NbBundle.getMessage(ResizeElementsPanel.class,
            "LBL_ColumnStatName")); //NOI18N
        
        static String colMin =
            (NbBundle.getMessage(ResizeElementsPanel.class,
            "LBL_ColumnStatMin")); //NOI18N
        
        static String colAvg =
            (NbBundle.getMessage(ResizeElementsPanel.class,
            "LBL_ColumnStatAvg")); //NOI18N
        
        static String colMax =
            (NbBundle.getMessage(ResizeElementsPanel.class,
            "LBL_ColumnStatMax")); //NOI18N
        

        public StatsTableModel(Object[][] statsData)
        {
            super(statsData, new Object[]{colStatName, colMin, colAvg, colMax});
        }
        
        @Override
        public Class getColumnClass(int columnIndex)
        {
            switch (columnIndex)
            {
                case 0:
                    return String.class;
                    
                // the rest are Double
                default:
                    return Long.class;
            }
        }
    }

}
