/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.j2ee.websphere6;

import javax.enterprise.deploy.model.*;
import javax.enterprise.deploy.shared.*;

/**
 * Wrapper for the j2eeserver's implementation of <code>DDBeanRoot</code>.
 * This class serves as a wrapper for j2eeserver's implementation of
 * <code>DDBeanRoot</code> that fixes its incompartibility with the
 * JSR-88 specification. The j2eeserver's implementation returns
 * <i>'/&lt;app-type&gt;'</i> as its xpath, while the specification requires
 * the xpath to be <i>'/'</i>.
 *
 * @author Kirill Sorokin
 */
public class WSDDBeanRoot implements DDBeanRoot {
    /**
     * The original j2eeserver's <code>DDBeanRoot</code> implementation, all
     * operations except <code>getXpath()</code> and 
     * <code>getDeployableObject</code> are delegated to it
     */
    private DDBeanRoot bean;
    
    /**
     * Handle for the plugin's <code>DeployableObject</code> wrapper, it is 
     * used in the <code>getDeploaybleObject()</code> call
     */
    private WSDeployableObject parentObject;
    
    /**
     * Creates a new instance of <code>WSDDBeanRoot</code>
     * 
     * @param bean the original j2eeserver's <code>DDBeanRoot</code> 
     *      implementation
     * @param parentObject the plugin's parent <code>DeployableObject</code> 
     *      wrapper
     */
    public WSDDBeanRoot(DDBeanRoot bean, WSDeployableObject parentObject) {
        // save the instance variables
        this.bean = bean;
        this.parentObject = parentObject;
    }
    
    /**
     * Returns the original j2eeserver's <code>DDBeanRoot</code> implementation
     * object
     * 
     * @return the original j2eeserver's DDBeanRoot
     */
    public DDBeanRoot getOrigin() {
        return bean;
    }
    
    /**
     * Returns the specification compliant <code>DDBeanRoot</code>'s xpath, 
     * i.e. <i>'/'</i>
     * 
     * @return string containing the correct DDBeanRoot's xpath, i.e. <i>'/'</i>
     */
    public String getXpath() {
        return "/";                                                    // NOI18N
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getAttributeValue(String str) {
        return bean.getAttributeValue(str);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public DDBean[] getChildBean(String str) {
        return bean.getChildBean(str);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String[] getText(String str) {
        return bean.getText(str);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public void removeXpathListener(String str, XpathListener xpathListener) {
        bean.removeXpathListener(str, xpathListener);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public void addXpathListener(String str, XpathListener xpathListener) {
        bean.addXpathListener(str, xpathListener);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String[] getAttributeNames() {
        return bean.getAttributeNames();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getDDBeanRootVersion() {
        return bean.getDDBeanRootVersion();
    }
    
    /**
     * Returns the parent <code>DeployableObject</code> object, currently a 
     * plugin wrapper for the j2eeserver's implementation
     * 
     * @return parent <code>DeployableObject</code> implementation
     */
    public DeployableObject getDeployableObject() {
        return parentObject;
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getFilename() {
        return bean.getFilename();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getId() {
        return bean.getId();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    
    public String getModuleDTDVersion() {
        return bean.getDDBeanRootVersion();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public DDBeanRoot getRoot() {
        return bean.getRoot();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getText() {
        return bean.getText();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public ModuleType getType() {
        return bean.getType();
    }
}