/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * WebAppCachePanel.java
 *
 * Created on November 5, 2003, 4:56 PM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.util.ResourceBundle;

import javax.swing.JTabbedPane;

import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppCache;
import org.openide.util.NbBundle;

/**
 *
 * @author Peter Williams
 */
public class WebAppCachePanel extends JTabbedPane {
	
	private final ResourceBundle webappBundle = NbBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");	// NOI18N
		
	private WebAppRootCustomizer masterPanel;
	
	/** Creates new form WebAppCachePanel */
	public WebAppCachePanel(WebAppRootCustomizer src) {
		masterPanel = src;
		
		initComponents();
		initUserComponents();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents

        setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_WebAppCacheTab"));
        getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_WebAppCacheTab"));
    }//GEN-END:initComponents
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

	private CacheGeneralPanel generalPanel;
	private CacheHelperPanel helperPanel;
	private CacheMappingPanel mappingPanel;
	
	private void initUserComponents() {
		// add cache general panel
		generalPanel = new CacheGeneralPanel(masterPanel);
		addTab(webappBundle.getString("CACHE_GENERAL_TAB"), generalPanel);	// NOI18N
		
		// add cache helper panel
		helperPanel = new CacheHelperPanel(masterPanel);
		addTab(webappBundle.getString("CACHE_HELPERS_TAB"), helperPanel);	// NOI18N
		
		// add cache mappings panel
		mappingPanel = new CacheMappingPanel(masterPanel);
		addTab(webappBundle.getString("CACHE_MAPPINGS_TAB"), mappingPanel);	// NOI18N
	}
	
	public void addListeners() {
		generalPanel.addListeners();
		helperPanel.addListeners();
		mappingPanel.addListeners();
	}
	
	public void removeListeners() {
		generalPanel.removeListeners();
		helperPanel.removeListeners();
		mappingPanel.removeListeners();		
	}	
	
	/** Initialization of all the fields in this panel from the bean that
	 *  was passed in.
	 */
	public void initFields(WebAppRoot theBean) {
		WebAppCache cacheBean = theBean.getCacheBean();
		generalPanel.initFields(cacheBean);
		helperPanel.initFields(cacheBean);
		mappingPanel.initFields(cacheBean);
	}
	
	/** Returns the help ID for the selected tab within the cache tab of sun-web-app.
	 *
	 * @return String representing the current active help ID for this tabbed panel.
	 */
	public String getHelpId() {
		String result = "AS_CFG_WebAppCacheGeneral";	// NOI18N
		
		// Determine which tab has focus and return help context for that tab.
		switch(getSelectedIndex()) {
			case 2:
				result = "AS_CFG_WebAppCacheMapping";	// NOI18N
				break;
			case 1:
				result = "AS_CFG_WebAppCacheHelpers";	// NOI18N
				break;
		}
		
		return result;
	}

	/** Retrieve the partition that should be associated with the current 
	 *  selected tab.
	 *
	 *  @return ValidationError.Partition
	 */
	public ValidationError.Partition getPartition() {
		switch(getSelectedIndex()) {
			case 2:
				return ValidationError.PARTITION_CACHE_CONSTRAINTS;
			case 1:
				return ValidationError.PARTITION_CACHE_HELPERS;
			default:
				return ValidationError.PARTITION_CACHE_GENERAL;
		}
	}	
}
