/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.oc4j.customizer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.oc4j.util.OC4JPluginProperties;
import org.netbeans.modules.j2ee.oc4j.util.OC4JPluginUtils;

/**
 *
 * @author  Michal Mocnak
 */
public class OC4JCustomizerUserPanel extends javax.swing.JPanel {
    
    private InstanceProperties ip;
    
    /** Creates new form OC4JCustomizerUserPanel */
    public OC4JCustomizerUserPanel(final InstanceProperties ip) {
        this.ip = ip;
        
        initComponents();
        
        setInitValues();
        
        usersComboBox.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent event) {
                if(!ip.getProperty(InstanceProperties.USERNAME_ATTR).equals(event.getItem())) {
                    ip.setProperty(InstanceProperties.USERNAME_ATTR, (String) event.getItem());
                    changePassword();
                }
            }
        });
    }
    
    private void setInitValues() {
        String j2eeLocalHome = ip.getProperty(OC4JPluginProperties.PROPERTY_OC4J_HOME);
        
        for (String item : OC4JPluginUtils.getUsers(j2eeLocalHome)) {
            usersComboBox.addItem(item);
        }
        
        if (OC4JPluginUtils.isLocalServer(ip)) {
            usersComboBox.setEditable(false);
        } else {
            usersComboBox.addItem(ip.getProperty(InstanceProperties.USERNAME_ATTR));
            usersComboBox.setEditable(true);
        }
        
        usersComboBox.setSelectedItem(ip.getProperty(InstanceProperties.USERNAME_ATTR));
    }
    
    private void changePassword() {
        String username = ip.getProperty(InstanceProperties.USERNAME_ATTR);
        String password = OC4JPluginUtils.requestPassword(username);
        
        if(password != null)
            ip.setProperty(InstanceProperties.PASSWORD_ATTR, password);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        userLabel = new javax.swing.JLabel();
        usersComboBox = new javax.swing.JComboBox();
        changeButton = new javax.swing.JButton();

        userLabel.setText(org.openide.util.NbBundle.getMessage(OC4JCustomizerUserPanel.class, "LBL_UserPanel")); // NOI18N

        changeButton.setText(org.openide.util.NbBundle.getMessage(OC4JCustomizerUserPanel.class, "LBL_UserChange")); // NOI18N
        changeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                changeButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(userLabel)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(usersComboBox, 0, 199, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(changeButton)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(userLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(changeButton)
                    .add(usersComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
private void changeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_changeButtonActionPerformed
    changePassword();
}//GEN-LAST:event_changeButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton changeButton;
    private javax.swing.JLabel userLabel;
    private javax.swing.JComboBox usersComboBox;
    // End of variables declaration//GEN-END:variables
    
}
