/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.php.rt.providers.impl.ftp;

import java.net.MalformedURLException;
import org.netbeans.modules.php.rt.providers.impl.*;
import java.net.URL;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.rt.spi.providers.Host;
import org.netbeans.modules.php.rt.spi.providers.ProjectWizardComponent;
import org.openide.WizardDescriptor;

public class FtpServerPanel extends ProjectWizardComponent {

    private static final long serialVersionUID = 3607668528003026007L;

    public FtpServerPanel(Host host) {
        //super(host);
        myHost = host;
        initComponents();

        init();
    }

    public void store(WizardDescriptor descriptor) {
        descriptor.putProperty(PROP_CONTEXT, myContextPath.getText());
    }

    public void read(WizardDescriptor settings) {
        String context = (String) settings.getProperty( PROP_CONTEXT );
        setDefaults(context);
    }

    public boolean isContentValid() {
        return true;
    }


    protected void contextUpdated() {
        if (getHost() instanceof FtpHostImpl) {
            FtpHostImpl host = (FtpHostImpl) getHost();

            updateHttpPath(host);

            updateFtpPath(host);
        }
    }

    private void updateHttpPath(FtpHostImpl host) {
        try {
            String httpUrl = createPreviewUrl(FtpHostImpl.Helper.getHttpUrl(host));
            
            getHttpPath().setText(httpUrl);
            getHttpPath().setToolTipText(httpUrl);
        } catch (MalformedURLException ex) {
            getHttpPath().setText(ex.toString());
        }
    }

    private void updateFtpPath(FtpHostImpl host) {
        try {
            String ftpUrl = createPreviewUrl(FtpHostImpl.Helper.getFtpUrl(host));

            getFtpPath().setText(ftpUrl.toString());
            getFtpPath().setToolTipText(ftpUrl);
        } catch (MalformedURLException ex) {
            getFtpPath().setText(ex.toString());
        }
    }

    private String createPreviewUrl(String baseUrl) throws MalformedURLException {
        String contextPath = getContextPath().getText();
        return FtpHostImpl.Helper.addSubdirectoryToUrl(baseUrl, contextPath);
    }

    private void setDefaults(String context) {
        if (context == null) {
            context = DEFAULT_CONTEXT;
        }
        myContextPath.setText(context);

        contextUpdated();
    }

    protected Host getHost() {
        return myHost;
    }

    protected JTextField getContextPath() {
        return myContextPath;
    }

    protected JTextField getHttpPath() {
        return myHttpPath;
    }

    protected JTextField getFtpPath() {
        return myFtpPath;
    }

    protected void init() {
        setDefaults(null);
        DocumentListener listener = new ContextListener();
        myContextPath.getDocument().addDocumentListener(listener);
    }



    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        myContextPathLbl = new javax.swing.JLabel();
        myContextPath = new javax.swing.JTextField();
        myHttpPathLbl = new javax.swing.JLabel();
        myHttpPath = new javax.swing.JTextField();
        myFtpPath = new javax.swing.JTextField();
        myFtpPathLbl = new javax.swing.JLabel();

        myContextPathLbl.setLabelFor(myContextPath);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/php/rt/providers/impl/ftp/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(myContextPathLbl, bundle.getString("LBL_Context_Path")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myHttpPathLbl, bundle.getString("LBL_Http_Path")); // NOI18N

        myHttpPath.setEditable(false);

        myFtpPath.setEditable(false);

        org.openide.awt.Mnemonics.setLocalizedText(myFtpPathLbl, org.openide.util.NbBundle.getMessage(FtpServerPanel.class, "LBL_Ftp_Path")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(myContextPathLbl)
                    .add(myHttpPathLbl)
                    .add(myFtpPathLbl))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, myHttpPath, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
                    .add(myFtpPath, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, myContextPath, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE))
                .add(20, 20, 20))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myContextPathLbl)
                    .add(myContextPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myHttpPathLbl)
                    .add(myHttpPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(8, 8, 8)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myFtpPathLbl)
                    .add(myFtpPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        myContextPathLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FtpServerPanel.class, "A11_Context_PathLbl")); // NOI18N
        myContextPath.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FtpServerPanel.class, "A11_Context_Path")); // NOI18N
        myHttpPathLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FtpServerPanel.class, "A11_Http_PathLbl")); // NOI18N
        myHttpPath.getAccessibleContext().setAccessibleDescription(bundle.getString("A11_Http_Path")); // NOI18N
        myFtpPath.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FtpServerPanel.class, "A11_Ftp_Path")); // NOI18N
        myFtpPathLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FtpServerPanel.class, "A11_Ftp_PathLbl")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

/*static boolean isValidName(String fileName){
    try {
    boolean bValid = true;
    File tempFile =  new File(fileName);
    String tempFileName =0+fileName;
    File actualTempFile = File.createTempFile(tempFileName, null);
    if (!FileUtil.normalizeFile(tempFile).equals(tempFile.getCanonicalFile())) {
    bValid = false;
    }
    actualTempFile.delete();
    actualTempFile = null;
    tempFile = null;
    return bValid;
    }catch (Exception e) {
    return false;
    }
    }*/

    private class ContextListener implements DocumentListener {

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#changedUpdate(javax.swing.event.DocumentEvent)
         */
        public void changedUpdate(DocumentEvent arg0) {
            contextUpdated();
        }

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#insertUpdate(javax.swing.event.DocumentEvent)
         */
        public void insertUpdate(DocumentEvent arg0) {
            contextUpdated();
        }

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#removeUpdate(javax.swing.event.DocumentEvent)
         */
        public void removeUpdate(DocumentEvent arg0) {
            contextUpdated();
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField myContextPath;
    private javax.swing.JLabel myContextPathLbl;
    private javax.swing.JTextField myFtpPath;
    private javax.swing.JLabel myFtpPathLbl;
    private javax.swing.JTextField myHttpPath;
    private javax.swing.JLabel myHttpPathLbl;
    // End of variables declaration//GEN-END:variables
    private Host myHost;
}
