/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface;


import javax.swing.Action;
import org.netbeans.modules.scripting.php.dbginterface.api.VariableNode;
import org.netbeans.modules.scripting.php.dbginterface.ui.VariablesFilter;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class VariablesActionsProvider implements NodeActionsProvider {

    private final Action EDIT_FILTERS_ACTION = Models.createAction (
        "Filters...",
        new Models.ActionPerformer () {
            public boolean isEnabled(Object node) {
                return true;
            }
            public void perform(Object[] nodes) {
                editFilters();
            }
        },
        Models.MULTISELECTION_TYPE_ANY
    );

    public Action[] getActions(Object node) throws UnknownTypeException {
        if(node == TreeModel.ROOT || node instanceof VariableNode) {
            return new Action [] {
                EDIT_FILTERS_ACTION
            };
        }
//        if(node instanceof Variable)
//            return new Action [] {
//            };
//        if(node.toString().startsWith ("SubArray")) // NOI18N
//            return new Action [] {
//            };
//        if(node.equals ("NoInfo")) // NOI18N
//            return new Action [] {
//            };
        throw new UnknownTypeException (node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if(node == TreeModel.ROOT) {
            return;
        } else if(node instanceof VariableNode) {
            return;
        }
//        if(node.toString().startsWith ("SubArray")) // NOI18N
//            return ;
//        if(node.equals ("NoInfo")) // NOI18N
//            return;
        throw new UnknownTypeException (node);
    }

    // !PW FIXME can we make this modeless?
    private void editFilters() {
        VariablesFilter.showDialog();
    }

}
