/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.ruby.rubyproject;

import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/**
 * @author  Tor Norbye
 */
public class RubyHomeOptionsPanel extends JPanel implements ActionListener {
    
    private DocumentListener interpreterDL;
    
    /** Creates new form RubyHomeOptionsPanel */
    public RubyHomeOptionsPanel() {
        initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        interpreterDL = new DocumentListener() {
            public void insertUpdate(DocumentEvent e) {changedUpdate(null);}
            public void removeUpdate(DocumentEvent e) {changedUpdate(null);}
            public void changedUpdate(DocumentEvent e) {
                String ruby = getRuby();
                if (new File(ruby).isFile()) { // at least sanity check
                    RubyInstallation.getInstance().fireInterpreterLiveChange(ruby);
                }
            }
        };
        rubyField.getDocument().addDocumentListener(interpreterDL);
    }

    @Override
    public void removeNotify() {
        rubyField.getDocument().removeDocumentListener(interpreterDL);
        super.removeNotify();
    }
    
    public void setRuby(String path) {
        rubyField.setText(path);
    }
    
    public String getRuby() {
        return rubyField.getText().trim();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        rubyLabel = new javax.swing.JLabel();
        rubyField = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();
        descriptionLabel = new javax.swing.JLabel();

        rubyLabel.setLabelFor(rubyField);
        org.openide.awt.Mnemonics.setLocalizedText(rubyLabel, org.openide.util.NbBundle.getMessage(RubyHomeOptionsPanel.class, "RubyLabel")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(browseButton, org.openide.util.NbBundle.getMessage(RubyHomeOptionsPanel.class, "RubyHomeBrowse")); // NOI18N
        browseButton.addActionListener(this);

        org.openide.awt.Mnemonics.setLocalizedText(descriptionLabel, org.openide.util.NbBundle.getMessage(RubyHomeOptionsPanel.class, "RubyHomeOptionsPanel.descriptionLabel.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(rubyLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(rubyField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 371, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(browseButton))
                    .add(descriptionLabel))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(descriptionLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(rubyField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(rubyLabel)
                    .add(browseButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }

    // Code for dispatching events from components to event handlers.

    public void actionPerformed(java.awt.event.ActionEvent evt) {
        if (evt.getSource() == browseButton) {
            RubyHomeOptionsPanel.this.browseButtonActionPerformed(evt);
        }
    }// </editor-fold>//GEN-END:initComponents
 
    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {                                         
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setFileSelectionMode (JFileChooser.FILES_ONLY);
        chooser.setMultiSelectionEnabled(false);

        String workDir = rubyField.getText();
        if (workDir.equals("")) {
            String ruby = RubyInstallation.getInstance().getRuby();
            if (ruby != null) {
                workDir = new File(ruby).getParent();
            } else {
                workDir = null;
            }
        }
        if (workDir != null) {
            chooser.setSelectedFile(new File(workDir));
        }
        chooser.setDialogTitle(NbBundle.getMessage(RubyHomeOptionsPanel.class, "LBL_BrowseConfiguration"));
        if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) { //NOI18N
            File file = FileUtil.normalizeFile(chooser.getSelectedFile());
            rubyField.setText(file.getAbsolutePath());
        }
    }                                        
   
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JTextField rubyField;
    private javax.swing.JLabel rubyLabel;
    // End of variables declaration//GEN-END:variables
    
}
