/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * RMSRecordSetManager.java
 *
 * Created on April 5, 2007, 3:25 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.testme.rms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

/**
 *
 * @author Pavel
 */
final class RMSRecordSetManager {
    private static final String RMS_FAT           = "RMSLOG_RECORDS";
    public static final String VENDOR_NAME       = "Sun";
    public static final String SUITE_NAME        = "Logger";

    private final Vector recordSets = new Vector();
    
    public RMSRecordSetManager() throws IOException {
         RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore( RMS_FAT, true, RecordStore.AUTHMODE_ANY, true);
            int recordsNum = rs.getNumRecords();

            for ( RecordEnumeration records = rs.enumerateRecords(null, null, false); records.hasNextElement(); ) {
                byte [] buffer = records.nextRecord();
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                recordSets.addElement(new RMSEntry(this, in));
                in.close();
            }
        } catch( RecordStoreNotFoundException e) {
            //no recordstores yet
        } catch( IOException e) {
            throw e;
        } catch( Exception e) {
            throw new IOException( e.getClass().getName() + "[" + e.getMessage() + "]");
        } finally {
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                } catch (RecordStoreException e) {
                }
            }
        }
    }
    
    public synchronized RMSEntry createRecordSet(final String filename) throws IOException {
        RMSEntry rset = findRecordSet(filename);
        if ( rset != null) {
            throw new IllegalArgumentException("The recordset '" + filename + "' already exists.");
        } else {
            rset = new RMSEntry(this, filename);
            recordSets.addElement(rset);
            
            RecordStore rs = null;            
            // add the record set to the list
            try {
                rs = RecordStore.openRecordStore( RMS_FAT, true, RecordStore.AUTHMODE_ANY, true);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Utils.writeString( out, rset.getName());
                out.flush();
                byte [] data = out.toByteArray();
                rs.addRecord(data, 0, data.length);
            } catch( Exception e) {
                throw new IOException( e.getClass().getName() + "[" + e.getMessage() + "]");
            } finally {
                if (rs != null) {
                    try {
                        rs.closeRecordStore();
                    } catch (RecordStoreException e) {
                    }
                }
            }
            
            return rset;
        }
    }

    public synchronized RMSEntry openRecordSet(final String filename) throws IOException {
        RMSEntry rs = findRecordSet(filename);
        if (rs != null) {
            return rs;
        } else {
            throw new IllegalArgumentException("The recordset '" + filename + "' not found.");
        }
    }

    public synchronized String [] listRecordSets() {
        String [] names = new String[ recordSets.size()];

        for (int i = 0; i < names.length; i++) {
            names[i] = ((RMSEntry) recordSets.elementAt(i)).getName();
        }
        return names;
    }

    public synchronized void deleteRecordSet(String filename) throws IOException {
        RMSEntry rset = findRecordSet(filename);
        if (rset != null) {
            recordSets.removeElement(rset);
            RecordStore rs = null;            
            try {
                rs = RecordStore.openRecordStore( RMS_FAT, true, RecordStore.AUTHMODE_ANY, true);
                for (RecordEnumeration records = rs.enumerateRecords(null, null, false); records.hasNextElement(); ) {
                    int id = records.nextRecordId();
                    byte [] buffer = rs.getRecord(id);
                    ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                    rset = new RMSEntry(this, in); 
                    in.close();
                    if (filename.equals(rset.getName())) {
                        rs.deleteRecord( id);
                        break;
                    }                    
                }
            } catch( Exception e) {
                throw new IOException( e.getClass().getName() + "[" + e.getMessage() + "]");
            } finally {
                if (rs != null) {
                    try {
                        rs.closeRecordStore();
                    } catch (RecordStoreException e) {
                    }
                }
            }            
        } else {
            throw new IllegalArgumentException("The recordset '" + filename + "' not found.");
        }        
    } 
    
    private RMSEntry findRecordSet(final String name) {
        for ( int i = recordSets.size() - 1; i >= 0; i--) {
            RMSEntry rs = (RMSEntry) recordSets.elementAt(i);
            if ( rs.getName().equals(name)) {
                return rs;
            }
        }
        return null;
    }    
}
