/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.vmd.game.preview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;

/**
 *
 * @author  kherink
 */
public class SequenceContainerPreview extends javax.swing.JPanel implements ActionListener {
    
    private SequenceContainer sequenceContainer;
    private SequencePreviewPanel sequencePreviewPanel;
	private String labelTypeName;
	
    /**
     * Creates new form SequenceContainerPreview
     */
    public SequenceContainerPreview(String labelTypeName, SequenceContainer sequenceContainer) {
		this.labelTypeName = labelTypeName;
        this.sequenceContainer = sequenceContainer;
		this.sequencePreviewPanel = (SequencePreviewPanel) this.sequenceContainer.getDefaultSequence().getPreview();
        initComponents();
    }
    
    private ComboBoxModel getSequenceComboModel() {
        List sequences = this.sequenceContainer.getSequences();
        return new DefaultComboBoxModel(sequences.toArray());
    }
	
    public void actionPerformed(ActionEvent e) {
		if (e.getSource() == this.comboBoxSequence) {
			Sequence currentSequence = (Sequence) this.comboBoxSequence.getSelectedItem();
			this.sequencePreviewPanel.setSequence(currentSequence);
		}
    }

	
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        labelSprite = new javax.swing.JLabel();
        textFieldSprite = new javax.swing.JTextField();
        comboBoxSequence = new javax.swing.JComboBox();
        sequencePanel = new javax.swing.JPanel();

        setBackground(new java.awt.Color(255, 255, 255));
        setMinimumSize(new java.awt.Dimension(10, 180));
        labelSprite.setText(this.labelTypeName);

        textFieldSprite.setBackground(new java.awt.Color(255, 255, 255));
        textFieldSprite.setEditable(false);
        textFieldSprite.setText(this.sequenceContainer.getName());
        textFieldSprite.setBorder(null);

        comboBoxSequence.setBackground(new java.awt.Color(255, 255, 255));
        comboBoxSequence.setModel(getSequenceComboModel());
        this.comboBoxSequence.addActionListener(this);

        sequencePanel.setLayout(new java.awt.BorderLayout());

        sequencePanel.setBackground(new java.awt.Color(255, 255, 255));
        this.sequencePanel.add(this.sequencePreviewPanel);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(labelSprite)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(textFieldSprite, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 101, Short.MAX_VALUE))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, comboBoxSequence, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 197, Short.MAX_VALUE))
                .addContainerGap())
            .add(sequencePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 221, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(labelSprite)
                    .add(textFieldSprite, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(comboBoxSequence, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sequencePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 237, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JComboBox comboBoxSequence;
    public javax.swing.JLabel labelSprite;
    private javax.swing.JPanel sequencePanel;
    public javax.swing.JTextField textFieldSprite;
    // End of variables declaration//GEN-END:variables
    
}
