/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.languages.lexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.languages.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;


/**
 *
 * @author Jan Jancura
 */
public class SLanguageHierarchy extends LanguageHierarchy<STokenId> {
    
    private String                      mimeType;
    private List<STokenId>              tokenIDs;
    private Map<Integer,STokenId>       tokenIDToType;
    
    
    public SLanguageHierarchy (String mimeType) {
        this.mimeType = mimeType;
    }
    
    protected Collection<STokenId> createTokenIds () {
        if (tokenIDs == null) {
            Language language = getLanguage ();
            List<TokenType> tokenTypes = language.getParser ().getTokenTypes ();
            tokenIDToType = new HashMap<Integer,STokenId> ();
            tokenIDs = new ArrayList<STokenId> ();
            Set<String> types = new HashSet<String> ();
            int size = tokenTypes.size ();
            for (int i = 0; i < size; i++) {
                TokenType tokenType = tokenTypes.get (i);
                String typeName = tokenType.getType ();
                if (types.contains (typeName)) continue; // there can be more TokenTypes with same name!!
                types.add (typeName);
                STokenId tokenId = new STokenId (
                    typeName, 
                    language.getTokenID (typeName), 
                    typeName
                );
                tokenIDs.add (tokenId);
                tokenIDToType.put (tokenId.ordinal (), tokenId);
            }
        }
        return tokenIDs;
    }

    protected Lexer<STokenId> createLexer (LexerRestartInfo<STokenId> info) {
        if (tokenIDs == null) createTokenIds ();
        return new SLexer (
            getLanguage (), 
            tokenIDToType, 
            info
        );
    }

    protected String mimeType () {
        return mimeType;
    }
    
    
    // other methods ...........................................................
    
    private Language getLanguage () {
        try {
            return LanguagesManager.getDefault ().getLanguage (mimeType);
        } catch (ParseException ex) {
            return Language.create (mimeType);
        }
    }
}
