/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.openide.filesystems.FileUtil;
    
/**
 *
 * @author Tomas Zezula
 */
public class NBLockFactory extends SimpleFSLockFactory {    
    
    private static final String LOCK_DIR = "var"+File.separatorChar+"lock";     //NOI18N
    
    private static File lockDir;
    
    /** Creates a new instance of NBLockFactory 
     * @throws java.io.IOException 
     */
    public NBLockFactory () throws IOException {
        super (getLockDir());
    }       
    
    /**
     * NEVER call this method! The only place where it's save to
     * call this method is {@link JBrowseModule.restore} to remove
     * orphan locks from previous IDE session.
     */
    public static void clearLocks () {        
        if (!Index.isTest()) {
            final File lockDir = getLockDir();
            final File[] children = lockDir.listFiles();
            if (children != null) {
                for (File child : children) {
                    child.delete();
                }
            }
        }
    }
    
    private static synchronized File getLockDir () {
        if (lockDir == null) {
            final String nbUserDirProp = Index.getNbUserDir();
            assert nbUserDirProp != null;
            File userDir = new File (nbUserDirProp);
            lockDir = FileUtil.normalizeFile(new File (userDir, LOCK_DIR));
            if (!lockDir.exists()) {
                lockDir.mkdirs();
                assert lockDir.isDirectory() && lockDir.canRead() && lockDir.canWrite();
            }
        }        
        return lockDir;
    }
    
}
