/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.refactoring.EntityAssociationResolver;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class provides support for safely deleting a property that
 * is referred by 'mappedBy' annotation attribute value from
 * other classes.
 *
 * @author Erno Mononen
 */
public class EntitySafeDeleteRefactoring implements J2EERefactoring{
    
    private JavaClass javaClass;
    private Feature property;
    private SafeDeleteRefactoring safeDeleteRefactoring;
    /**
     * Creates a new instance of EntitySafeDeleteRefactoring
     */
    public EntitySafeDeleteRefactoring(JavaClass javaClass, Feature property,
            SafeDeleteRefactoring safeDeleteRefactoring) {
        this.javaClass = javaClass;
        this.property = property;
        this.safeDeleteRefactoring = safeDeleteRefactoring;
    }
    
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        
        if (!PersistenceRefactoringUtil.isEntity(javaClass)){
            return null;
        }
        
        JMIUtils.beginJmiTransaction();
        boolean rollback = true;
        try{
            List allEntities = PersistenceRefactoringUtil.getEntitiesInProject(javaClass);
            EntityAssociationResolver resolver = new EntityAssociationResolver(javaClass, allEntities);
            List<EntityAnnotationReference> references = resolver.getMappedByReferences(property);
            
            for (EntityAnnotationReference elem : references) {
                Resource res = elem.getReferring().getResource();
                FileObject fo = JavaModel.getFileObject(res);
                
                RefactoringElementImplementation refactoringElem =
                        new EntitySafeDeleteRefactoringElement(elem,  fo);
                refactoringElementsBag.add(safeDeleteRefactoring, refactoringElem);
            }
            rollback = false;
        } finally {
            JMIUtils.endJmiTransaction(rollback);
        }
        
        return null;
    }
    
    public Problem preCheck() {
        return null;
    }
    
    public Problem checkParameters() {
        return null;
    }
    
    public Problem fastCheckParameters() {
        return null;
    }
    
    /**
     * Safe delete element for entity annotation.
     */
    private static class EntitySafeDeleteRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        private EntityAnnotationReference reference;
        
        public EntitySafeDeleteRefactoringElement(EntityAnnotationReference reference, FileObject parentFile) {
            this.parentFile = parentFile;
            this.reference = reference;
        }
        
          
        public String getDisplayText() {
            Object[] args = new Object [] {reference.getAnnotation().getType().getName(), reference.getReferringProperty().getName()};
            return MessageFormat.format(NbBundle.getMessage(EntitySafeDeleteRefactoring.class, "TXT_EntitySafeDeleteAnnotation"), args);
        }
        
        public void performExternalChange() {
        }
        
        
        public void undoExternalChange() {
        }
        
        public void performChange() {
            JMIUtils.beginJmiTransaction(true);
            boolean rollback = true;
            try{
                // removes the referencing annotation 
                reference.getReferringProperty().getAnnotations().remove(reference.getAnnotation());
                rollback = false;
            } finally {
                JMIUtils.endJmiTransaction(rollback);
            }
        }
        
        private String getStringValue(AttributeValue attributeValue){
            return ((StringLiteral) attributeValue.getValue()).getValue();
        }
    }
}