/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.SunJaxWsXmlElementSupport;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class handles moving of a web service endpoint imlementation class
 * in sun-jaxws.xml (handles only webservices from WSDL file, other types
 * of web services are supported through other means).
 *
 * @author Erno Mononen
 */
public class SunJaxWsXmlMoveClassRefactoring extends JaxWsXmlRefactoringSupport {
    
    /**
     * Creates a new instance of SunJaxWsXmlMoveClassRefactoring
     */
    public SunJaxWsXmlMoveClassRefactoring() {
    }
    
    /**
     * Finds uages in the sun-jaxws.xml
     */
    public Problem prepare(MoveClassRefactoring moveClassRefactor,
            Collection resources, RefactoringElementsBag refactoringElements) {
        
        for (Iterator it = resources.iterator(); it.hasNext();) {
            Resource elem = (Resource) it.next();
            
            for (Iterator it2 = elem.getClassifiers().iterator(); it2.hasNext();) {
                JavaClass javaClass = (JavaClass) it2.next();
                
                if (!isWebSvcFromWsdl(javaClass)){
                    continue;
                }
                
                Endpoints model = getEndpointsModel(javaClass);
                if (model == null){
                    return null;
                }
                
                FileObject sunjaxwsfile = getSunJaxWsXmlFile(javaClass);
                String newName = moveClassRefactor.getTargetPackageName(elem) + "." + javaClass.getSimpleName();
                
                for (Endpoint each : getEndpoints(javaClass)) {
                    RefactoringElementImplementation refactoringElem =
                            new SunJaxWsXmlMoveClassRefactoringElement(javaClass.getName(), newName, model, each, sunjaxwsfile);

                    refactoringElements.add(moveClassRefactor, refactoringElem);
                    
                }
            }
        }
        return null;
    }
    
    /**
     * Move class refactoring element for sun-jaxws.xml
     */
    private static class SunJaxWsXmlMoveClassRefactoringElement extends SunJaxWsXmlElementSupport {
        
        public SunJaxWsXmlMoveClassRefactoringElement(String oldName,  String newName,
                Endpoints model, Endpoint endpoint,  FileObject parentFile) {
            super(oldName, newName, model, endpoint, parentFile);
        }
        
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(SunJaxWsXmlMoveClassRefactoring.class, "TXT_SunJaxWsXmlMoveClass"), args);
        }
        
    }
    
}
