/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.workflow.project.anttasks;

import java.io.File;
import java.util.logging.Logger;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * Generates client WSDL
 * @author Sreenivasan Genipudi
 */
public class CommandlineGenerateWSDLTask extends Task {
    //Member variable representing source directory
    /**
     *  Project name
     */
    private String mProjectname = null;
    //Member variable representing source dir
    private File mSourceDir;
    //Member variable representing build dir
    private File mBuildDir;
    //Member variable representing Client WSDL file.
    private File mClientWSDLFile;
    /**
     * Logger instance
     */
    private Logger logger = Logger.getLogger(CommandlineGenerateWSDLTask.class.getName());

    /**
     * Constructor
     */
    public CommandlineGenerateWSDLTask() {
    }


    /**
     * Set the source directory
     * @param srcDir Source directory
     */
    public void setSourceDirectory(String srcDir) {
  	  this.mSourceDir = new File(srcDir);
    }

    /**
     * Set the build directory
     * @param buildDir build directory
     */
    public void setBuildDirectory(String buildDir) {
    	this.mBuildDir = new File(buildDir);
    }

    /**
     * Set the project name
     * @param String project name
     */
    public void setProjectName(String projectName) {
		this.mProjectname = projectName;
    }

    public void setClientWSDL(String clientWSDL) {
		this.mClientWSDLFile = new File(clientWSDL);
	}

    /**

    /**
     * Generate client WSDL
     */
    public void execute() throws BuildException {

        if(this.mSourceDir == null) {
                throw new BuildException("No directory is set for source files.");
        }

        if(this.mBuildDir == null) {
                throw new BuildException("No build directory is set.");
        }

        if(this.mProjectname== null) {
                throw new BuildException("No Project Name is set.");
        }

        if (this.mClientWSDLFile == null) {
                throw new BuildException("No Client WSDL File is set.");
        }

        WSDLGenerator wsdlGen = new WSDLGenerator();
        wsdlGen.setCommandlineMode(true);
        wsdlGen.generate(this.mProjectname,this.mSourceDir,this.mBuildDir,this.mClientWSDLFile);

    }

}
