/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.impl;

import org.netbeans.modules.wlm.model.api.DeadlineOrDuration;
import org.netbeans.modules.wlm.model.api.TDeadlineExpr;
import org.netbeans.modules.wlm.model.api.TDurationExpr;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.w3c.dom.Element;

public abstract class DeadLineOrDurationImpl extends WLMComponentBase implements
		DeadlineOrDuration {

	public DeadLineOrDurationImpl(WLMModel model, Element e) {
		super(model, e);
		// TODO Auto-generated constructor stub
	}

	public TDeadlineExpr getDeadline() {
		// TODO Auto-generated method stub
		TDeadlineExpr deadline = getChild(TDeadlineExpr.class);
		return deadline;
	}

	public TDurationExpr getDuration() {
		// TODO Auto-generated method stub
		TDurationExpr duration = getChild(TDurationExpr.class);
		return duration;
	}

	public void setDeadline(TDeadlineExpr value) {
		// TODO Auto-generated method stub
		setChild(TDeadlineExpr.class, DEADLINE_PROPERTY, value,
				TypeCollection.EMPTY.types());
	}

	public void setDuration(TDurationExpr value) {
		// TODO Auto-generated method stub
		setChild(TDurationExpr.class, DURATION_PROPERTY, value,
				TypeCollection.EMPTY.types());
	}

	public void removeDuration(TDurationExpr value) {
		removeChild(DURATION_PROPERTY, value);

	}

	public void removeDeadline(TDeadlineExpr value) {
		removeChild(DEADLINE_PROPERTY, value);
	}

	public WLMComponent createChild(Element childEl) {
		// TODO Auto-generated method stub
		WLMComponent child = null;
		if (childEl != null) {
			String localName = childEl.getLocalName();
			if (localName == null || localName.length() == 0) {
				localName = childEl.getTagName();
			}
			if (localName.equals(DEADLINE_PROPERTY)) {
				child = new DeadlineImpl(getModel(), childEl);
			} else if (localName.equals(DURATION_PROPERTY)) {
				child = new DurationImpl(getModel(), childEl);
			}
		}
		return child;
	}
}
