/*
 * WSDLComponentNode.java
 * 
 * Created on Jun 12, 2007, 6:30:29 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.node;

import org.netbeans.modules.worklist.node.cookie.DataObjectCookieDelegate;
import org.netbeans.modules.worklist.node.cookie.WSDLElementCookie;
import org.netbeans.modules.worklist.util.Util;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.xam.Named;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/**
 *
 * @author radval
 */
public class WSDLComponentNode extends AbstractNode {

    private WSDLComponent mComponent;
    
    private InstanceContent mLookupContents;
    
            
     public WSDLComponentNode(WSDLComponent component, 
                             Children children) {
        this(component, children, new InstanceContent());
    }
    
    public WSDLComponentNode(WSDLComponent component, 
                             Children children,
                             InstanceContent contents) {
        super(children, new AbstractLookup(contents));
        this.mComponent = component;
        this.mLookupContents = contents;

        // Add various objects to the lookup.
        // Keep this node and its cookie implementation at the top of the
        // lookup, as they provide cookies needed elsewhere, and we want
        // this node to provide them, not the currently selected node.
        contents.add(this);
        contents.add(new WSDLElementCookie(mComponent));
        // Include the data object in order for the Navigator to
        // show the structure of the current document.
        DataObject dobj = Util.getDataObject(mComponent);
        if (dobj != null) {
            contents.add(dobj);
        }
        contents.add(new DataObjectCookieDelegate(dobj));
        contents.add(mComponent);
        
         updateDisplayName();
    }

    public WSDLComponent getWSDLComponent() {
        return this.mComponent;
    }
    
    /**
     * Determines if this node represents a component that is contained
     * in a valid (non-null) model.
     *
     * @return  true if model is valid, false otherwise.
     */
    protected boolean isValid() {
        return mComponent.getModel() != null;
    }

    /**
     * Used by subclasses to update the display name as needed. The default
     * implementation updates the display name for named WSDL components.
     * Note, this method may be called from the constructor, so be sure to
     * avoid using member variables!
     */
    protected void updateDisplayName() {
        // Need a component connected to a model to work properly.
        if (isValid()) {
            // Automatically keep the name in sync for named components.
            if (mComponent instanceof Named) {
                String name = ((Named) mComponent).getName();
                // Prevent getting an NPE from ExplorerManager.
                super.setName(name == null ? "" : name);
                if (name == null || name.length() == 0) {
                    name = mComponent.getPeer().getLocalName();
                }
                setDisplayName(name);
            }
        }
    }
}
