/*
 * EscalationNode.java
 * 
 * Created on Jun 18, 2007, 5:24:11 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.view.nodes;

import org.netbeans.modules.wlm.model.api.TEscalation;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.node.cookie.WLMComponentCookie;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.util.HelpCtx;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/**
 *
 * @author radval
 */
public class EscalationNode extends org.openide.nodes.AbstractNode {
        
        private static final String HELP_ID_PREFIX=WorklistDataObject.HELP_ID_PREFIX_ASSIGNMENT;
    
        private SectionView view;
        private TEscalation escalation;
        private InstanceContent mLookupContents = new InstanceContent();
    
     
    public EscalationNode(SectionView view, TEscalation escalation, String displayName) {
            this(view, escalation, displayName, new InstanceContent());
    }
    
        public EscalationNode(SectionView view, 
                              TEscalation escalation, 
                              String displayName, 
                              InstanceContent contents) {
            super(org.openide.nodes.Children.LEAF, new AbstractLookup(contents));
            this.view=view;
            this.escalation = escalation;
            this.mLookupContents = contents;
            this.mLookupContents.add(new WLMComponentCookie(escalation));  
            setDisplayName(displayName);
            setIconBaseWithExtension("org/netbeans/modules/worklist/dataloader/wait.gif"); //NOI18N
        }
        public HelpCtx getHelpCtx() {
            return new HelpCtx(HELP_ID_PREFIX+"servletNode"); //NOI18N
        }
        
        public void addToLookup(Object obj) {
            this.mLookupContents.add(obj);
        }
    }
