/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.script.project.wizard.element;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;

import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

/**
 * @author Raghunadh
 * 
 */
final class PanelWSDL<T> extends Panel<T> {
    
  PanelWSDL(Project project, Panel<T> parent) {
    super(project, parent);
    myWebService = new PanelWebService<T>(project, parent);
  }

  @Override
  protected String getComponentName()
  {
    return NAME_WSDL;
  }

  @Override
  protected Panel<T> getNext()
  {
    return new PanelTransformation<T>(getProject(), this, myModel);
  }

  @Override
  protected String getError()
  {
      String error = myWebService.getError();

      if (error != null) {
        return error;
      }
      myModel = (WSDLModel) myWebService.getResult();
    return null;
  }

  @Override
  protected void createPanel(JPanel mainPanel, GridBagConstraints cc)
  {
    JPanel panel = new JPanel(new GridBagLayout());
    GridBagConstraints c = new GridBagConstraints();
    ButtonGroup group = new ButtonGroup();
    c.anchor = GridBagConstraints.WEST;
    c.weighty = 1.0;
    c.gridy++;
    c.weightx = 1.0;
    c.insets = new Insets(0, 0, 0, 0);
    c.fill = GridBagConstraints.HORIZONTAL;
    myWebService.createPanel(panel, c);
    mainPanel.add(panel, cc);
  }
  @Override
  protected void setEnabled(boolean enabled)
  {
    myWebService.setEnabled(enabled);
  }
  private WSDLModel myModel;
  private PanelWebService<T> myWebService;
}
