/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.aspect.project.compapp;

import org.netbeans.api.project.Project;
//import org.netbeans.modules.compapp.projects.jbi.api.InternalProjectTypePlugin;
//import org.netbeans.modules.compapp.projects.jbi.api.InternalProjectTypePluginWizardIterator;

/**
 * Internal Composite Application Project Type plugin.
 * 
 * This is just an example of how to create a plugin for:
 * - an Aspect that contains one "Logging" Advice.
 */
public class AspectProjectType_Logging { //implements InternalProjectTypePlugin {

    private static final String ICON_FILE_BASE = "org/netbeans/modules/aspect/project/compapp/logging.png";
    
    // This name shows up in the CASA palette next to the icon.
    public String getPluginName() {
        return "Logging"; // I18N needed
    }

    // This icon shows up in the CASA palette.
    public String getIconFileBase() {
        return ICON_FILE_BASE;
    }

    // This category name shows up in the CASA palette as the general
    // category for all Aspect plugin types. All Aspect plugins need
    // to return the exact same category name if they wish to be grouped
    // within the same CASA palette category.
    public String getCategoryName() {
        return "Aspect"; // I18N needed
    }

    // The actual project creation is triggered by the wizard iterator.
    // By default, no wizard is shown. However, to display a wizard,
    // the plugin can add custom UI panels and steps to the wizard iterator.
    // The existance of any custom UI panels/steps causes a wizard to be shown.
    // 
    // Note that the project location and name are automatically generated
    // and are not under the control of the plugin.
//    public InternalProjectTypePluginWizardIterator getWizardIterator() {
//        return new InternalAspectProjectTypeWizardIterator_Logging();
//    }

    // This should open up the Aspect Editor for the given project.
    // The plugin framework does not know which editor to use, and does
    // not know which data object within the project corresponds to the editor.
    // Thus, it is up to the plugin to determine this.
    public void openEditor(Project project) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

}
