/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.graph.panels;

import org.netbeans.modules.aspect.editor.model.Aspect;
import org.netbeans.modules.aspect.editor.model.Output;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import org.netbeans.modules.aspect.editor.jaxbmodel.AspectType;
import org.netbeans.modules.aspect.editor.jaxbmodel.OutputType;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;

/**
 *
 * @author  karthikeyan s
 */
public class ChooseOutputPanel extends javax.swing.JPanel {
    
    //private Aspect aspect; JAXB
    private AspectType aspect;
    
    //private Output selectedOutput; JAXB
    private OutputType selectedOutput;
    
    /** Creates new form ChooseOutputPanel */
    public ChooseOutputPanel() {
        initComponents();
        chooseOutputCombo.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                boolean error = true;
                try {
                    String selection = (String) chooseOutputCombo.getSelectedItem();
                    String id = selection.substring(selection.indexOf(":") + 1);
                    //Iterator it = aspect.getOutputs().iterator(); JAXB
                    Iterator it = AspectMapBuilder.getAspectMapBuilder().getOutputList(aspect).iterator();
                    while(it.hasNext()) {
                        //Output out = (Output)it.next(); JAXB
                        OutputType out = (OutputType)it.next();
                        if(out.getID().equalsIgnoreCase(id)) {
                            selectedOutput = out;
                        }
                    }
                    error = false;
                } finally {
                    if(error) {
                        selectedOutput = null;
                    }
                }
            }
        });
    }
    
    //public void populateOutputs(Aspect asp) { JAXB
    public void populateOutputs(AspectType asp) {
        aspect = asp;
        //Iterator it = aspect.getOutputs().iterator(); JAXB
        Iterator it = AspectMapBuilder.getAspectMapBuilder().getOutputList(aspect).iterator();
        while(it.hasNext()) {
            //Output out = (Output)it.next(); JAXB
            OutputType out = (OutputType)it.next();
            chooseOutputCombo.addItem("Output ID:" + out.getID());
        }
    }
    
    //public Output getSelectedOutput() { //JAXB
    public OutputType getSelectedOutput() {
        return selectedOutput;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        chooseOutputCombo = new javax.swing.JComboBox();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(ChooseOutputPanel.class, "ChooseOutputPanel.jLabel1.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 12, Short.MAX_VALUE)
                .add(chooseOutputCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 114, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(chooseOutputCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.JComboBox chooseOutputCombo;
    javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables
    
}
