/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html
 
 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */
package org.netbeans.modules.aspect.editor.dataobject;

import org.netbeans.modules.aspect.editor.graph.AspectEditorPane;
import org.netbeans.modules.aspect.editor.model.AspectMapModel;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.aspect.editor.jaxbmodel.AspectmapType;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class AspectDataObject extends MultiDataObject {
    
    public static final String ASPECT_ICON_BASE_WITH_EXT = "org/netbeans/modules/aspect/editor/resources/aspect.png"; // NOI18N
    
    private AspectDataEditorSupport editorSupport;
    
    private AspectDataNode mNode;
    
    private transient AtomicReference<Lookup> myLookup =
            new AtomicReference<Lookup>();
    
    private transient AtomicBoolean isLookupInit = new AtomicBoolean(false);
    
    private AspectEditorPane editor;

    
    public AspectDataObject(FileObject pf, AspectDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        org.openide.nodes.CookieSet cookies = getCookieSet();
        editorSupport = new org.netbeans.modules.aspect.editor.dataobject.AspectDataEditorSupport(this);
        cookies.add(editorSupport);
        this.editor = getEditor();
    }
    
    public Node createNodeDelegate() {
        if(this.mNode == null) {
            this.mNode = new AspectDataNode(this);
        }
        return this.mNode;
    }
    
    /**
     * subclasses should look updateServices() and additionalInitialLookup()
     */
    public final Lookup getLookup() {
        if (myLookup.get() == null) {
            
            Lookup lookup;
            List<Lookup> list = new LinkedList<Lookup>();
            
            list.add(Lookups.fixed( new Object[]{this}));
            lookup = new ProxyLookup(list.toArray(new Lookup[list.size()]));
            myLookup.compareAndSet(null, lookup);
            isLookupInit.compareAndSet( false, true );
        }
        return myLookup.get();
    }
    
    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified) {
            getCookieSet().add(getSaveCookie());
        } else {
            getCookieSet().remove(getSaveCookie());
        }
    }
    
    private SaveCookie getSaveCookie() {
        return new SaveCookie() {
            public void save() throws IOException {
                getAspectDataEditorSupport().synchDocument();
                getAspectDataEditorSupport().saveDocument();
            }
            
            @Override
            public int hashCode() {
                return getClass().hashCode();
            }
            
            @Override
            public boolean equals(Object other) {
                return getClass().equals(other.getClass());
            }
        };
    }
    
    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        AspectDataObject dataObject = (AspectDataObject) super.handleCreateFromTemplate(df, name);
        String doName = dataObject.getName();
        //make sure the the name is a valid NMTOKEN.
        if (!XMLChar.isValidNmtoken(doName)) {
            return dataObject;
        }
        
        SaveCookie sCookie = (SaveCookie) dataObject.getCookie(SaveCookie.class);
        if(sCookie != null) {
            sCookie.save();
        }
        return dataObject;
    }
    
    public AspectEditorPane getEditor() {
    if (this.editor == null)
    {
        this.editor = new org.netbeans.modules.aspect.editor.graph.AspectEditorPane(this);
    }

        return this.editor;
    }   
    
    //public AspectMapModel getModel() { JAXB
    public AspectmapType getModel() {
        return getEditor().getModel();
    }
    
    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public AspectDataEditorSupport getAspectDataEditorSupport() {
        return editorSupport;
    }
}
