/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.xpath.view.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.bpel.xpath.model.node.visitor.*;
import org.netbeans.modules.bpel.xpath.model.nodes.BooleanPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.BranchesPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.CatchNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DeadlinePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DurationPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.FinalCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.ForEachNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PredicatePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.RootPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.ScopeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StandardRootNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StartCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariablesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLocationStepNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicateNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicatesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDAttributeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDComplexTypeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDElementNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDSimpleTypeNode;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.search.WildcardStringMatcher;

/**
 *
 * @author jsandusky
 */
public class NodeSearchVisitor extends AbstractNodeVisitor {
    
    private List<Component> mResults;
    
    /** The last query submitted by the user, if any, lower-cased. */
    private String mPhrase;
    /** True if the phrase contains wildcards (e.g. * or ?). */
    private boolean mIsWildcarded;
    /** The compiled regular expression pattern, if provided. */
    private Pattern mPattern;
    
    private NodeDisplayNameGeneratorVisitor mNameVisitor;
    
    
    /** Creates a new instance of NodeSearchVisitor */
    public NodeSearchVisitor(String phrase, boolean wildcarded, Pattern pattern) {
        mPhrase = phrase;
        mIsWildcarded = wildcarded;
        mPattern = pattern;
        
        mResults = new ArrayList<Component>();
        mNameVisitor = new NodeDisplayNameGeneratorVisitor();
    }
    
    public List<Component> getResults() {
        return mResults;
    }
    
    public void clear() {
        mResults.clear();
    }
    
    
    public void visit(ScopeNode node) {
        visitTreeNode(node);
    }
    
    public void visit(ForEachNode node) {
        visitTreeNode(node);
    }

    public void visit(CatchNode node) {
        visitTreeNode(node);
    }

    public void visit(StandardRootNode node) {
        visitTreeNode(node, false);
    }
    
    public void visit(VariablesNode node) {
        visitTreeNode(node);
    }
    
    public void visit(VariableNode node) {
        visitTreeNode(node);
    }
    
    public void visit(PartNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDAttributeNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDElementNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDComplexTypeNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDSimpleTypeNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XPathPredicateNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XPathPredicatesNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XPathLocationStepNode node) {
        visitTreeNode(node);
    }
    
    public void visit(BooleanPlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(StartCounterValuePlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(FinalCounterValuePlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(BranchesPlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(DeadlinePlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(DurationPlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(PredicatePlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(RootPlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    
    private void visitTreeNode(TreeNode node) {
        visitTreeNode(node, true);
    }
    
    private void visitTreeNode(TreeNode node, boolean isFindingMatch) {
        if (isFindingMatch) {
            findMatch(node);
        }
        visitChildren(node);
    }

    private void findMatch(TreeNode node) {
        mNameVisitor.clear();
        node.accept(mNameVisitor);
        String name = mNameVisitor.getDisplayName();
        if (name != null) {
            if (mPhrase != null) {
                name = name.toLowerCase();
                if (mIsWildcarded) {
                    if (WildcardStringMatcher.match(name, mPhrase)) {
                        mResults.add((Component) node.getDataObject());
                    }
                } else if (name.indexOf(mPhrase) > -1) {
                    mResults.add((Component) node.getDataObject());
                }
            } else if (mPattern != null) {
                Matcher matcher = mPattern.matcher(name);
                if (matcher.find()) {
                    mResults.add((Component) node.getDataObject());
                }
            }
        }
    }
    
    private void visitChildren(TreeNode node) {
        for (Iterator iter=node.getChildren().iterator(); iter.hasNext();) {
            TreeNode child = (TreeNode) iter.next();
            child.accept(this);
        }
    }
}
