/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.output;

import java.awt.BorderLayout;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.soa.ui.nodes.InstanceRef;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.xpath.view.AbstractBPELElementExpressionView;
import org.netbeans.modules.bpel.xpath.view.BPELExpressionViewFactory;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;
import org.netbeans.modules.bpel.xpath.view.impl.DefaultExpressionView;
import org.netbeans.modules.bpel.xpath.view.search.MapperCategoryPane;
import org.netbeans.modules.soa.mapper.basicmapper.palette.BasicMapperPalette;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteView;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

/**
 *
 * @author jsandusky
 */
public class DesignContextChanger {

    private MapperCategoryPane mCategoryPane = new MapperCategoryPane();
    private static TopComponent mEmptyTC = new EmptyTopComponent();
    private AbstractBPELElementExpressionView mExpressionView;
    private BpelEntity mCurrentEntity;
    
    private DesignContextSynchronizationListener mSyncListener;
    
    
    public DesignContextChanger() {
        mSyncListener = new DesignContextSynchronizationListener(this);
    }
    
    
    public void designContextChanged(final BpelEntity entity) {
        if (entity == mCurrentEntity) {
            // We are already showing this entity, no need to reload.
            return;
        }
        
        mCurrentEntity = entity;
        
        if (entity != null) {
            ResultWindow.getInstance().setCurrentBpelModel(entity.getBpelModel());
        } else {
            ResultWindow.getInstance().setCurrentBpelModel(null);
        }
        
        Runnable run = new Runnable() {
            public void run() {
                
                if (mExpressionView != null) {
                    cleanupControllerThreads();
                    mExpressionView = null;
                }
                
                if (entity != null) {
                    showBpelDesignerTcGroup(BPELExpressionViewFactory
                            .getInstance().hasBPELExpressionView(entity));
                    
                    if (ResultWindow.getInstance().isShowing() 
                            || isSlidingSide()) 
                    {
                        reloadEditor();
                    }
                    
                } else {
                    ResultWindow.getInstance().addDisplayComponent(mEmptyTC);
                    showBpelDesignerTcGroup(false);
                }
            }
        };
        
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }
    
    public void reloadEditor() {
        if (mCurrentEntity == null) {
            return;
        }
        
        mExpressionView =
                BPELExpressionViewFactory.getInstance().getBPELExpressionView(mCurrentEntity);
        if (mExpressionView != null) {
            
            // If the views are cached, we'd need to re-initialize
            // them with the selected entity and model.
            //mExpressionView.initialize(mCurrentEntity);
            
            mCategoryPane.setCategory(mExpressionView);
            ResultWindow.getInstance().addDisplayComponent(mCategoryPane.getComponent());
            
            // Renders the expression onto the canvas (creates the nodes/links).
            mExpressionView.synchronizeExpressionView(mCurrentEntity, null);
            
            mSyncListener.setSynchronization(mExpressionView, mCurrentEntity.getBpelModel());
            
            // check if bpel model is writable or not
            if (isMapperWritable(mCurrentEntity.getBpelModel())) {
                setMappingEnable(mExpressionView, true);
            } else {
                setMappingEnable(mExpressionView, false);
            }
            
            updateTitle();
        }
    }
    
    private void cleanupControllerThreads() {
        // Stop the previous Mapper Controller Event Invoker thread
        List<MapperView> mappers = mExpressionView.getMappers();
        if ((mappers != null) && !mappers.isEmpty()) {
            for (MapperView mapperView : mappers) {
                if ((mapperView != null)
                && (mapperView.getBasicMapper() != null)) {
                    mapperView.getBasicMapper().close();
                }
            }
        }
    }
    
    public void setSynchronizationListenerEnable(boolean isEnabled) {
        mSyncListener.setEnabled(isEnabled);
    }
    
    
    
    private boolean isSlidingSide() {
        return isSlidingSide(
                WindowManager.getDefault(), 
                ResultWindow.getInstance());
    }
    
    
    private boolean isSlidingSide(WindowManager wm, ResultWindow resultWindow) {
        String modeName = (wm.findMode(resultWindow) != null)
                ? wm.findMode(resultWindow).getName() : null; 
        
        return modeName != null && modeName.endsWith("SlidingSide"); // NOI18N
    }
    
    /**
     *  Open or close the bpel_mapper_window_group TopComponentGroup.
     */
    public void showBpelDesignerTcGroup(final boolean show) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                WindowManager wm = WindowManager.getDefault();
                final TopComponentGroup group =
                        wm.findTopComponentGroup("bpel_mapper_window_group"); // NOI18N
                if (group != null) {
                    if (show) {
                        group.open();
                        // The mapper may open but in a hidden state, ensure it
                        // is not hidden.
                        ResultWindow resWindow = ResultWindow.getInstance();
                        if (isSlidingSide(wm, resWindow)) {
                            // If mapper docked to right/left/bottom Sliding Side
                            // it can be visible only when active
                            resWindow.requestActive();
                        } else {
                            resWindow.requestVisible();
                        }
                    } else {
                        group.close();
                    }
                }
            }
        });
    }
    
    public boolean isDefaultExpressionView() {
        return mExpressionView instanceof DefaultExpressionView;
    }
        
    public boolean isMapperWritable(BpelModel model) {
        boolean writable = false;
        if (model != null) {
            writable = XAMUtils.isWritable(model);
        }
        return writable;
    }
    
    public void setMappingEnable(boolean mode) {
        if (mExpressionView != null) {
            setMappingEnable(mExpressionView, mode);
        }
    }
    
    private void setMappingEnable(final AbstractBPELElementExpressionView view, final boolean mode) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                if (view != null) {
                    List<MapperView> mappers = view.getMappers();
                    IPaletteView pView = null;
                    if ((mappers != null) && !mappers.isEmpty()) {
                        for (MapperView mapperView : mappers) {
                            if ((mapperView != null)
                            && (mapperView.getBasicMapper() != null)) {
                                // disables mapping for canvas, src, and dest view
                                mapperView.getBasicMapper().setMappingEnable(mode);
                                
                                // disables palette view
                                pView = mapperView.getBasicMapper().getMapperViewManager().getPaletteView();
                                if ((pView != null) && (pView instanceof BasicMapperPalette)) {
                                    ((BasicMapperPalette) mapperView.getBasicMapper().getMapperViewManager().
                                            getPaletteView()).setEnabled(mode);
                                }
                            }
                        }
                    }
                }
            }
        });
    }
    
    public void updateTitle() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (
                nodes != null && 
                nodes.length == 1 &&
                nodes[0] instanceof InstanceRef)
        {
            Object entity = ((InstanceRef) nodes[0]).getReference();
            if (entity instanceof BpelEntity) {
                ResultWindow.getInstance().setDisplayName(
                        ResultWindow.getTitleBase() + " - " +   // NOI18N
                        nodes[0].getDisplayName());
                return;
            }
        }
        ResultWindow.getInstance().setDisplayName(ResultWindow.getTitleBase());
    }
    
    public MapperCategoryPane getCategoryPane() {
        return mCategoryPane;
    }
    

    private static class  EmptyTopComponent extends TopComponent {
        public EmptyTopComponent() {
            this.setLayout(new BorderLayout());
        }
        protected void componentClosed() {
            super.componentClosed();
        }
        protected void componentOpened() {
            super.componentOpened();
        }
    }
}
