/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;

import java.util.Iterator;
import java.util.logging.Level;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeTreePathBuilderVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.BranchesPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.FinalCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StartCounterValuePlaceHolderNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;
import org.netbeans.modules.bpel.xpath.model.nodes.RootPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;
import org.openide.util.NbBundle;

/**
 *
 * @author jsandusky
 *
 */
public class ForEachRenderer extends AbstractRenderer {
    
    private IMapperTreeNode mStartCounterValueTreeNode;
    private IMapperTreeNode mFinalCounterValueTreeNode;
    private IMapperTreeNode mBranchesValueTreeNode;
    private IMapperTreeNode mCurrentValueTreeNode;
    private ExpressionRenderer mExpressionRenderer;
    private ForEach mElementToRender;
    
    
    public ForEachRenderer(MapperView mapper, BpelEntity holdingEntity) {
        super(mapper);
        
        mExpressionRenderer = new ExpressionRenderer(mapper, holdingEntity) {
            protected Object getLinkObject() {
                return mElementToRender;
            }
            protected IMapperTreeNode getTargetTreeNode() {
                return mCurrentValueTreeNode;
            }
        };
    }
    
    public void draw(Object element) {
        if (!(element instanceof ForEach)) {
            return;
        }
        
        mElementToRender = (ForEach) element;
        
        setupRenderTreeNodes();
        
        if (mElementToRender.getStartCounterValue() != null) {
            drawStartValue(mElementToRender.getStartCounterValue());
        }
        
        if (mElementToRender.getFinalCounterValue() != null) {
            drawFinalValue(mElementToRender.getFinalCounterValue());
        }
        
        if (
                mElementToRender.getCompletionCondition() != null &&
                mElementToRender.getCompletionCondition().getBranches() != null) {
            drawBranchesValue(mElementToRender.getCompletionCondition().getBranches());
        }
        
        layout();
    }
    
    private void drawStartValue(StartCounterValue value) {
        mCurrentValueTreeNode = mStartCounterValueTreeNode;
        try {
            mExpressionRenderer.draw(value.getContent());
        } catch(Exception ex) {
            LOGGER.log(Level.SEVERE,
                    NbBundle.getMessage(ForEachRenderer.class,
                        "STR_FAIL_TO_RENDER_X", // NOI18N
                        value), ex);
        }
    }
    
    private void drawFinalValue(FinalCounterValue value) {
        mCurrentValueTreeNode = mFinalCounterValueTreeNode;
        try {
            mExpressionRenderer.draw(value.getContent());
        } catch(Exception ex) {
            LOGGER.log(Level.SEVERE,
                    NbBundle.getMessage(ForEachRenderer.class,
                        "STR_FAIL_TO_RENDER_X", // NOI18N
                        value), ex);
        }
    }
    
    private void drawBranchesValue(Branches value) {
        mCurrentValueTreeNode = mBranchesValueTreeNode;
        try {
            mExpressionRenderer.draw(value.getContent());
        } catch(Exception ex) {
            LOGGER.log(Level.SEVERE,
                    NbBundle.getMessage(ForEachRenderer.class,
                        "STR_FAIL_TO_RENDER_X", // NOI18N
                        value), ex);
        }
    }
    
    private void setupRenderTreeNodes() {
        IMapperTreeView destView = getMapper().getMapperViewManager().getDestView();
        RootPlaceHolderNode root = (RootPlaceHolderNode) destView.getTree().getModel().getRoot();
        for (Iterator iter = root.getChildren().iterator(); iter.hasNext();) {
            TreeNode targetTreeNode = (TreeNode) iter.next();
            if        (targetTreeNode instanceof StartCounterValuePlaceHolderNode) {
                NodeTreePathBuilderVisitor ntpBuilder = new NodeTreePathBuilderVisitor();
                targetTreeNode.accept(ntpBuilder);
                mStartCounterValueTreeNode = destView.getMapperTreeNode(ntpBuilder.getTreePath());
            } else if (targetTreeNode instanceof FinalCounterValuePlaceHolderNode) {
                NodeTreePathBuilderVisitor ntpBuilder = new NodeTreePathBuilderVisitor();
                targetTreeNode.accept(ntpBuilder);
                mFinalCounterValueTreeNode = destView.getMapperTreeNode(ntpBuilder.getTreePath());
            } else if (targetTreeNode instanceof BranchesPlaceHolderNode) {
                NodeTreePathBuilderVisitor ntpBuilder = new NodeTreePathBuilderVisitor();
                targetTreeNode.accept(ntpBuilder);
                mBranchesValueTreeNode = destView.getMapperTreeNode(ntpBuilder.getTreePath());
            }
        }
    }
    
}
