/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.expression.literal;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;
import org.netbeans.modules.bpel.xpath.view.output.ResultWindow;

import org.openide.util.NbBundle;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IField;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasMouseData;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasMouseListener;


/**
 * Handles popup menus when the user right-clicks on a field node
 * in the mapper canvas.
 *
 * @author jsandusky
 */
public class BpelMapperPopupSupport 
implements ICanvasMouseListener, ActionListener {

    private static final String MENU_LITERAL_ADD    = "STR_FIELD_LITERAL_ADD";  // NOI18N
    private static final String MENU_LITERAL_EDIT   = "STR_FIELD_LITERAL_EDIT"; // NOI18N
    private static final String MENU_LITERAL_DELETE = "STR_FIELD_LITERAL_DELETE";   // NOI18N

    private MapperView mMapperView;
    private Component mComponent;
    private IFieldNode mFieldNode;
    private JMenuItem mAddMenuItem;
    private JMenuItem mEditMenuItem;
    private JMenuItem mDeleteMenuItem;
    
    
    public BpelMapperPopupSupport(MapperView mapperView, Component component) {
        mMapperView = mapperView;
        mComponent = component;
    }
    
    
    public void actionPerformed(ActionEvent avt) {
        String cmd = avt.getActionCommand();
        if        (MENU_LITERAL_EDIT.equals(cmd) || MENU_LITERAL_ADD.equals(cmd)) {
            String literalType = mFieldNode.getTypeName();
            ILiteralUpdater updater = 
                mMapperView.getLiteralUpdaterFactory().createLiteralUpdater(literalType);
            updater.getEditor(mMapperView.getBasicMapper(), mFieldNode).show();
            mFieldNode = null;
            
        } else if (MENU_LITERAL_DELETE.equals(cmd)) {
            IField field = (IField) mFieldNode.getFieldObject();
            field.getLiteralUpdater().literalUnset(mFieldNode);
            mFieldNode = null;
        }
    }
    
    private JMenuItem getAddMenuItem() {
        if (mAddMenuItem == null) {
            mAddMenuItem = new JMenuItem(NbBundle.getMessage(getClass(), MENU_LITERAL_ADD));
            mAddMenuItem.addActionListener(this);
            mAddMenuItem.setActionCommand(MENU_LITERAL_ADD);
        }
        return mAddMenuItem;
    }
    
    private JMenuItem getEditMenuItem() {
        if (mEditMenuItem == null) {
            mEditMenuItem = new JMenuItem(NbBundle.getMessage(getClass(), MENU_LITERAL_EDIT));
            mEditMenuItem.addActionListener(this);
            mEditMenuItem.setActionCommand(MENU_LITERAL_EDIT);
        }
        return mEditMenuItem;
    }
    
    private JMenuItem getDeleteMenuItem() {
        if (mDeleteMenuItem == null) {
            mDeleteMenuItem = new JMenuItem(NbBundle.getMessage(getClass(), MENU_LITERAL_DELETE));
            mDeleteMenuItem.addActionListener(this);
            mDeleteMenuItem.setActionCommand(MENU_LITERAL_DELETE);
        }
        return mDeleteMenuItem;
    }
    
    private JPopupMenu createFieldPopup(List menuItems) {
        JPopupMenu menu = new JPopupMenu();
        for (Iterator iter=menuItems.iterator(); iter.hasNext();) {
            Component item = (Component) iter.next();
            menu.add(item);
        }
        return menu;
    }
    
    private boolean showFieldPopupMenuAtPoint(Point point) {
        ICanvasFieldNode canvasFieldNode = 
            mMapperView.getMapperViewManager().getCanvasView().
            getCanvas().getCanvasFieldNodeByPoint(point);
        if (canvasFieldNode == null) {
            return false;
        }
        
        IFieldNode fieldNode = canvasFieldNode.getFieldNode();
        if (fieldNode == null) {
            return false;
        }
        IField field = (IField) fieldNode.getFieldObject();
        if (field == null) {
            return false;
        }
        
        if (field.getLiteralUpdater() == null) {
            return false;
        }

        mFieldNode = fieldNode;
        IMethoidNode methoidNode = (IMethoidNode) mFieldNode.getGroupNode();
        IMethoid methoid = (IMethoid) methoidNode.getMethoidObject();
        List items = new ArrayList();
        
        if (methoid.isLiteral()) {
            // literal methoid, can only edit current literal
            items.add(getEditMenuItem());
        } else {
            if (fieldNode.hasInPlaceLiteral()) {
                // existing in-place literal, can edit and delete
                items.add(getEditMenuItem());
                items.add(getDeleteMenuItem());
            } else {
                // no existing in-place literal, can only add
                items.add(getAddMenuItem());
            }
        }
        JPopupMenu menu = createFieldPopup(items);
        menu.show(mComponent, point.x, point.y);
        
        return true;
    }
    
    public void handleRightClick(Point location) {
        boolean enable = true;
        
        // show popup only if bpel model is writable        
        if (!ResultWindow.getInstance().getDesignContextChangeListener().
                getDesignContextChanger().isMapperWritable(mMapperView.getBPELDocument())) {
            enable = false;
        }
        
        if (enable) {
            showFieldPopupMenuAtPoint(location);
        }
    }
    
    
    // CANVAS MOUSE LISTENER
    public boolean doMouseClick(ICanvasMouseData event) {
        int mods = event.getMouseModifier();
        if ((mods & InputEvent.BUTTON1_MASK) == 0) {
            handleRightClick(event.getViewLocation());
            return true;
        }
        return false;

    }
    public boolean doMouseDblClick(ICanvasMouseData event) {
        return false;
    }
    public boolean doMouseDown(ICanvasMouseData event) {
        return false;
    }
    public boolean doMouseMove(ICanvasMouseData event) {
        return false;
    }
    public boolean doMouseUp(ICanvasMouseData event) {
        return false;
    }
}
