/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.xml.wsdl.model.Message;

import org.openide.util.NbBundle;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperRule;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.IMapperEvent;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.bpel.xpath.model.nodes.BuiltInXSDTypes;
import org.netbeans.modules.bpel.xpath.model.nodes.RootPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.view.expression.impl.BpelMapper;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperUtil;
import org.netbeans.modules.bpel.xpath.view.output.ResultWindow;

/**
 * 
 * @author radval
 *
 */
public class DefaultMapperRuleDelegate implements IBasicMapperRule {

	private static final Logger LOGGER = Logger.getLogger(DefaultMapperRuleDelegate.class.getName());
	
	private BpelMapper mMapper;
	private Set mValidDataTypes = new HashSet();
        
        private static final boolean DO_TYPE_CHECKING = false;
	
        
	public DefaultMapperRuleDelegate(BpelMapper delegate) {
		this.mMapper = delegate;
		init();
	}
        
	public IBasicMapper getMapper() {
		return this.mMapper.getBasicMapper();
	}

	public boolean isAllowToCreate(IMapperLink link) {
		BpelEntity selection = mMapper.getSelectedElement();
        
        
        IMapperNode endNode = (IMapperNode) link.getEndNode();
        if (endNode instanceof IFieldNode) {
            int linkCount = ((IFieldNode) endNode).getLinkCount();
            if (linkCount != 0) {
                return false;
            }
        }
        
        if(endNode instanceof IMapperTreeNode) {
        	IMapperTreeNode mapperTreeNode = (IMapperTreeNode) endNode;
	        if(mapperTreeNode.getPath().getLastPathComponent() instanceof RootPlaceHolderNode) {
	        	return false;
	        }
        }
        
        IMapperNode startNode = (IMapperNode) link.getStartNode();
        if (startNode instanceof IFieldNode) {
            int linkCount = ((IFieldNode) startNode).getLinkCount();
            if (linkCount != 0) {
                return false;
            }
        }
        
        if ((mMapper != null) && (selection != null)) {
            if (ResultWindow.getInstance().getDesignContextChangeListener().
                    getDesignContextChanger().isMapperWritable(selection.getBpelModel())) {
                ResultWindow.getInstance().getDesignContextChangeListener().
                        getDesignContextChanger().setMappingEnable(true);
            } else {
                ResultWindow.getInstance().getDesignContextChangeListener().
                        getDesignContextChanger().setMappingEnable(false);
                return false;
            }
        }           
        return (link != null
                && isValidMapperSrcAndDest(link)
                && areCompatibleNodes(link)
                && this.isOKToConnectToEnd(link, selection));


	}

    public boolean isAllowToCreate(IMapperNode node) {
        boolean allow = true;
        if ((mMapper != null) && (mMapper.getSelectedElement() != null)) {
            if (ResultWindow.getInstance().getDesignContextChangeListener().
                    getDesignContextChanger().isMapperWritable(mMapper.getSelectedElement().getBpelModel())) {
                ResultWindow.getInstance().getDesignContextChangeListener().
                        getDesignContextChanger().setMappingEnable(true);
            } else {
                ResultWindow.getInstance().getDesignContextChangeListener().
                        getDesignContextChanger().setMappingEnable(false);
                allow = false;
            }
        }
        return allow;
    }

    public boolean isAllowToRemove(IMapperLink link) {
        boolean allow = true;
        if ((mMapper != null) && (mMapper.getSelectedElement() != null)) {
            if (ResultWindow.getInstance().getDesignContextChangeListener().
                    getDesignContextChanger().isMapperWritable(mMapper.getSelectedElement().getBpelModel())) {
                ResultWindow.getInstance().getDesignContextChangeListener().
                        getDesignContextChanger().setMappingEnable(true);                    
            } else {
                ResultWindow.getInstance().getDesignContextChangeListener().
                        getDesignContextChanger().setMappingEnable(false);
                allow = false;
            }
        }
        return allow;
    }

    public boolean isAllowToRemove(IMapperNode node) {
        boolean allow = true;
        if ((mMapper != null) && (mMapper.getSelectedElement() != null)) {
            if (ResultWindow.getInstance().getDesignContextChangeListener().
                    getDesignContextChanger().isMapperWritable(mMapper.getSelectedElement().getBpelModel())) {
                ResultWindow.getInstance().getDesignContextChangeListener().
                        getDesignContextChanger().setMappingEnable(true);
            } else {
                ResultWindow.getInstance().getDesignContextChangeListener().
                        getDesignContextChanger().setMappingEnable(false);
                allow = false;
            }
        }
        return allow;
    }

	public void eventInvoked(IMapperEvent e) {
		// TODO Auto-generated method stub
		
	}

	
	private void init() {

        if (!mValidDataTypes.isEmpty()) {
            return;
        }
        mValidDataTypes.add(BuiltInXSDTypes.STRING_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.BOOLEAN_TYPE);

        mValidDataTypes.add(BuiltInXSDTypes.DECIMAL_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.FLOAT_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.DOUBLE_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.LONG_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.INT_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.SHORT_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.BYTE_TYPE);

        mValidDataTypes.add(BuiltInXSDTypes.DURATION_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.DATE_TIME_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.TIME_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.DATE_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.YEAR_MONTH_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.YEAR_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.MONTH_DAY_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.DAY_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.MONTH_TYPE);

        mValidDataTypes.add(BuiltInXSDTypes.HEX_BINARY_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.BASE64_BINARY_TYPE);

        mValidDataTypes.add(BuiltInXSDTypes.ANYURI_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.QNAME_TYPE);
        mValidDataTypes.add(BuiltInXSDTypes.NOTATION_TYPE);

        mValidDataTypes.add(BuiltInXSDTypes.ANY_TYPE);
    }

	
	/**
     * Describe <code>isValidMapperSrcAndDest</code> method here.
     *
     * @param link an <code>IMapperLink</code> value
     * @return a <code>boolean</code> value
     */
    private boolean isValidMapperSrcAndDest(IMapperLink link) {
        IMapperNode srcNode = link.getStartNode();
        IMapperNode destNode = link.getEndNode();
        // if the src and destination are the same return false.
        if (srcNode == destNode || srcNode == null || destNode == null) {
            return false;
        }
        // src or dest is containers Root Node return false;
        if (srcNode instanceof IMapperTreeNode
            && (((IMapperTreeNode) srcNode).getPath()
                .getLastPathComponent() instanceof VariableContainer)) {
            return false;
        }
        if (destNode instanceof IMapperTreeNode
            && (((IMapperTreeNode) destNode).getPath()
                .getLastPathComponent() instanceof VariableContainer)) {

            return false;
        }
        if (!(srcNode instanceof IMapperTreeNode)
            && !(destNode instanceof IMapperTreeNode))  {
            // Check if the link causes loop
            List forwardGroupNodes = new ArrayList();
            getForwardGroupNodeList(destNode, forwardGroupNodes);
            Object groupNode = srcNode.getGroupNode();

            return !(forwardGroupNodes.contains(groupNode));
        }
        // variable to a leaf node is invalid
        if (srcNode instanceof IMapperTreeNode
            && (((IMapperTreeNode) srcNode).getPath()
                .getLastPathComponent() instanceof Variable)
            && destNode instanceof IMapperTreeNode
            && (((IMapperTreeNode) destNode).getPath()
                .getLastPathComponent() instanceof TreeNode)) {
			
        	TreeNode dNode = (TreeNode) ((IMapperTreeNode) destNode).getPath()
                .getLastPathComponent();
            return !(dNode.getChildren().size() == 0);
        }
        // leaf to a Variable is invalid
        if (destNode instanceof IMapperTreeNode
            && (((IMapperTreeNode) destNode).getPath()
                .getLastPathComponent() instanceof Variable)
            &&  srcNode instanceof IMapperTreeNode
            && (((IMapperTreeNode) srcNode).getPath()
                .getLastPathComponent() instanceof TreeNode)) {

            TreeNode sNode = (TreeNode) ((IMapperTreeNode) srcNode).getPath()
                .getLastPathComponent();
            return !sNode.isLeaf();
        }
        // dest node of boolean tree root node is not allowed
        if (destNode instanceof IMapperTreeNode) {
            IMapperTreeNode dNode = (IMapperTreeNode) destNode;
            Object node = dNode.getPath().getLastPathComponent();
            if (node instanceof DefaultMutableTreeNode) {
                return !((DefaultMutableTreeNode) node).isRoot();
            }
        }
        // xsd any is not supported
        // com.sun.bpel.model.common.model.xsd.CastorSupport.ANY (xsd type any )node 
        // is not allowed. either src or destination node is of this type, the assign is disabled
        if (srcNode instanceof IMapperTreeNode || destNode instanceof IMapperTreeNode) {

            Object sNode = null;
            if (srcNode instanceof IMapperTreeNode) {
                IMapperTreeNode sTreeNode = (IMapperTreeNode) srcNode;
                sNode = sTreeNode.getPath().getLastPathComponent();
            }
            Object dNode = null;
            if (destNode instanceof IMapperTreeNode) {
                IMapperTreeNode dTreeNode = (IMapperTreeNode) destNode;
                dNode = dTreeNode.getPath().getLastPathComponent();
            }
            /*
            if (sNode != null && sNode instanceof TreeNode) {
            	TreeNode sMNode = (TreeNode) sNode;
            	if(CastorSupport.ANY_ATTRIBUTE.equals(sMNode.getName())
       				 || CastorSupport.ANY_ELEMENT.equals(sMNode.getName())) {
            		return false;
            	}
            }
            
            if(dNode != null && dNode instanceof TreeNode) {
            	TreeNode dMNode = (TreeNode) dNode;
            	if(CastorSupport.ANY_ATTRIBUTE.equals(dMNode.getName())
    			   || CastorSupport.ANY_ELEMENT.equals(dMNode.getName()))  {
            		return false;
            	}
            }*/
            
        }
        return true;
    }
    
    
    /**
     * checks for compatibility only if the nodes are leaves and if either one of
     * are of the data types that are defined in the DatatTypeHandler.
     *
     * @param link an <code>IMapperLink</code> value
     * @return a <code>boolean</code> value
     */
    private boolean areCompatibleNodes(IMapperLink link) {

        IMapperNode srcNode = link.getStartNode();
        IMapperNode destNode = link.getEndNode();

        TreeNode srcMNode = null;
        TreeNode destMNode = null;
        if (
                srcNode instanceof IMapperTreeNode && 
                (((IMapperTreeNode) srcNode).getPath().getLastPathComponent() instanceof VariableNode)) {
        } else if (
                srcNode instanceof IMapperTreeNode && 
                (((IMapperTreeNode) srcNode).getPath().getLastPathComponent() instanceof TreeNode)) {
            srcMNode = (TreeNode) ((IMapperTreeNode) srcNode).getPath().getLastPathComponent();
        }

        if (
                destNode instanceof IMapperTreeNode && 
                (((IMapperTreeNode) destNode).getPath().getLastPathComponent() instanceof VariableNode)) {
        } else if (
                destNode instanceof IMapperTreeNode && 
                (((IMapperTreeNode) destNode).getPath().getLastPathComponent() instanceof TreeNode)) {
            destMNode = (TreeNode) ((IMapperTreeNode) destNode).getPath().getLastPathComponent();
        }

        if ((srcMNode == null || destMNode == null)
            || !(srcMNode instanceof TreeNode && destMNode instanceof TreeNode)) {
            return true;
        }

        boolean dummyVar =  false;
        if (DO_TYPE_CHECKING && isEmpty(srcMNode.getXSDType())) {
            String error = srcMNode.getName() + " "
                + NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                                      "MISSING_MAPPING_INFORMATION");   // NOI18N
            LOGGER.warning(error);
            dummyVar = true;
        }
        if (DO_TYPE_CHECKING && isEmpty(destMNode.getXSDType())) {
            String error = destMNode.getName() + " "
                + NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                                      "MISSING_MAPPING_INFORMATION");   // NOI18N
            LOGGER.warning(error);
            if (dummyVar) {
                return true;
            }
        }
        // non-leaf to leaf only allow mapping only if boolean and string
        if (!srcMNode.isLeaf() && destMNode.isLeaf()) {
            if (isEmpty(destMNode.getXSDType())) {
                return true;
            } else if (destMNode.getXSDType().equals(BuiltInXSDTypes.STRING_TYPE)
                       || destMNode.getXSDType().equals(BuiltInXSDTypes.BOOLEAN_TYPE)) {
                return true;
            } else {
                return false;
            }
        }
        
        // leaf to non-leaf not allowed.
        if (srcMNode.isLeaf() && !destMNode.isLeaf()) {
            return false;
        }
        
        // source and destination both are non-leaf nodes.
        // if non-compatible types, (the definition of non-compatible is
        // very restrictive here) then display a warning.
        if (!srcMNode.isLeaf() && !destMNode.isLeaf()) {
            if (!areCompatibleNonLeafNodes((IMapperTreeNode) srcNode, srcMNode.getXSDType()
                                           , (IMapperTreeNode) destNode, destMNode.getXSDType())) {

                String error = NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                                                   "MAPPING_INCOMPATIBLE_DATA_TYPES");  // NOI18N
                LOGGER.severe(error);
                /*
                  JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), error,
                  "Warning", JOptionPane.WARNING_MESSAGE);
                */
                MapperUtil.displayWarningPane(error);

            }
            return true;
        }
        if (srcMNode.isLeaf() && destMNode.isLeaf()) {

            QName anyType = BuiltInXSDTypes.ANY_TYPE;

            QName srcType = srcMNode.getXSDType();
            QName destType = destMNode.getXSDType();

            //as long as either of them are anytypes the mapping is valid.
            if (areEqual(srcType, anyType) || areEqual(destType, anyType)) {
                return true;
            }
            if (areEqual(destType, BuiltInXSDTypes.STRING_TYPE)
                || areEqual(destType, BuiltInXSDTypes.BOOLEAN_TYPE)) {
                return true;
            }
            if (!areEqual(srcType, destType)) {
                String error = NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                                                   "MAPPING_INCOMPATIBLE_LEAF_TYPES");  // NOI18N
                LOGGER.severe(error);
                /*
                  JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), error,
                  "Error", JOptionPane.WARNING_MESSAGE);
                */
                MapperUtil.displayWarningPane(error);
            }
            return true;
        }
        return true;
    }

    

    private boolean areCompatibleNonLeafNodes(IMapperTreeNode srcMNode, QName srcDataType,
                                              IMapperTreeNode destMNode, QName destDataType) {

        if (srcDataType == null || destDataType == null
            || !areEqual(srcDataType, destDataType)) {
            return false;
        }
        VariableDeclaration srcContainer = getContainerForNode(srcMNode);
        VariableDeclaration destContainer = getContainerForNode(destMNode);

        if (srcContainer == null || destContainer == null) {
            LOGGER.severe(NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                    "STR_VARIABLE_FOR_MAPPER_NODE_IS_NULL"));   // NOI18N
            return false;
        }
        
        WSDLReference<Message> srcWSDLMsgRef = srcContainer.getMessageType();
        QName srcMessageQName = null;
        if(srcWSDLMsgRef != null) {
            Message srcWSDLMsg = srcWSDLMsgRef.get();
            if(srcWSDLMsg != null) {
                String srcMessageName = srcWSDLMsg.getName();
                String tNamespace = srcWSDLMsg.getModel().getDefinitions().getTargetNamespace();
                
                srcMessageQName = new QName(tNamespace, srcMessageName);
            } else  {
                String srcContainerName = (srcContainer instanceof Catch)
                        ? ((Catch) srcContainer).getFaultVariable()
                        : ((Variable) srcContainer).getName();
               LOGGER.severe(NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                       "STR_CANNOT_FIND_WSDL_MESSAGE_FOR_VARIABLE_X",   // NOI18N
                       srcContainerName));
                return false;
            }
            
        }
        
        

        WSDLReference destWSDLMsgRef = destContainer.getMessageType();
        QName destMessageQName = null;
        
        if(destWSDLMsgRef != null) {
           Message destWSDLMsg = (Message) destWSDLMsgRef.get();
           if(destWSDLMsg != null) {
                String srcMessageName = destWSDLMsg.getName();
                String tNamespace = destWSDLMsg.getModel().getDefinitions().getTargetNamespace();
                
                srcMessageQName = new QName(tNamespace, srcMessageName);
           } else  {
               String destContainerName = (destContainer instanceof Catch)
                       ? ((Catch) destContainer).getFaultVariable()
                       : ((Variable) destContainer).getName();
                LOGGER.severe(
                        NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                            "STR_CANNOT_FIND_WSDL_MESSAGE_FOR_VARIABLE_X",  // NOI18N 
                            destContainerName));
                return false;
            }
        }
        

        if (!areEqual(srcMessageQName, destMessageQName)) {
            return false;
        }
        
        return false;
    }

    private static boolean isEmpty(javax.xml.namespace.QName val) {
        return (null == val);
    }
    /** Test if two strings are equal.
     * @param   s1  First string.
     * @param   s2  Second string.
     * @return  <code>true</code> if strings are equal.
     */
    private static boolean areEqual(Object s1, Object s2) {

        return (s1 == null ? s2 == null : s1.equals(s2));
    }

    // will never return null.
    private VariableDeclaration getContainerForNode(IMapperTreeNode mNode) {
        TreePath tPath = mNode.getPath();
        Object[] nodes = tPath.getPath();
        for (int i = 0; i < nodes.length; i++) {
            if (nodes[i] instanceof VariableNode) {
                return ((VariableNode) nodes[i]).getVariableDeclaration();
            }
        }
        return null;
    }


    /**Assign
     * Describe <code>isOKToConnectToEnd</code> method here.
     *
     * @param pLink an <code>IMapperLink</code> value
     * @param pCurrentSelection an <code>Object</code> value
     * @return a <code>boolean</code> value
     */
    private boolean isOKToConnectToEnd(IMapperLink pLink, BpelEntity pCurrentSelection) {
        
            if (pCurrentSelection instanceof Assign) {
                IMapperNode startNode = pLink.getStartNode();
                if (startNode instanceof IFieldNode) {
                    List links = startNode.getLinks();
                    if (links.size() > 0) {
                        return false;
                    }
                    for (Iterator iter = links.iterator(); iter.hasNext();) {
                        IMapperLink link = (IMapperLink) iter.next();
                        if (link.getEndNode() == pLink.getEndNode()) {
                            return false;
                        }
                    }
                }
                List links = startNode.getLinks();
                for (Iterator iter = links.iterator(); iter.hasNext();) {
                    IMapperLink link = (IMapperLink) iter.next();
                    if (link.getEndNode() == pLink.getEndNode()) {
                        return false;
                    }
                }
                //System.out.println("START NODE IS: "+pLink.getStartNode());
                return true;
                //}
                //return false;
            }
        
        if (pLink.getEndNode() instanceof IMapperTreeNode) {
            IMapperTreeNode lEnd = (IMapperTreeNode) pLink.getEndNode();
            if (lEnd.getLinkCount() == 1) {
                //reject this
                return false;
            }
        }
        return true;
    }

    


//  please refer to the word document for the supported type conversion
    // matrix. The word document is in the team's web site.
    private boolean isConversionSupported(QName ipType, QName opType) {

        // please preserve the order, There is redundancy in the "if" statements
        // but it is easy to maintain this way.

        if (ipType.equals(opType)) {
            return true;
        }
        if (ipType.equals(BuiltInXSDTypes.STRING_TYPE)
            || opType.equals(BuiltInXSDTypes.STRING_TYPE)) {
            return true;
        }
        if (!ipType.equals(BuiltInXSDTypes.BOOLEAN_TYPE)
            && opType.equals(BuiltInXSDTypes.BOOLEAN_TYPE)) {
            return true;
        }
        // this 'if' is redundant.
        if ((ipType.equals(BuiltInXSDTypes.DURATION_TYPE)
             || ipType.equals(BuiltInXSDTypes.TIME_TYPE)
             || ipType.equals(BuiltInXSDTypes.YEAR_TYPE)
             || ipType.equals(BuiltInXSDTypes.DAY_TYPE)
             || ipType.equals(BuiltInXSDTypes.MONTH_TYPE)
             || ipType.equals(BuiltInXSDTypes.ANYURI_TYPE)
             || ipType.equals(BuiltInXSDTypes.QNAME_TYPE)
             || ipType.equals(BuiltInXSDTypes.NOTATION_TYPE))
            && ipType.equals(opType)) {

            return true;
        }

        if ((ipType.equals(BuiltInXSDTypes.FLOAT_TYPE)
             || ipType.equals(BuiltInXSDTypes.DECIMAL_TYPE)
             || ipType.equals(BuiltInXSDTypes.DOUBLE_TYPE)
             || ipType.equals(BuiltInXSDTypes.LONG_TYPE)
             || ipType.equals(BuiltInXSDTypes.INT_TYPE)
             || ipType.equals(BuiltInXSDTypes.SHORT_TYPE)
             || ipType.equals(BuiltInXSDTypes.BYTE_TYPE))

            && (opType.equals(BuiltInXSDTypes.FLOAT_TYPE)
                || opType.equals(BuiltInXSDTypes.DECIMAL_TYPE)
                || opType.equals(BuiltInXSDTypes.DOUBLE_TYPE)
                || opType.equals(BuiltInXSDTypes.LONG_TYPE)
                || opType.equals(BuiltInXSDTypes.INT_TYPE)
                || opType.equals(BuiltInXSDTypes.SHORT_TYPE)
                || opType.equals(BuiltInXSDTypes.BYTE_TYPE))) {

            return true;
        }
        if (ipType.equals(BuiltInXSDTypes.DURATION_TYPE)
            && opType.equals(BuiltInXSDTypes.DURATION_TYPE)) {

            return true;
        }
        if (ipType.equals(BuiltInXSDTypes.DATE_TIME_TYPE)
            && (opType.equals(BuiltInXSDTypes.TIME_TYPE)
                || opType.equals(BuiltInXSDTypes.DATE_TYPE)
                || opType.equals(BuiltInXSDTypes.YEAR_MONTH_TYPE)
                || opType.equals(BuiltInXSDTypes.YEAR_TYPE)
                || opType.equals(BuiltInXSDTypes.MONTH_DAY_TYPE)
                || opType.equals(BuiltInXSDTypes.DAY_TYPE)
                || opType.equals(BuiltInXSDTypes.MONTH_TYPE))) {

            return true;
        }
        if (ipType.equals(BuiltInXSDTypes.DATE_TYPE)
            && (opType.equals(BuiltInXSDTypes.YEAR_MONTH_TYPE)
                || opType.equals(BuiltInXSDTypes.YEAR_TYPE)
                || opType.equals(BuiltInXSDTypes.MONTH_DAY_TYPE)
                || opType.equals(BuiltInXSDTypes.DAY_TYPE)
                || opType.equals(BuiltInXSDTypes.MONTH_TYPE))) {

            return true;
        }
        if (ipType.equals(BuiltInXSDTypes.YEAR_MONTH_TYPE)
            && (opType.equals(BuiltInXSDTypes.YEAR_TYPE)
                || opType.equals(BuiltInXSDTypes.MONTH_TYPE))) {

            return true;
        }
        if (ipType.equals(BuiltInXSDTypes.MONTH_DAY_TYPE)
            && (opType.equals(BuiltInXSDTypes.DAY_TYPE)
                || opType.equals(BuiltInXSDTypes.MONTH_TYPE))) {

            return true;
        }
        if (ipType.equals(BuiltInXSDTypes.HEX_BINARY_TYPE)
            && opType.equals(BuiltInXSDTypes.BASE64_BINARY_TYPE)) {

            return true;
        }
        if (ipType.equals(BuiltInXSDTypes.BASE64_BINARY_TYPE)
            && opType.equals(BuiltInXSDTypes.HEX_BINARY_TYPE)) {

            return true;
        }

        return false;
    }

    /**
     * This method will work on the assumption that each field node can entertain only one output.
     * @param pivotNode the pivot
     * @param pList the list to fill
     */
    public static void getForwardGroupNodeList(IMapperNode pivotNode,
                                               List pList) {
        if (pList == null) {
            LOGGER.finer(NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                    "STR_INPUT_LIST_CANNOT_BE_NULL"));  // NOI18N
            throw new IllegalArgumentException(
                    NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                        "STR_INPUT_LIST_CANNOT_BE_NULL"));  // NOI18N
        }
        if (pivotNode == null) {
            //this may be a valid case, so don't throw an exception as it
            // will spoil the symmetry of the API for the client.
            LOGGER.finer(NbBundle.getMessage(DefaultMapperRuleDelegate.class,
                    "STR_INPUT_NODE_NULL_BAILING_OUT"));    // NOI18N
            return;
        }
        List list = pivotNode.getNextNodes();
        if (pivotNode instanceof IFieldNode) {
            list = pivotNode.getGroupNode().getNextNodes();
        }
        for (Iterator iter = list.iterator(); iter.hasNext();) {
            IMapperNode lNextNode = (IMapperNode) iter.next();
            if (lNextNode instanceof IFieldNode) {
                Object groupNode = lNextNode.getGroupNode();
                if (!pList.contains(groupNode)) {
                    pList.add(groupNode);
                }
            }
            getForwardGroupNodeList(lNextNode, pList);
        }
    }
    }
