/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.bpel.core.validation;


import java.util.ArrayList;
import java.util.List;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.spi.Validator.ResultItem;

/**
 *
 * @author Praveen Savur
 * @author changed by ads
 */
public final class ValidationUtil {
    
    private ValidationUtil() {
    }
    
    /**
     *  Return ResultItems which apply to Bpel Model elements.
     *  ie., in the returned list, all components will be of type BpelEntity.
     */
    public static List<ResultItem> filterBpelResultItems( 
            List<ResultItem> validationResults) 
    {
        List<ResultItem> bpelResultItems = new ArrayList<ResultItem>();
        
        // Go through all result items.
        for(ResultItem resultItem: validationResults) {
            // For each result item go through all components for
            // which it applies.
            Component component = resultItem.getComponents();
            // Only gather bpel components.
            if(component instanceof BpelEntity) {
                ResultItem bpelResultItem = 
                    new ResultItem(resultItem.getValidator(),
                        resultItem.getType(), component, 
                        resultItem.getDescription());
                bpelResultItems.add(bpelResultItem);
            }
        }
        return bpelResultItems;
    }
    
    /**
     * Compares two ResultItems
     * @param item1 1st ResultItem to compare
     * @param item2 2nd ResultItem to compare
     * @returns TRUE when item1 and item2 are equal
     **/
    public static boolean equals(ResultItem item1, ResultItem item2){
        if (item1 == item2){
            return true;
        }
        if(!item1.getDescription().equals(item2.getDescription())) {
            return false;
        }
        
        if(!item1.getType().equals(item2.getType())) {
            return false;
        }
        
        Component components1 = item1.getComponents();
        Component components2 = item2.getComponents();
        
        if(components1 != components2) {
            return false;
        }
        return true;
    }
    
    /**
     * Get newly added ResultItems.
     * @param oldList Old Validation results.
     * @param newList New Validation Results.
     * @return List of ResultItems added in newList.
     */
    public static List<ResultItem> getAddedResultItems(List<ResultItem> oldList, 
            List<ResultItem> newList) 
    {
        List<ResultItem> addedResultItems = new ArrayList<ResultItem>();
        
        if(oldList == null)
            return newList;
        
        if(newList == null) // No items could have been added.
            return addedResultItems;
        
        for(ResultItem item: newList) {
            if(!contains(oldList, item)) {
                addedResultItems.add(item);
            }
        }
        return addedResultItems;
    }
    
    
    /**
     * Get removed resultItems
     * @param oldList Old Validation results.
     * @param newList New Validation Results.
     * @return List of ResultItems removed in newList.
     */
    public static List<ResultItem> getRemovedResultItems(List<ResultItem> oldList,
            List<ResultItem> newList) 
    {
        List<ResultItem> removedResultItems = new ArrayList<ResultItem>();
        
        if(newList == null) {
            return oldList;
        }
        if(oldList == null) {  // No items could have been removed.
            return removedResultItems;
        }
        
        for(ResultItem item: oldList) {
            if(!contains(newList, item)) {
                removedResultItems.add(item);
            }
        }
        return removedResultItems;
    }
    
    
    /**
     *  Return true if the list contains resultItem.
     */
    private static boolean contains(List<ResultItem> list, ResultItem resultItem) {
        assert list!=null;
        for (ResultItem item: list) {
            if (equals(item, resultItem)){
                return true;
            }
        }
        return false;
    }
    
    
    /**
     *  Returns results from slow/complete BPEL validators such as BPEL schema validator.
     */
    public static boolean isSlowValidationResult(ResultItem item){
        if (item.getValidator() != null) {
          return item.getValidator().getName().endsWith("BPELSchemaValidator");
        }
        else {
          return false;
        }
    }
    
    public static List<ResultItem> filterSlowValidatorResultItems(
            List<ResultItem> validationResults) 
    {
        List<ResultItem> slowValidatorResults = new ArrayList<ResultItem>();
        
        // Only get result from BPEL schema validator. more slow validators
        // can be added as necessary.
        for(ResultItem resultItem: validationResults) {
            // TODO: use constant.
            if(isSlowValidationResult(resultItem)) {
                slowValidatorResults.add(resultItem);
            }
        }
        return slowValidatorResults;
    }
    
}
