/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.validation.xpath;

import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.VariableDeclarationScope;
import org.netbeans.modules.bpel.model.spi.FindHelper;
import org.netbeans.modules.bpel.model.validation.ValidationVisitor;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xpath.visitor.AbstractXPathVisitor;
import org.openide.util.Lookup;

/**
 * This is an auxiliary class which hold all context objects are required to 
 * validate a BPEL XPath expression. The primary usage target is property alias 
 * objects and theirs query subelement.
 * 
 * @author nk160297
 */
public class PathValidationContext extends AbstractXPathVisitor {
    private Validator myValidator;
    private ValidationVisitor myVVisitor;
    private BpelEntity myBpelContextActivity;
    private ContentElement myXpathContentElement;
    
    private transient SchemaModel contextModel;
    private transient SchemaComponent contextComponent;
    
    private LinkedList<VariableDeclarationScope> myVarDeclScopeList;
    
    public PathValidationContext(Validator validator, ValidationVisitor vVisitor, 
            BpelEntity activity, ContentElement contentElement) {
        myValidator = validator;
        myVVisitor = vVisitor;
        myBpelContextActivity = activity;
        myXpathContentElement = contentElement;
    }
    
    public PathValidationContext clone() {
        PathValidationContext newContext = new PathValidationContext(
                myValidator, myVVisitor, 
                myBpelContextActivity, myXpathContentElement);
        newContext.setSchemaContextModel(contextModel);
        newContext.setSchemaContextComponent(contextComponent);
        newContext.myVarDeclScopeList = myVarDeclScopeList;
        return newContext;
    }
    
    /**
     * Returns the BPEL Activity to which the validation is applied.
     */
    public BpelEntity getBpelContextActivity() {
        return myBpelContextActivity;
    }
    
    /**
     * Returns the immediate owner of the validated XPath expression.
     */
    public ContentElement getXPathContentElement() {
        return myXpathContentElement;
    }
    
    /**
     * Context is a Schema component which represents current context for 
     * the XPath expression. 
     * <p>
     * In case of relative location paths, it references to a parent component, 
     * which should be considered as a parent for the first location step element.
     * <p>
     * In case of absolute location paths, it references to a global component, 
     * which corresponds to the root location step. 
     */ 
    public void setSchemaContextComponent(SchemaComponent context) {
        contextComponent = context;
    }
    
    public SchemaComponent getSchemaContextComponent() {
        return contextComponent;
    }
    
    /**
     * Context model specifies the root schema model. 
     * It is intended to be used to check absolute location paths.
     */ 
    public void setSchemaContextModel(SchemaModel context) {
        contextModel = context;
    }
    
    public SchemaModel getSchemaContextModel() {
        return contextModel;
    }
    
    public Validator getValidator() {
        return myValidator;
    }

    public ValidationVisitor getVVisitor() {
        return myVVisitor;
    }

    public synchronized LinkedList<VariableDeclarationScope> getVarDeclScopeList() {
        if (myVarDeclScopeList == null) {
            buildVarDeclScopes();
        }
        return myVarDeclScopeList;
    }
    
    /**
     * There is an order contract.
     * The list has the most nested scope at the beginning!
     */
    private void buildVarDeclScopes() {
        myVarDeclScopeList = new LinkedList<VariableDeclarationScope>();
        FindHelper helper =
                (FindHelper)Lookup.getDefault().lookup(FindHelper.class);
        BpelEntity contextActivity = getBpelContextActivity();
        Iterator<VariableDeclarationScope> itr = 
                helper.varaibleDeclarationScopes(contextActivity);
        while (itr.hasNext()) {
            VariableDeclarationScope vdScope = itr.next();
            // Put new element to the bottom of list to provide the order contract.
            myVarDeclScopeList.add(vdScope);
        }
        //
        if (contextActivity instanceof Process && myVarDeclScopeList.isEmpty()) {
            myVarDeclScopeList.add((Process)contextActivity);
        }
    }
}
