/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.validation.xpath;

import org.netbeans.modules.xml.schema.model.All;
import org.netbeans.modules.xml.schema.model.AttributeGroupReference;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.ComplexContent;
import org.netbeans.modules.xml.schema.model.ComplexContentRestriction;
import org.netbeans.modules.xml.schema.model.ComplexExtension;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.GroupReference;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalComplexType;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.Redefine;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SimpleContent;
import org.netbeans.modules.xml.schema.model.SimpleExtension;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.schema.model.Union;
import org.netbeans.modules.xml.schema.model.visitor.DefaultSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * This schema visitor is inteneded to look for a child element or attribute 
 * It looks only children at the next lavel. 
 * The method visitChildren() has to be used. 
 * The name and namespace of the sought children is specified in the constructor.
 * 
 * The special case is looking for a global element or attribute. 
 * In this case the parent schema component is the Schema object. 
 * 
 * @author nk160297
 */
public class FindChildSchemaVisitor extends DefaultSchemaVisitor {
    
    private String mySoughtName;
    private String mySoughtNamespace;
    private boolean isAttribute; // hints that the sought object is an attribute
    
    private SchemaComponent myFound = null;
    
    public FindChildSchemaVisitor(
            String soughtName, String soughtNamespace, boolean isAttribute) {
//out("");
//out("");
//out("");
//out("");
//out("INIT");
//out("INIT.look name: " + soughtName);
//out("INIT.    where: " + soughtNamespace);
//out("  is attr: " + isAttribute);
        mySoughtName = soughtName;
        mySoughtNamespace = soughtNamespace;
        this.isAttribute = isAttribute;
    }
    
    public boolean isChildFound() {
        return myFound != null;
    }
    
    public SchemaComponent getFound() {
        return myFound;
    }
    
    /**
     * Looks for nested element or attribute. 
     * The name and namespace of the required subcomponent is specified in the constructor.
     * The result can be found with the help of the getFound() method.
     */ 
    public void lookForSubcomponent(SchemaComponent sc) {
//out("");
//out("LOOK IN: " + getName(sc) + " " + sc);
        if (sc instanceof Element && sc instanceof TypeContainer) {
            //
            NamedComponentReference<? extends GlobalType> typeRef =
                    ((TypeContainer)sc).getType();
            if (typeRef != null) {
                GlobalType globalType = typeRef.get();

                if (globalType != null) {
                    globalType.accept(this);
                }
            }
            if ( !isChildFound()) {
                LocalType localType = ((TypeContainer)sc).getInlineType();
                if (localType != null) {
                    localType.accept(this);
                }
            }
        } 
        // vlv # 105159
        else if (sc instanceof Element && sc instanceof ElementReference && sc instanceof DocumentComponent) {
          DocumentComponent document = (DocumentComponent) sc;
          String typeName = document.getPeer().getAttribute("type");

          if (typeName == null || typeName.equals("")) {
            NodeList list = document.getPeer().getElementsByTagName("xs:extension");

            for (int i=0; i < list.getLength(); i++) {
              Node node = list.item(i);

              if ( !(node instanceof org.w3c.dom.Element)) {
                continue;
              }
              org.w3c.dom.Element element = (org.w3c.dom.Element) node;
              findInType(element.getAttribute("base"), sc);

              if (isChildFound()) {
                break;
              } 
            }
          }
          else {
            findInType(typeName, sc);
          }
        } 
        else if (sc instanceof ComplexType) {
            visitChildren(sc);
        } else if (sc instanceof Schema) {
            visitChildren(sc);
        }
    }

    private void findInType(final String typeName, SchemaComponent sc) {
      if (typeName == null || typeName.equals("")) {
        return;
      }
      SchemaModel model = sc.getModel();
      Schema schema = model.getSchema();
      myGlobalComplexType = null;

      schema.accept(new DeepSchemaVisitor() {
        @Override
        public void visit(GlobalComplexType type) {
          if (typeName.equals(type.getName())) {
//out("!!!!!!! === FOUND GLOBAL Complex TYPE ==== : " + type.getName());
            myGlobalComplexType = type;
          }
        }
      });

      if (myGlobalComplexType != null) {
        myGlobalComplexType.accept(this);
      }
    }

    private GlobalComplexType myGlobalComplexType;

    private String getName(SchemaComponent component) {
      if (component instanceof Named) {
        return ((Named) component).getName();
      }
      return "";
    }

    // ----------------------------------------------
    
    public void visit(LocalAttribute la) {
//out("");
//out("visit.1");
        if (isAttribute) {
            checkComponent(la);
        }
    }
    
    public void visit(GlobalAttribute ga) {
//out("");
//out("visit.2");
        if (isAttribute) {
            checkComponent(ga);
        }
    }
    
    public void visit(LocalElement le) {
//out("");
//out("visit.LocalElement: " + ((Named) le).getName());
        if ( !isAttribute) {
            checkComponent(le);
        }
    }
    
    public void visit(GlobalElement ge) {
//out("");
//out("visit.4");
        if (!isAttribute) {
            checkComponent(ge);
        }
    }
    
    // --------------- References ------------------
    
    public void visit(ElementReference er) {
//out("");
//out("visit.ElementReference: " + ((Named) er).getName());
        // vlv # 105159
        if ( !isAttribute) {
            checkComponent(er);
        }
        if (isChildFound()) {
            return;
        }
        NamedComponentReference<GlobalElement> geRef = er.getRef();

        if (geRef != null) {
            GlobalElement ge = geRef.get();

            if (ge != null) {
                visit(ge);
            }
        }
    }
    
    public void visit(AttributeReference ar) {
//out("");
//out("visit.6");
        NamedComponentReference<GlobalAttribute> gaRef = ar.getRef();

        if (gaRef != null) {
            GlobalAttribute ga = gaRef.get();
            if (ga != null) {
                visit(ga);
            }
        }
    }
    
    public void visit(AttributeGroupReference agr) {
//out("");
//out("visit.7");
        NamedComponentReference<GlobalAttributeGroup> gagRef = agr.getGroup();

        if (gagRef != null) {
            GlobalAttributeGroup gag = gagRef.get();
            if (gag != null) {
                visit(gag);
            }
        }
    }
    
    public void visit(GroupReference gr) {
//out("");
//out("visit.8");
        NamedComponentReference<GlobalGroup> ggRef = gr.getRef();

        if (ggRef != null) {
            GlobalGroup gg = ggRef.get();
            if (gg != null) {
                visit(gg);
            }
        }
    }
    
    // --------------- Visit containers -------------
    
    public void visit(Schema s) {
//out("");
//out("visit.9");
        visitChildren(s);
    }
    
    public void visit(All a) {
//out("");
//out("visit.10");
        visitChildren(a);
    }
    
    public void visit(GlobalAttributeGroup gag) {
//out("");
//out("visit.11");
        visitChildren(gag);
    }
    
    public void visit(Choice c) {
//out("");
//out("visit.12");
        visitChildren(c);
    }
    
    public void visit(SimpleContent sc) {
//out("");
//out("visit.13");
        visitChildren(sc);
    }
    
    public void visit(ComplexContent cc) {
//out("");
//out("visit.14");
        visitChildren(cc);
    }
    
    public void visit(SimpleExtension se) {
//out("");
//out("visit.15");
        NamedComponentReference<GlobalType> gtRef = se.getBase();
        if (gtRef != null) {
            GlobalType gt = gtRef.get();
            if (gt != null) {
                visitChildren(gt);
            }
        }
        //
        visitChildren(se);
    }
    
    public void visit(ComplexExtension ce) {
//out("");
//out("visit.16");
        NamedComponentReference<GlobalType> gtRef = ce.getBase();
        if (gtRef != null) {
            GlobalType gt = gtRef.get();
            if (gt != null) {
                visitChildren(gt);
            }
        }
        //
        visitChildren(ce);
    }
    
    public void visit(GlobalComplexType gct) {
//out("");
//out("visit.GlobalComplexType: " + ((Named) gct).getName());
        visitChildren(gct);
    }
    
    public void visit(LocalComplexType lct) {
//out("");
//out("visit.18");
        visitChildren(lct);
    }
    
    public void visit(GlobalGroup gg) {
//out("");
//out("visit.19");
        visitChildren(gg);
    }
    
    public void visit(Redefine r) {
//out("");
//out("visit.20");
        visitChildren(r);
    }
    
    public void visit(ComplexContentRestriction ccr) {
//out("");
//out("visit.21");
        visitChildren(ccr);
    }
    
    public void visit(Sequence s) {
//out("");
//out("visit.Sequence");
        visitChildren(s);
    }
    
    public void visit(Union u) {
//out("");
//out("visit.23");
        visitChildren(u);
    }
    
    // ----------------------------------------------
    
    private void visitChildren(SchemaComponent sc) {
        if (isChildFound()) {
            return;
        }
//out("");
//out("SEE children for: " + sc);
        //
        for (SchemaComponent child: sc.getChildren()) {
//out("  child: " + child);
            child.accept(this);
            //
            if (isChildFound()) {
                return;
            }
        }
    }
    
    private void checkComponent(SchemaComponent sc) {
//out("  checkComponent:");
        if (sc instanceof Named) {
            String namespace = sc.getModel().getEffectiveNamespace(sc);
            String name = ((Named)sc).getName();
//out("       ns: " + namspace);
//out("    my.ns: " + mySoughtNamespace);
//out("     name: " + name);
//out("  my.name: " + mySoughtName);
            if (mySoughtName.equals(name)) {
                //
                // Compare namespace as well if it is specified
                if (mySoughtNamespace != null) {
                    if (mySoughtNamespace.equals(namespace)) {
                        myFound = sc;
                    }
                } else {
                    myFound = sc;
                }
            } 
        }
    }

    private void out(Object object) {
      if ("Hotel".equals(mySoughtName)) {
//System.out.println(object);
      }
    }
}
