/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.api;

import org.netbeans.modules.bpel.model.api.support.TBoolean;

/**
 * <p>
 * Java class for tAssign complex type.
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 *
 * <pre>
 *   &lt;complexType name=&quot;tAssign&quot;&gt;
 *     &lt;complexContent&gt;
 *       &lt;extension base=&quot;{http://docs.oasis-open.org/wsbpel/2.0/process/executable}tActivity&quot;&gt;
 *         &lt;sequence&gt;
 *           &lt;choice maxOccurs=&quot;unbounded&quot;&gt;
 *             &lt;element ref=&quot;{http://docs.oasis-open.org/wsbpel/2.0/process/executable}copy&quot;/&gt;
 *             &lt;element ref=&quot;{http://docs.oasis-open.org/wsbpel/2.0/process/executable}extensibleAssign&quot;/&gt;
 *           &lt;/choice&gt;
 *         &lt;/sequence&gt;
 *         &lt;attribute name=&quot;validate&quot; type=&quot;{http://docs.oasis-open.org/wsbpel/2.0/process/executable}tBoolean&quot; default=&quot;no&quot; /&gt;
 *       &lt;/extension&gt;
 *     &lt;/complexContent&gt;
 *   &lt;/complexType&gt;
 * </pre>
 * 
 * @author ads
 */
public interface Assign extends Activity, BpelContainer {

    /**
     * "validate" attribute name.
     */
    String VALIDATE = "validate"; // NOI18N

    /**
     * @return list of children entities in this assign.
     */
    AssignChild[] getAssignChildren();

    /**
     * @param i
     *            position in array.
     * @return <code>i</code>th child element.
     */
    AssignChild getAssignChild( int i );

    /**
     * Removes <code>i</code>th child element.
     * 
     * @param i
     *            position in array.
     */
    void removeAssignChild( int i );

    /**
     * Set <code>child</code> to the <code>i</code>th position.
     * 
     * @param child
     *            object for set.
     * @param i
     *            position for set.
     */
    void setAssignChild( AssignChild child, int i );

    /**
     * Add <code>child</code> to the end of copies list.
     * 
     * @param child
     *            object for add.
     */
    void addAssignChild( AssignChild child );

    /**
     * Insert <code>copy</code> to the <code>i</code>th position.
     * 
     * @param child
     *            object for insert.
     * @param i
     *            position for insert.
     */
    void insertAssignChild( AssignChild child, int i );

    /**
     * Set new list of children.
     * 
     * @param children
     *            array for set.
     */
    void setAssignChildren( AssignChild[] children );

    /**
     * @return size of copies elements.
     */
    int sizeOfAssignChildren();

    /**
     * Getter for "validate" attribute.
     * 
     * @return "validate" attribute value.
     */
    TBoolean getValidate();

    /**
     * Setter for "validate" attribute.
     * 
     * @param value
     *            New attribute value.
     */
    void setValidate( TBoolean value );

    /**
     * Removes "validate" attribute.
     */
    void removeValidate();

}
