/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.editor.hints.ui;

import java.awt.Component;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.hints.HintsControllerImpl;
import org.netbeans.modules.editor.hints.HintsControllerImpl;
import org.netbeans.modules.editor.hints.options.SeverityComboRenderer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.ErrorManager;
import org.openide.awt.HtmlRenderer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup.Result;
import org.openide.util.Lookup.Template;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * Top component which displays something.
 */
final class ProblemTopComponent extends TopComponent {
    
    private static Object PTC_TAG = new Object();
    
    private static ProblemTopComponent instance;
    /** path to the icon used by the component and its open action */
//    static final String ICON_PATH = "SET/PATH/TO/ICON/HERE";
    
    private static final String PREFERRED_ID = "ProblemTopComponent";
    
    private ProblemTableModel model;
    
    private ProblemTopComponent() {
        super(Lookups.singleton(PTC_TAG));
        initComponents();
        setName(NbBundle.getMessage(ProblemTopComponent.class, "CTL_ProblemTopComponent"));
        setToolTipText(NbBundle.getMessage(ProblemTopComponent.class, "HINT_ProblemTopComponent"));
        
        jTable1.setDefaultRenderer(Integer.class, new SeverityComboRenderer());
        jTable1.setDefaultRenderer(ErrorDescription.class, new PositionCellRenderer());
        
        jTable1.setModel(model = new ProblemTableModel());
        
//        jTable1.a
//        setIcon(Utilities.loadImage(ICON_PATH, true));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTable1);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 276, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables
    
    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link findInstance}.
     */
    public static synchronized ProblemTopComponent getDefault() {
        if (instance == null) {
            instance = new ProblemTopComponent();
        }
        return instance;
    }
    
    /**
     * Obtain the ProblemTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized ProblemTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(ErrorManager.WARNING,
                    "Cannot find MyWindow component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof ProblemTopComponent) {
            return (ProblemTopComponent)win;
        }
        ErrorManager.getDefault().log(ErrorManager.WARNING,
                "There seem to be multiple components with the '" + PREFERRED_ID +
                "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }
    
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }
    
    public void componentOpened() {
        resultDO = Utilities.actionsGlobalContext().lookupResult(DataObject.class);
        resultTag = Utilities.actionsGlobalContext().lookup(new Template<Object>(null, null, PTC_TAG));
        resultProject = Utilities.actionsGlobalContext().lookupResult(Project.class);
        listener = new ProjectListener();
        resultDO.addLookupListener(listener);
        resultTag.addLookupListener(listener);
        HintsControllerImpl.addChangeListener(changeListener = new ChangeListenerImpl());
        listener.resultChanged(null);
        // TODO add custom code on component opening
    }
    
    public void componentClosed() {
        HintsControllerImpl.removeChangeListener(changeListener);
        changeListener = null;
        resultDO.removeLookupListener(listener);
        resultTag.removeLookupListener(listener);
        resultProject.removeLookupListener(listener);
        listener = null;
        resultDO = null;
        resultTag = null;
        resultProject = null;
        // TODO add custom code on component closing
    }
    
    /** replaces this in object stream */
    public Object writeReplace() {
        return new ResolvableHelper();
    }
    
    protected String preferredID() {
        return PREFERRED_ID;
    }
    
    final static class ResolvableHelper implements Serializable {
        private static final long serialVersionUID = 1L;
        public Object readResolve() {
            return ProblemTopComponent.getDefault();
        }
    }
    
    private Result<DataObject> resultDO = null;
    private Result resultTag = null;
    private Result<Project> resultProject = null;
    private ProjectListener listener = null;
    private Set<Project> activeProjects = null;
    private ChangeListenerImpl changeListener = null;
    
    private synchronized void updateErrors() {
        if (activeProjects == null)
            return;
        
        List<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        
        for (FileObject f : HintsControllerImpl.coveredFiles()) {
            if (activeProjects.contains(FileOwnerQuery.getOwner(f))) {
                errors.addAll(HintsControllerImpl.getErrors(f));
            }
        }
        
        model.errors = errors;
        model.fireTableDataChanged();
    }
    
    private synchronized void setActiveProjects(Set<Project> activeProjects) {
        this.activeProjects = activeProjects;
        updateErrors();
    }
    
    private class ProjectListener implements LookupListener {
        
        public void resultChanged(LookupEvent evt) {
            assert resultDO != null && resultTag != null && resultProject != null;
            
            if (!resultTag.allInstances().isEmpty())
                return ;
            
            Set<Project> projects = new HashSet<Project>();
            
            for (DataObject file : resultDO.allInstances()) {
                projects.add(FileOwnerQuery.getOwner(file.getPrimaryFile()));
            }
            
            projects.addAll(resultProject.allInstances());
            
            setActiveProjects(projects);
        }
        
    }
    
    private class ChangeListenerImpl implements ChangeListener {
        
        public void stateChanged(javax.swing.event.ChangeEvent evt) {
            updateErrors();
        }
    
    }
    
    private static class ProblemTableModel extends AbstractTableModel {
        
        private List<ErrorDescription> errors = Collections.<ErrorDescription>emptyList();
        
        public int getRowCount() {
            return errors.size();
        }
        
        public int getColumnCount() {
            //description
            //severity
            //kind?
            //position
            return 3;
        }
        
        public @Override String getColumnName(int column) {
            switch (column) {
                case 0:
                    return "Description";
                case 1:
                    return "Severity";
                case 2:
                    return "Position";
            }
            
            throw new IllegalArgumentException("Invalid column: " + column); // NOI18N
        }
        
        public @Override Class<?> getColumnClass(int column) {
            switch (column) {
                case 0:
                    return String.class;
                case 1:
                    return Integer.class;
                case 2:
                    return ErrorDescription.class;
            }
            
            throw new IllegalArgumentException("Invalid column: " + column); // NOI18N
        }
        
        public Object getValueAt(int row, int column) {
            if (row >= errors.size())
                throw new IllegalArgumentException("Invalid row: " + row + ", max=" + errors.size());
            
            ErrorDescription desc = errors.get(row);
            
            assert desc != null;
            
            switch (column) {
                case 0:
                    return desc.getDescription();
                case 1:
                    return desc.getSeverity();
                case 2:
                    return desc;
            }
            
            throw new IllegalArgumentException("Invalid column: " + column); // NOI18N
        }
        
    }
    
    private static final class PositionCellRenderer implements TableCellRenderer {
        private TableCellRenderer delegateTo;
        
        public PositionCellRenderer() {
            delegateTo = HtmlRenderer.createRenderer();
        }
        
        public Component getTableCellRendererComponent(JTable table,
                Object value,
                boolean isSelected,
                boolean hasFocus,
                int row,
                int column) {
            ErrorDescription desc = (ErrorDescription) value;
            
            try {
                String position = desc.getFile().getNameExt() + ":" + desc.getRange().getBegin().getLine();
                
                return delegateTo.getTableCellRendererComponent(table, position, isSelected, hasFocus, row, column);
            } catch (IOException e) {
                return delegateTo.getTableCellRendererComponent(table, e.getLocalizedMessage(), isSelected, hasFocus, row, column);
            }
        }
    }
    
}
