/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.modelimpl.csm.core;

import org.netbeans.modules.cnd.api.model.*;
import java.util.*;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.UsingDirectiveImpl;

/**
 * @author Dmitriy Ivanov
 */
public class Resolver2 implements Resolver {

    private ProjectBase project;
    private CsmFile file;
    private int offset;

    private CsmDeclaration[] path;
    private int pathIndex = 0;
    private List fileDeclarations = null;

    

    public Resolver2(CsmFile file, int offset, Resolver parent) {
        this.file = file;
        this.offset = offset;
        this.project = (ProjectBase) file.getProject();
    }
    
    public Resolver2(CsmOffsetable context, Resolver parent) {
        this.file = context.getContainingFile();
        this.offset = context.getStartOffset();
        this.project = (ProjectBase) context.getContainingFile().getProject();
    }

    /**
     * Resolver class or namespace name.
     * Why class or namespace? Because in usage of kind org::vk::test
     * you don't know which is class and which is namespace name 
     *
     * @param nameTokens tokenized name to resolve 
     * (for example, for std::vector it is new String[] { "std", "vector" })
     *
     * @param context declaration within which the name found
     *
     * @return object of the following class:
     *  CsmClass 
     *  CsmEnum
     *  CsmNamespace
     */
    
    
     public CsmObject resolve(String qualified, int interestedKind) {
        Vector v = new Vector();
        for (StringTokenizer t = new StringTokenizer(qualified, ": \t\n\r\f", false); t.hasMoreTokens(); ) // NOI18N
            v.add(t.nextToken());
        return resolve((String[])v.toArray(new String[v.size()]), interestedKind);
    }

    static Stack calls = new Stack();
    public CsmObject resolve(String[] nameTokens, int interestedKind) {
        calls.push(this);
        CsmObject result = null;
        path = getPath(offset);
        pathIndex = 0;
        nameIndex =0;
        nameLength = nameTokens.length;
        if (nameLength == 1) {
            String name = nameTokens[0];
            if (path.length == 0)
            // 4 - in global scope
                result = findInGlobal(name);
            else
            // 5 - in namespace
            if (path[0].getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                result = findInNamespace(name);
                if (result == null)
                    result = findInGlobal(name);
            }
            else
            // 6 - in function in namespace
            // 8 - in member function
            if (path[0].getKind() == CsmDeclaration.Kind.FUNCTION || path[0].getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
                result = findInBlock(name);
///////////  for 8 only              
            if (result == null)
                result = findInClass(name);
///////////                
            if (result == null)
                result = findInNamespace(name);
            if (result == null)
                result = findInGlobal(name);
            }
            else
            // 7 - in class
            if (CsmKindUtilities.isClass(path[0])) {
                result = findInClass(name);
                if (result == null)
                    result = findInNamespace(name);
                if (result == null)
                    result = findInGlobal(name);
            }
        }
        else if (nameLength >1 ) {
            for (pathIndex = 0; pathIndex <= path.length && result == null; ) {
                CsmObject scope = nextScope();
                for (nameIndex = 0; nameIndex < nameLength && scope != null; nameIndex++) {
                    String name = nameTokens[nameIndex];
                    scope = findScope(scope, name);
                }
                result = scope;
            }
        }
        if( result == null ) {
            result = project.getDummyForUnresolved(nameTokens, file, offset);
        }
        calls.pop();
        return result;
    }
    
    private int nameIndex = 0;
    private int nameLength = 0;
    
    private CsmObject nextScope() {
        CsmObject scope = null;
        for ( ; pathIndex < path.length; pathIndex++) {
            if (path[pathIndex].getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION || CsmKindUtilities.isClass(path[pathIndex])) {
                scope = path[pathIndex];
                break;
            }
        }
        if (pathIndex++ == path.length)
            scope = file;
        return scope;
    }

    private CsmObject findScope(CsmObject parent, String name) {
        CsmObject result = null;
        if (parent != null) {
            if (parent instanceof CsmFile)
                result = findScope(getFileDeclarations(), name);
            else 
            if (parent instanceof CsmNamespaceDefinition)
                result = findScope(((CsmNamespaceDefinition)parent).getDeclarations(), name);
            else
            if (CsmKindUtilities.isClass(parent)) {
                result = findScope(((CsmClass)parent).getMembers(), name);
                if (result == null) {
                    if (parent instanceof CsmClass)
                    for (Iterator bc = ((CsmClass)parent).getBaseClasses().iterator(); bc.hasNext() && result == null; ) {
                        CsmClass clss = ((CsmInheritance)bc.next()).getCsmClass();
                        if (clss != null) {
                            result = findScope(clss, name);
                        }
                    }
                    
                }
            }                
        }
        return result;
    }
    
    private CsmObject findScope(List list, String name) {
        CsmObject result = null;
        for (Iterator i = list.iterator(); i.hasNext() && result == null; ) {
            CsmDeclaration x = (CsmDeclaration)checkDeclaration((CsmOffsetableDeclaration)i.next(), name);
            if (nameIndex == nameLength-1 || 
                    (x != null && (x instanceof CsmFile || x instanceof CsmNamespaceDefinition || CsmKindUtilities.isClass(x) || x instanceof CsmBuiltIn)))
                result = x;
        }
        return result;
    }

    private CsmObject findInGlobal(String name) {
        CsmObject result = null;
        for( Iterator iter = getFileDeclarations().iterator(); iter.hasNext() && result == null; ) {
            result = checkDeclaration((CsmOffsetableDeclaration)iter.next(), name);
        }
        return result;
    }
    
    private CsmObject findInNamespace(String name) {
        CsmObject result = null;
        if (pathIndex < path.length && path[pathIndex] instanceof CsmNamespaceDefinition) {
            CsmNamespaceDefinition ns = (CsmNamespaceDefinition)path[pathIndex];
            result = findInNamespace(ns.getNamespace(), name);
            if (result == null) {
                if (pathIndex+1 < path.length && path[pathIndex+1].getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                    pathIndex++;
                    result = findInNamespace(name);
                }
            }
        }
        return result;
    }
    
    private CsmObject findInBlock(String name) {
//TODO        
        CsmObject result = null;
        pathIndex++;
        return result;
    }
    

    private CsmObject findInClass(String name) {
        CsmObject result = null;
        if (pathIndex < path.length && path[pathIndex] instanceof CsmClass) {
            CsmClass cls = (CsmClass)path[pathIndex];
            result = findMember(cls, name);
            if (result == null) {
                for (Iterator bc = cls.getBaseClasses().iterator(); bc.hasNext() && result == null; ) {
                    CsmClass clss = ((CsmInheritance)bc.next()).getCsmClass();
                    if (clss != null) {
                        result = findMember(clss, name);
                    }
                }
            }
            if (result == null) {
                pathIndex++;
                result = findInClass(name);
            }
        }
        return result;
    }

    private CsmObject findMember(CsmClass cls, String name) {
        CsmObject result = null;
        for( Iterator iter = cls.getMembers().iterator(); iter.hasNext() && result == null; ) {
            result = checkDeclaration((CsmOffsetableDeclaration)iter.next(), name);
        }
        return result;
    }

    private CsmObject findInNamespace(CsmNamespace ns, String name) {
        CsmObject result = null;
        if (ns != null)
        for (Iterator i = ns.getDefinitions().iterator(); i.hasNext() && result == null;)
            result = findInNamespace((CsmNamespaceDefinition)i.next(), name);
        return result;
    }

    private CsmObject findInNamespace(CsmNamespaceDefinition ns, String name) {
        CsmObject result = null;
        for( Iterator iter = ns.getDeclarations().iterator(); iter.hasNext() && result == null; ) {
            result = checkDeclaration((CsmOffsetableDeclaration) iter.next(), name);
        }
        return result;
    }
    
    Object usingDir = null;
    private CsmObject checkDeclaration(CsmOffsetableDeclaration decl, String name) {
        CsmObject result = null;
        if (isBefore(decl, offset)) {
            CsmDeclaration.Kind kind = decl.getKind();
            if (kind == CsmDeclaration.Kind.USING_DIRECTIVE) {
                usingDir = ((UsingDirectiveImpl)decl).getName();
                boolean doIt = true;
                for (int c = 0; c < calls.size()-1 && doIt; c++) {
                    Resolver2 r = (Resolver2)calls.get(c);
                    doIt = !usingDir.equals(r.usingDir);
                }
                if (doIt)    
                    result = findInNamespace(((CsmUsingDirective)decl).getReferencedNamespace(), name);
                usingDir = null;
            }
            else
            if (kind == CsmDeclaration.Kind.USING_DECLARATION) {
                String uName = ((CsmUsingDeclaration)decl).getName();
                if (uName != null) {
                    String uNameLast = uName.substring(uName.lastIndexOf(':')+1);
                    if (name.equals(uNameLast)) {
    //TODO: eliminate infinite recursion                    
                        //result = resolve(uName);
                        result = ((CsmUsingDeclaration)decl).getReferencedDeclaration();
                    }
                }
            }
            else 
            if (name.equals(decl.getName())) {
                result = decl;
                if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
                    result = getNamespaceDefinition(((CsmNamespaceAlias)decl).getReferencedNamespace());
                }
                if (kind == CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION)  {
                    result = ((CsmClassForwardDeclaration)decl).getCsmClass();
                }
                if (kind == CsmDeclaration.Kind.TYPEDEF) {
                    CsmType type = ((CsmTypedef)decl).getType();
                    if (type != null)
                        result = type.getClassifier();
                }
            }
        }
        return result;
    }
    
    
    private CsmNamespaceDefinition getNamespaceDefinition(CsmNamespace ns) {
        CsmNamespaceDefinition result = null;
        if (ns != null) {
            Iterator i = ns.getDefinitions().iterator();
            if (i.hasNext())
                result = (CsmNamespaceDefinition)i.next();
        }
        return result;
    }
    
  
    private boolean isBefore(CsmOffsetableDeclaration decl, int offset) {
//TODO:        
        return decl.getStartOffset() < offset || ! file.equals(decl.getContainingFile());
    }

    private boolean locateInDeclaration(Vector v, CsmOffsetableDeclaration decl, int offset) {
        boolean found = false;
        if (contains(decl, offset)) {
            found = true;
            CsmDeclaration.Kind kind = decl.getKind();
            if (kind != CsmDeclaration.Kind.VARIABLE &&
                kind != CsmDeclaration.Kind.NAMESPACE_ALIAS &&
                kind != CsmDeclaration.Kind.USING_DIRECTIVE &&
                kind != CsmDeclaration.Kind.USING_DECLARATION &&
                kind != CsmDeclaration.Kind.TYPEDEF) {
                v.insertElementAt(decl, 0);
                if (CsmKindUtilities.isClass(decl)) {
                    found = locateInClass(v, (CsmClass) decl, offset);
                }
                else if( kind == CsmDeclaration.Kind.ENUM ) {
                    found = locateInEnum(v, (CsmEnum) decl, offset);
                }
                else if( kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION ) {
                    found = locateInNamespace(v, (CsmNamespaceDefinition) decl, offset);
                }
                else if( kind == CsmDeclaration.Kind.FUNCTION ) {
                    found = locateInFunction(v, (CsmFunction) decl, offset);
                }
                else if( kind == CsmDeclaration.Kind.FUNCTION_DEFINITION ) {
                    found = locateInFunction(v, (CsmFunctionDefinition) decl, offset);
                }
            }
        }
        return found;
    }
    
    private boolean locateInClass(Vector v, CsmClass decl, int offset) {
        boolean found = false;
        for( Iterator iter = decl.getMembers().iterator(); iter.hasNext() && !found; ) {
            found = locateInDeclaration(v, (CsmOffsetableDeclaration) iter.next(), offset);
        }
        return found;
    }
    
    private boolean locateInNamespace(Vector v, CsmNamespaceDefinition decl, int offset) {
        CsmNamespace ns = decl.getNamespace();
        boolean found = false;
        for( Iterator iter = decl.getDeclarations().iterator(); iter.hasNext() && !found; ) {
            found = locateInDeclaration(v, (CsmOffsetableDeclaration) iter.next(), offset);
        }
        if (found)
            expandPath(v, decl.getDeclarations().iterator());
        return found;
    }
    
    private boolean locateInEnum(Vector v, CsmEnum decl, int offset) {
        //TODO
        return contains(decl, offset);
    }
        
    private boolean locateInFunction(Vector v, CsmFunction decl, int offset) {
        //TODO
        boolean found = false;
        if (decl instanceof CsmFunctionDefinition) {
            found = locateInBlock(v, ((CsmFunctionDefinition)decl).getBody(), offset);
        }
        return found;
    }
    
    private boolean locateInBlock(Vector v, CsmCompoundStatement block, int offset) {
        boolean found = false;
        for( Iterator iter = block.getStatements().iterator(); iter.hasNext() && !found; ) {
            CsmStatement stmt = (CsmStatement)iter.next();
            CsmStatement.Kind kind = stmt.getKind();
            if( kind == CsmStatement.Kind.COMPOUND ) {
                found = locateInBlock(v, (CsmCompoundStatement)stmt, offset);
            }
            else if( kind == CsmStatement.Kind.DECLARATION ) {
                for( Iterator it = ((CsmDeclarationStatement) stmt).getDeclarators().iterator(); it.hasNext() && !found; ) {
                    found = locateInDeclaration(v, (CsmOffsetableDeclaration) it.next(), offset);
                }
            }
            //TODO other statements
        }
        return found;
    }
    
    private CsmDeclaration[] getPath(int offset) {
        boolean found = false;
        Vector v = new Vector();
        List/*CsmDeclaration*/ objects = getFileDeclarations();
        for( Iterator iter = objects.iterator(); iter.hasNext() && !found; ) {
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration) iter.next();
            if (contains(decl, offset)) {
                found = locateInDeclaration(v, decl, offset);
            }
        }
        if (found) {
            expandPath(v, objects.iterator());
        }
        return (CsmDeclaration[])v.toArray(new CsmDeclaration[v.size()]);
    }
    
    private void expandPath(Vector v, Iterator iter) {
        if (v.size() > 0) {
            CsmDeclaration decl = (CsmDeclaration)v.get(v.size()-1);
            String name = decl.getName();
            while(iter.hasNext()) {
                CsmOffsetableDeclaration d = (CsmOffsetableDeclaration) iter.next();
                if (decl != d && name.equals(d.getName())) {
                    v.add(d);
                }
            }
        }
    }
    
    private boolean contains(CsmOffsetable where, int offset) {
        return  where.getStartOffset() <= offset && offset <= where.getEndOffset() && where.getContainingFile()==file;
    }
    
    private List getFileDeclarations() {
        if (fileDeclarations == null) {
            fileDeclarations = new Vector();
            getFileDeclarations(new HashSet(), file);
        }
        return fileDeclarations;
    }

    private void getFileDeclarations(Set files, CsmFile file) {
        if (file != null && files.add(file)) {
            for (Iterator<CsmInclude> i = file.getIncludes().iterator(); i.hasNext(); ) {
                getFileDeclarations(files, (i.next()).getIncludeFile());
            }
            fileDeclarations.addAll(file.getDeclarations());
        }
    }

}
