/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.modelimpl.csm.core;

import org.netbeans.modules.cnd.api.model.*;
import java.util.*;

/**
 * General algorythm description.
 *
 * A. What can it be:
 *  - Class (union, struct)
 *  - Enum
 *  - Typedef
 *  - Namespace
 *
 * B. What do we take into consideration:
 *  - Namespace definitions
 *  - Declarations of
 *      - Classes (unions, structs)
 *      - Enums
 *      - Typedefs
 *      - Forward class declarations
 *  - Using directives (in a way similar to scopes)
 *  - Using directives
 *  - Namespace aliases
 *
 * C. Context - how should it be take into account
 *  - Search through ecclosing scopes 
 *    (from the enclosing scope beginning to the enclosed scope start)
 *  - Search declarations within another definition of the same namespace
 *  - Search through the declarations of the current class 
 *
 * @author Vladimir Kvasihn
 */
public class Resolver1 implements Resolver {

        
    private ProjectBase project;
    private CsmFile file;
    private int offset;

    

    public Resolver1(CsmFile file, int offset, Resolver parent) {
        this.file = file;
        this.offset = offset;
        this.project = (ProjectBase) file.getProject();
    }
    
    public Resolver1(CsmOffsetable context, Resolver parent) {
        this.file = context.getContainingFile();
        this.offset = context.getStartOffset();
        this.project = (ProjectBase) context.getContainingFile().getProject();
    }
    
    public CsmObject resolve(String qualifiedName, int interestedKind) {
        List v = new ArrayList();
        for (StringTokenizer t = new StringTokenizer(qualifiedName, ": \t\n\r\f", false); t.hasMoreTokens(); ) { // NOI18N
            v.add(t.nextToken());
        }
        return resolve((String[])v.toArray(new String[v.size()]), interestedKind);
    }


    /**
     * Implements Resolver.resolve()
     */
    public CsmObject resolve(String[] nameTokens, int interestedKind) {
        CsmObject result = null;
        
        
        if( result == null ) {
            result = project.getDummyForUnresolved(nameTokens, file, offset);
        }
        return result;
    }
    

    
}
