/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.editor.makefile;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;

/**
 *
 * @author gordonp
 */
public class MakefileFormatSupport extends ExtFormatSupport {
    
    private TokenContextPath tokenContextPath;
    
    /** Creates a new instance of MakefileFormatSupport */
    public MakefileFormatSupport(FormatWriter fw) {
        this(fw, MakefileTokenContext.contextPath);
    }
    
    public MakefileFormatSupport(FormatWriter fw, TokenContextPath tokenContextPath) {
        super(fw);
        this.tokenContextPath = tokenContextPath;
    }
    
    public FormatTokenPosition indentLine(FormatTokenPosition pos) {
        TokenItem token = pos.getToken();
        
        if (isRuleOrActionLine(token)) {
            return changeLineIndent(pos, 8);
        } else {
            return pos;
        }
    }
    
    private boolean isRuleOrActionLine(TokenItem token) {
        
        if (token == null) {    // an empty line...
            JTextComponent tc = Utilities.getFocusedComponent();
            BaseDocument doc = Utilities.getDocument(tc);
            int dot = tc.getCaret().getDot();
            try {
                int start = Utilities.getRowStart(doc, dot - 1);
                String line = doc.getText(start, dot - start);
                int colon = line.indexOf(':');
                int pound = line.indexOf('#');
                if (line.charAt(0) == '\t' ||
                        (colon > 0 && pound == -1) || (colon > 0 && colon < pound)) {
                    return true;
                }
            } catch (BadLocationException ex) {
            }
        }
        return false;
    }
    
    public TokenID getWhitespaceTokenID() {
        return MakefileTokenContext.TAB;
    }
    
    public TokenContextPath getWhitespaceTokenContextPath() {
        return tokenContextPath;
    }
}
