/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/**
 *
 * @author Radek Matous
 */
public final class LibrariesModel extends AbstractListModel implements ComboBoxModel, PropertyChangeListener {
    private Library[] cache;
    private Object selectedLibrary = null;
    
    public static JComboBox getComboBox() {
        JComboBox librariesComboBox = new JComboBox(new LibrariesModel());
        librariesComboBox.setRenderer(new LibraryRenderer());
        return librariesComboBox;
    }
    
    /** Creates a new instance of LibrariesModels */
    private LibrariesModel() {
        LibraryManager manager = LibraryManager.getDefault();
        manager.addPropertyChangeListener(WeakListeners.create(PropertyChangeListener.class, this, manager));
        Library[] libraries =  getLibraries();
        if (libraries != null && libraries.length > 0) {
            selectedLibrary =  libraries[0];
        }
        
    }
    
    public synchronized int getSize() {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        return this.cache.length;
    }
    
    public synchronized Object getElementAt(int index) {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        if (index >= 0 && index < this.cache.length) {
            return this.cache[index];
        } else {
            return null;
        }
    }
    
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        int oldSize = this.cache == null ? 0 : this.cache.length;
        this.cache = createLibraries();
        int newSize = this.cache.length;
        
        this.fireContentsChanged(this, 0, Math.min(oldSize-1,newSize-1));
        if (oldSize > newSize) {
            this.fireIntervalRemoved(this,newSize,oldSize-1);
        } else if (oldSize < newSize) {
            this.fireIntervalAdded(this,oldSize,newSize-1);
        }
    }
    
    public synchronized Library[] getLibraries() {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        return this.cache;
    }
    
    private Library[] createLibraries() {
        Library[] libs = LibraryManager.getDefault().getLibraries();
        Arrays.sort(libs, new Comparator<Library>() {
            public int compare(Library l1, Library l2) {
                return l1.getDisplayName().compareToIgnoreCase(l2.getDisplayName());
            }
        });
        return libs;
    }
        
    public void setSelectedItem(Object libarry) {
        assert libarry == null || libarry instanceof Library;
        if (selectedLibrary != libarry) {
            selectedLibrary = libarry;
            fireContentsChanged(this, -1, -1);
        }
    }
    
    public Object getSelectedItem() {
        return selectedLibrary;
    }
    
    private static final class LibraryRenderer extends JLabel implements ListCellRenderer, UIResource {
        
        private static final String LIBRARY_ICON = "org/netbeans/modules/apisupport/project/ui/resources/libraries.gif";  //NOI18N               
        private Icon cachedIcon;
        
        public LibraryRenderer () {
            setOpaque(true);
        }
        
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            // #93658: GTK needs name to render cell renderer "natively"
            setName("ComboBox.listRenderer"); // NOI18N
            
            String displayName = null;
            
            if (value instanceof Library) {
                Library lib = ((Library)value);
                displayName = lib.getDisplayName();
            }
            setText(displayName);
            setIcon(createIcon());
            
            if ( isSelected ) {
                setBackground(list.getSelectionBackground());
                setForeground(list.getSelectionForeground());             
            }
            else {
                setBackground(list.getBackground());
                setForeground(list.getForeground());
            }
            
            return this;
        }
        
        // #93658: GTK needs name to render cell renderer "natively"
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;  // NOI18N
        }
        
        private synchronized Icon createIcon () {
            if (this.cachedIcon == null) {
                Image img = Utilities.loadImage(LIBRARY_ICON);
                this.cachedIcon = new ImageIcon (img);
            }                
            return this.cachedIcon;
        }                        
    }
}
