package expectj;


import java.io.InputStream;
import java.io.OutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

import java.net.Socket;
import java.net.UnknownHostException;

/**
 * This class represents an open socket.
 *
 * @author	Greg Anderson 
 * @version 1.0
 */
public class SocketHandler extends ExpectHandler {

    // Address and port to connect to
    private String m_serverAddress = null;
    private int m_port = 0;
    
    private Socket m_socket = null;
    
    // Debugger object
    Debugger debug = new Debugger("SocketThread", true);

    /**
     * Constructor
     *
     * @param sCommand Process commmand to be executed
     * @param lDefaultTimeOut Default timeout for expect commands
     *
     */
    SocketHandler(String serverAddress, int port, long lDefaultTimeOut) 
        throws ExpectJException {
    		
    		super(lDefaultTimeOut);
    		m_serverAddress = serverAddress;
            m_port = port;
            
            try
            {
	            m_socket = new Socket(m_serverAddress, m_port);
	            
	            
	            debug.print("Opened connection: " + serverAddress);               
	
	            inStream = m_socket.getInputStream();
	            outStream = m_socket.getOutputStream();
	            errStream = null;
	            in = new BufferedReader(
	                    new InputStreamReader(inStream));
	            err = null;
	            out = new BufferedWriter(
	                    new OutputStreamWriter(outStream));
            }
            catch(UnknownHostException uhe)
            {
            	throw new ExpectJException("Unknown host exception", uhe);
            }
            catch(IOException ioe)
            {
            	throw new ExpectJException("Error in SocketThread constructor", ioe);
            }

        }





    /**
     * This method returns true if the process has already exited. 
     * This method shoud be use use to check the process status 
     * before invoking send()
     */
    public boolean isClosed() {

        //return m_socket.isClosed();
    	try {
			m_socket.close();
		} catch (IOException e) {
			return true;
		}
    	return true;
    }

    /**
     * Sockets do not have exit values...
     */
    public int getExitValue() {

        return 0;

    }

    public void interact() throws ExpectJException
    {
    	throw new ExpectJException("SocketHandler.interact unimplemented");
    }
    public void stop()
    {
    	try
    	{
    		m_socket.close();
    	}
    	catch(IOException ioe)
    	{
    		debug.print("IOException in SocketHandler.stop: " + ioe+toString()); 
    	}
    }



}
