/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Description {
    public static Description TEST_MECHANISM = new Description("Test mechanism");
    private final ArrayList<Description> fChildren = new ArrayList();
    private final String fDisplayName;

    public static Description createSuiteDescription(String name) {
        return new Description(name);
    }

    public static Description createTestDescription(Class clazz, String name) {
        return new Description(String.format("%s(%s)", name, clazz.getName()));
    }

    public static Description createSuiteDescription(Class<?> testClass) {
        return new Description(testClass.getName());
    }

    private Description(String displayName) {
        this.fDisplayName = displayName;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public void addChild(Description description) {
        this.getChildren().add(description);
    }

    public ArrayList<Description> getChildren() {
        return this.fChildren;
    }

    public boolean isSuite() {
        return !this.isTest();
    }

    public boolean isTest() {
        return this.getChildren().isEmpty();
    }

    public int testCount() {
        if (this.isTest()) {
            return 1;
        }
        int result = 0;
        for (Description child : this.getChildren()) {
            result += child.testCount();
        }
        return result;
    }

    public int hashCode() {
        return this.getDisplayName().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Description)) {
            return false;
        }
        Description d = (Description)obj;
        return this.getDisplayName().equals(d.getDisplayName()) && this.getChildren().equals(d.getChildren());
    }

    public String toString() {
        return this.getDisplayName();
    }
}

