/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.List;
import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.InnerClassesInfoVisitor;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.util.BasicListMatcher;
import proguard.util.StringMatcher;

public class AttributeUsageMarker
implements ClassFileVisitor,
MemberInfoVisitor,
AttrInfoVisitor,
InnerClassesInfoVisitor {
    private static final Object USED = new Object();
    private boolean keepAllAttributes;
    private boolean keepAllUnknownAttributes;
    private boolean keepAllKnownAttributes;
    private StringMatcher keepAttributes;
    private boolean keepInnerClassNameAttribute;
    private boolean keepEnclosingMethodAttribute;
    private boolean keepLineNumberTableAttribute;
    private boolean keepLocalVariableTableAttribute;
    private boolean keepLocalVariableTypeTableAttribute;
    private boolean keepSourceFileAttribute;
    private boolean keepSourceDirAttribute;
    private boolean keepDeprecatedAttribute;
    private boolean keepSyntheticAttribute;
    private boolean keepSignatureAttribute;
    private boolean keepRuntimeVisibleAnnotationsAttribute;
    private boolean keepRuntimeInvisibleAnnotationsAttribute;
    private boolean keepRuntimeVisibleParameterAnnotationsAttribute;
    private boolean keepRuntimeInvisibleParameterAnnotationsAttribute;
    private boolean keepAnnotationDefaultAttribute;

    public void setKeepAllAttributes() {
        this.keepAllAttributes = true;
    }

    public void setKeepAllUnknownAttributes() {
        this.keepAllUnknownAttributes = true;
    }

    public void setKeepAllKnownAttributes() {
        this.keepAllKnownAttributes = true;
    }

    public void setKeepAttributes(List list) {
        this.keepAttributes = new BasicListMatcher(list);
        this.keepInnerClassNameAttribute = this.keepAttributes.matches("InnerClasses");
        this.keepEnclosingMethodAttribute = this.keepAttributes.matches("EnclosingMethod");
        this.keepLineNumberTableAttribute = this.keepAttributes.matches("LineNumberTable");
        this.keepLocalVariableTableAttribute = this.keepAttributes.matches("LocalVariableTable");
        this.keepLocalVariableTypeTableAttribute = this.keepAttributes.matches("LocalVariableTypeTable");
        this.keepSourceFileAttribute = this.keepAttributes.matches("SourceFile");
        this.keepSourceDirAttribute = this.keepAttributes.matches("SourceDir");
        this.keepDeprecatedAttribute = this.keepAttributes.matches("Deprecated");
        this.keepSyntheticAttribute = this.keepAttributes.matches("Synthetic");
        this.keepSignatureAttribute = this.keepAttributes.matches("Signature");
        this.keepRuntimeVisibleAnnotationsAttribute = this.keepAttributes.matches("RuntimeVisibleAnnotations");
        this.keepRuntimeInvisibleAnnotationsAttribute = this.keepAttributes.matches("RuntimeInvisibleAnnotations");
        this.keepRuntimeVisibleParameterAnnotationsAttribute = this.keepAttributes.matches("RuntimeVisibleParameterAnnotations");
        this.keepRuntimeInvisibleParameterAnnotationsAttribute = this.keepAttributes.matches("RuntimeInvisibleParameterAnnotations");
        this.keepAnnotationDefaultAttribute = this.keepAttributes.matches("AnnotationDefault");
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
        programClassFile.attributesAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    private void visitMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        programMemberInfo.attributesAccept(programClassFile, this);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
        if (this.keepAllAttributes || this.keepAllUnknownAttributes || this.keepAttributes != null && this.keepAttributes.matches(unknownAttrInfo.getAttributeName(classFile))) {
            AttributeUsageMarker.markAsUsed(unknownAttrInfo);
        }
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
        AttributeUsageMarker.markAsUsed(innerClassesAttrInfo);
        if (!(this.keepAllAttributes || this.keepAllKnownAttributes || this.keepInnerClassNameAttribute)) {
            innerClassesAttrInfo.innerClassEntriesAccept(classFile, this);
        }
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepEnclosingMethodAttribute) {
            AttributeUsageMarker.markAsUsed(enclosingMethodAttrInfo);
        }
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
        AttributeUsageMarker.markAsUsed(constantValueAttrInfo);
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
        AttributeUsageMarker.markAsUsed(exceptionsAttrInfo);
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        AttributeUsageMarker.markAsUsed(codeAttrInfo);
        codeAttrInfo.attributesAccept(classFile, methodInfo, this);
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepLineNumberTableAttribute) {
            AttributeUsageMarker.markAsUsed(lineNumberTableAttrInfo);
        }
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepLocalVariableTableAttribute) {
            AttributeUsageMarker.markAsUsed(localVariableTableAttrInfo);
        }
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepLocalVariableTypeTableAttribute) {
            AttributeUsageMarker.markAsUsed(localVariableTypeTableAttrInfo);
        }
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepSourceFileAttribute) {
            AttributeUsageMarker.markAsUsed(sourceFileAttrInfo);
        }
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepSourceDirAttribute) {
            AttributeUsageMarker.markAsUsed(sourceDirAttrInfo);
        }
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepDeprecatedAttribute) {
            AttributeUsageMarker.markAsUsed(deprecatedAttrInfo);
        }
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepSyntheticAttribute) {
            AttributeUsageMarker.markAsUsed(syntheticAttrInfo);
        }
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepSignatureAttribute) {
            AttributeUsageMarker.markAsUsed(signatureAttrInfo);
        }
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepRuntimeVisibleAnnotationsAttribute) {
            AttributeUsageMarker.markAsUsed(runtimeVisibleAnnotationsAttrInfo);
        }
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepRuntimeInvisibleAnnotationsAttribute) {
            AttributeUsageMarker.markAsUsed(runtimeInvisibleAnnotationsAttrInfo);
        }
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepRuntimeVisibleParameterAnnotationsAttribute) {
            AttributeUsageMarker.markAsUsed(runtimeVisibleParameterAnnotationsAttrInfo);
        }
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepRuntimeInvisibleParameterAnnotationsAttribute) {
            AttributeUsageMarker.markAsUsed(runtimeInvisibleParameterAnnotationsAttrInfo);
        }
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        if (this.keepAllAttributes || this.keepAllKnownAttributes || this.keepAnnotationDefaultAttribute) {
            AttributeUsageMarker.markAsUsed(annotationDefaultAttrInfo);
        }
    }

    public void visitInnerClassesInfo(ClassFile classFile, InnerClassesInfo innerClassesInfo) {
        innerClassesInfo.u2innerNameIndex = 0;
    }

    private static void markAsUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(USED);
    }

    static boolean isUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == USED;
    }
}

