/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableInfoVisitor;

public class LocalVariableTableAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 2;
    public int u2localVariableTableLength;
    public LocalVariableInfo[] localVariableTable;

    protected LocalVariableTableAttrInfo() {
    }

    protected LocalVariableInfo[] getLocalVariableTable() throws Exception {
        return this.localVariableTable;
    }

    protected int getLength() {
        return 2 + this.u2localVariableTableLength * 10;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2localVariableTableLength = dataInput.readUnsignedShort();
        this.localVariableTable = new LocalVariableInfo[this.u2localVariableTableLength];
        for (int i = 0; i < this.u2localVariableTableLength; ++i) {
            this.localVariableTable[i] = LocalVariableInfo.create(dataInput);
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2localVariableTableLength);
        for (int i = 0; i < this.u2localVariableTableLength; ++i) {
            this.localVariableTable[i].write(dataOutput);
        }
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, AttrInfoVisitor attrInfoVisitor) {
        attrInfoVisitor.visitLocalVariableTableAttrInfo(classFile, methodInfo, codeAttrInfo, this);
    }

    public void localVariablesAccept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfoVisitor localVariableInfoVisitor) {
        for (int i = 0; i < this.u2localVariableTableLength; ++i) {
            localVariableInfoVisitor.visitLocalVariableInfo(classFile, methodInfo, codeAttrInfo, this.localVariableTable[i]);
        }
    }
}

