/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;

public class StringCpInfo
extends CpInfo {
    public int u2stringIndex;
    public ClassFile referencedClassFile;

    protected StringCpInfo() {
    }

    public StringCpInfo(int n, ClassFile classFile) {
        this.u2stringIndex = n;
        this.referencedClassFile = classFile;
    }

    public String getString(ClassFile classFile) {
        return classFile.getCpString(this.u2stringIndex);
    }

    public int getTag() {
        return 8;
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        this.u2stringIndex = dataInput.readUnsignedShort();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2stringIndex);
    }

    public void accept(ClassFile classFile, CpInfoVisitor cpInfoVisitor) {
        cpInfoVisitor.visitStringCpInfo(classFile, this);
    }

    public void referencedClassAccept(ClassFileVisitor classFileVisitor) {
        if (this.referencedClassFile != null) {
            this.referencedClassFile.accept(classFileVisitor);
        }
    }
}

