/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public abstract class RefCpInfo
extends CpInfo {
    public int u2classIndex;
    public int u2nameAndTypeIndex;
    public ClassFile referencedClassFile;
    public MemberInfo referencedMemberInfo;

    protected RefCpInfo() {
    }

    public int getClassIndex() {
        return this.u2classIndex;
    }

    public int getNameAndTypeIndex() {
        return this.u2nameAndTypeIndex;
    }

    public void setNameAndTypeIndex(int n) {
        this.u2nameAndTypeIndex = n;
    }

    public String getClassName(ClassFile classFile) {
        return classFile.getCpClassNameString(this.u2classIndex);
    }

    public String getName(ClassFile classFile) {
        return classFile.getCpNameString(this.u2nameAndTypeIndex);
    }

    public String getType(ClassFile classFile) {
        return classFile.getCpTypeString(this.u2nameAndTypeIndex);
    }

    public void referencedClassAccept(ClassFileVisitor classFileVisitor) {
        if (this.referencedClassFile != null) {
            this.referencedClassFile.accept(classFileVisitor);
        }
    }

    public void referencedMemberInfoAccept(MemberInfoVisitor memberInfoVisitor) {
        if (this.referencedMemberInfo != null) {
            this.referencedMemberInfo.accept(this.referencedClassFile, memberInfoVisitor);
        }
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        this.u2classIndex = dataInput.readUnsignedShort();
        this.u2nameAndTypeIndex = dataInput.readUnsignedShort();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2classIndex);
        dataOutput.writeShort(this.u2nameAndTypeIndex);
    }
}

