/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.codehaus.xfire.addressing.AbstactAddressingHeadersFactory;
import org.codehaus.xfire.addressing.AddressingHeaders;
import org.codehaus.xfire.addressing.EndpointReference;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class AddressingHeadersFactory200408
extends AbstactAddressingHeadersFactory {
    public AddressingHeaders createHeaders(Element root) {
        Element faultTo;
        Element replyTo;
        AddressingHeaders headers = new AddressingHeaders();
        Namespace wsa = Namespace.getNamespace((String)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
        Element from = root.getChild("From", wsa);
        if (from != null) {
            headers.setFrom(this.createEPR(from));
        }
        if ((replyTo = root.getChild("ReplyTo", wsa)) != null) {
            headers.setReplyTo(this.createEPR(replyTo));
        }
        if ((faultTo = root.getChild("FaultTo", wsa)) != null) {
            headers.setFaultTo(this.createEPR(faultTo));
        }
        headers.setMessageID(this.getChildValue(root, "MessageID", wsa));
        Element relatesTo = root.getChild("RelatesTo", wsa);
        if (relatesTo != null) {
            headers.setRelatesTo(relatesTo.getValue());
            String relation = relatesTo.getAttributeValue("RelationshipType");
            if (relation != null) {
                headers.setRelationshipType(AddressingHeadersFactory200408.stringToQName(relatesTo, relation));
            } else {
                headers.setRelationshipType(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Reply"));
            }
        }
        headers.setTo(this.getChildValue(root, "To", wsa));
        headers.setAction(this.getChildValue(root, "Action", wsa));
        return headers;
    }

    public EndpointReference createEPR(Element eprElement) {
        EndpointReference epr = new EndpointReference();
        Object anyContent = null;
        List elements = eprElement.getChildren();
        String version = eprElement.getNamespaceURI();
        epr.setElement(eprElement);
        Iterator itr = elements.iterator();
        while (itr.hasNext()) {
            Element e = (Element)itr.next();
            if (!e.getNamespaceURI().equals(version)) continue;
            if (e.getName().equals("ServiceName")) {
                epr.setServiceName(AddressingHeadersFactory200408.elementToQName(e));
                epr.setEndpointName(e.getAttributeValue("EndpointName", version));
                continue;
            }
            if (e.getName().equals("InterfaceName")) {
                epr.setInterfaceName(AddressingHeadersFactory200408.elementToQName(e));
                continue;
            }
            if (!e.getName().equals("Policies")) continue;
            ArrayList policies = new ArrayList();
            List polEls = e.getChildren();
            Iterator pitr = polEls.iterator();
            while (pitr.hasNext()) {
                policies.add(pitr.next());
            }
            epr.setPolicies(policies);
        }
        return epr;
    }

    public boolean hasHeaders(Element root) {
        return root.getChild("Action", Namespace.getNamespace((String)"http://schemas.xmlsoap.org/ws/2004/08/addressing")) != null;
    }

    public void writeHeaders(Element root, AddressingHeaders headers) {
        Namespace ns = Namespace.getNamespace((String)"wsa", (String)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
        root.addNamespaceDeclaration(ns);
        if (headers.getTo() != null) {
            Element to = new Element("To", ns);
            to.addContent(headers.getTo());
            root.addContent((Content)to);
        }
        if (headers.getAction() != null) {
            Element action = new Element("Action", ns);
            action.addContent(headers.getAction());
            root.addContent((Content)action);
        }
        if (headers.getFaultTo() != null) {
            Element faultTo = new Element("FaultTo", ns);
            root.addContent((Content)faultTo);
            this.writeEPR(faultTo, headers.getFaultTo());
        }
        if (headers.getFrom() != null) {
            Element from = new Element("From", ns);
            root.addContent((Content)from);
            this.writeEPR(from, headers.getFrom());
        }
        if (headers.getMessageID() != null) {
            Element messageId = new Element("MessageID", ns);
            messageId.addContent(headers.getMessageID());
            root.addContent((Content)messageId);
        }
        if (headers.getRelatesTo() != null) {
            Element relatesTo = new Element("RelatesTo", ns);
            relatesTo.addContent(headers.getRelatesTo());
            root.addContent((Content)relatesTo);
            if (headers.getRelationshipType() != null) {
                String value = AddressingHeadersFactory200408.qnameToString(root, headers.getRelationshipType());
                relatesTo.setAttribute(new Attribute("RelationshipType", value));
            }
        }
        if (headers.getReplyTo() != null) {
            Element replyTo = new Element("ReplyTo", ns);
            root.addContent((Content)replyTo);
            this.writeEPR(replyTo, headers.getReplyTo());
        }
    }

    public void writeEPR(Element root, EndpointReference epr) {
        Namespace ns = Namespace.getNamespace((String)"wsa", (String)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
        Element address = new Element("Address", ns);
        address.addContent(epr.getAddress());
        root.addContent((Content)address);
        if (epr.getServiceName() != null) {
            Element serviceName = new Element("ServiceName", ns);
            serviceName.addContent(AddressingHeadersFactory200408.qnameToString((Element)root.getParent(), epr.getServiceName()));
            root.addContent((Content)serviceName);
            if (epr.getInterfaceName() != null) {
                String value = AddressingHeadersFactory200408.qnameToString((Element)root.getParent(), epr.getInterfaceName());
                serviceName.setAttribute(new Attribute("PortType", value));
            }
        }
    }

    public String getAnonymousUri() {
        return "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
    }

    public String getNoneUri() {
        return null;
    }
}

