/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm.usmmib;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.usm.SnmpUsmAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;
import com.sun.management.snmp.usm.usmmib.EnumUsmUserStatus;
import com.sun.management.snmp.usm.usmmib.EnumUsmUserStorageType;
import com.sun.management.snmp.usm.usmmib.TableUsmUserTableImpl;
import com.sun.management.snmp.usm.usmmib.UsmUserEntry;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class UsmUserEntryImpl
extends UsmUserEntry {
    private static final long serialVersionUID = 7849396415731734840L;
    SnmpUsmSecureUser user = null;
    SnmpUsmLcd lcd = null;
    UsmUserEntryImpl original = null;
    TableUsmUserTableImpl table = null;
    private String dbgTag = "UsmUserEntryImpl";
    SnmpOid oid = null;
    private String prefix = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "UsmUserEntryImpl");

    public UsmUserEntryImpl(SnmpEngine snmpEngine, SnmpMib snmpMib, SnmpUsmLcd snmpUsmLcd, SnmpUsmSecureUser snmpUsmSecureUser, TableUsmUserTableImpl tableUsmUserTableImpl) {
        super(snmpMib);
        this.prefix = snmpEngine.getEngineId().toString() + "/UsmUserTable:";
        this.user = snmpUsmSecureUser;
        this.table = tableUsmUserTableImpl;
        this.UsmUserAuthKeyChange = null;
        this.UsmUserPrivKeyChange = null;
        this.lcd = snmpUsmLcd;
    }

    synchronized void setUser(SnmpUsmSecureUser snmpUsmSecureUser) {
        this.user = snmpUsmSecureUser;
    }

    synchronized SnmpUsmSecureUser getUser() {
        return this.user;
    }

    private String convertAuthAlgorithm(SnmpUsmAlgorithm snmpUsmAlgorithm) {
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            return "1.3.6.1.6.3.10.1.1.1";
        }
        return this.getUser().getAuthPair().algo.getOid();
    }

    private String convertPrivAlgorithm() {
        if ((this.getUser().getSecurityLevel() & 2) == 0) {
            return "1.3.6.1.6.3.10.1.2.1";
        }
        return this.getUser().getPrivPair().algo.getOid();
    }

    protected ObjectName createObjectName() throws MalformedObjectNameException {
        String string = this.user.getEngineId().toString();
        return new ObjectName(this.prefix + "name=" + this.user.getName());
    }

    public void addInMBeanServer(MBeanServer mBeanServer) {
        block2: {
            try {
                mBeanServer.registerMBean(this, this.createObjectName());
            }
            catch (Exception exception) {
                if (!logger.finerOn()) break block2;
                logger.finer("addInMBeanServer", exception.toString());
            }
        }
    }

    public void removeFromMBeanServer(MBeanServer mBeanServer) {
        block2: {
            try {
                mBeanServer.unregisterMBean(this.createObjectName());
            }
            catch (Exception exception) {
                if (!logger.finerOn()) break block2;
                logger.finer("addInMBeanServer", exception.toString());
            }
        }
    }

    public String getUsmUserSecurityName() throws SnmpStatusException {
        return this.getUser().getSecurityName();
    }

    public Byte[] getUsmUserPrivKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public void checkUsmUserPrivKeyChange(Byte[] byteArray) throws SnmpStatusException {
        if ((this.getUser().getSecurityLevel() & 2) == 0) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivKeyChange", "No privacy, return.");
            }
            return;
        }
        int n = this.user.getPrivPair().algo.getDeltaSize();
        if (logger.finestOn()) {
            logger.finest("checkUsmUserPrivKeyChange", "Expected delta and random size: " + n);
        }
        if (byteArray.length != n) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivKeyChange", "Received delta is wrong: " + byteArray.length);
            }
            throw new SnmpStatusException(10);
        }
        if (logger.finestOn()) {
            logger.finest("checkUsmUserPrivKeyChange", "check OK");
        }
    }

    public void setUsmUserPrivKeyChange(Byte[] byteArray) throws SnmpStatusException {
        int n;
        Byte[] byteArray2;
        if ((this.getUser().getSecurityLevel() & 2) == 0) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserPrivKeyChange", "No privacy, return.");
            }
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserPrivKeyChange", "Will do priv key change.");
        }
        if ((byteArray2 = this.getUsmUserPublic()) == null) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivKeyChange", "Random is null can't process key change");
            }
            throw new SnmpStatusException(10);
        }
        int n2 = this.user.getPrivPair().algo.getDeltaSize();
        if (byteArray2.length != n2) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivKeyChange", "Random is wrong: " + byteArray2.length);
            }
            throw new SnmpStatusException(10);
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserPrivKeyChange", "Random is : " + byteArray2);
        }
        byte[] byArray = new byte[byteArray.length + byteArray2.length];
        for (n = 0; n < byteArray2.length; ++n) {
            byArray[n] = byteArray2[n];
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserPrivKeyChange", "Random is : " + SnmpTools.binary2ascii(byArray, byteArray2.length));
        }
        for (n = 0; n < byteArray.length; ++n) {
            byArray[n + byteArray2.length] = byteArray[n];
        }
        this.lcd.setUserPrivKeyChange(this.user, byArray);
        super.setUsmUserPrivKeyChange(byteArray);
    }

    public Byte[] getUsmUserAuthKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public void checkUsmUserAuthKeyChange(Byte[] byteArray) throws SnmpStatusException {
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthKeyChange", "No authentication, return.");
            }
            return;
        }
        int n = this.user.getAuthPair().algo.getDeltaSize();
        if (logger.finestOn()) {
            logger.finest("checkUsmUserAuthKeyChange", "Expected delta and random size: " + n);
        }
        if (byteArray.length != n) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthKeyChange", "Received delta is wrong: " + byteArray.length);
            }
            throw new SnmpStatusException(10);
        }
        if (logger.finestOn()) {
            logger.finest("checkUsmUserAuthKeyChange", "check OK");
        }
    }

    public void setUsmUserAuthKeyChange(Byte[] byteArray) throws SnmpStatusException {
        int n;
        Byte[] byteArray2;
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserAuthKeyChange", "No authentication, return.");
            }
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserAuthKeyChange", "Will do auth key change.");
        }
        if ((byteArray2 = this.getUsmUserPublic()) == null) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserAuthKeyChange", "Random is null can't process key change");
            }
            throw new SnmpStatusException(10);
        }
        int n2 = this.user.getAuthPair().algo.getDeltaSize();
        if (byteArray2.length != n2) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserAuthKeyChange", "Random is wrong: " + byteArray2.length);
            }
            throw new SnmpStatusException(10);
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserAuthKeyChange", "Random is : " + byteArray2);
        }
        byte[] byArray = new byte[byteArray.length + byteArray2.length];
        for (n = 0; n < byteArray2.length; ++n) {
            byArray[n] = byteArray2[n];
        }
        for (n = 0; n < byteArray.length; ++n) {
            byArray[n + byteArray2.length] = byteArray[n];
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserAuthKeyChange", "Received key change : " + SnmpTools.binary2ascii(byArray));
        }
        this.lcd.setUserAuthKeyChange(this.user, byArray);
        super.setUsmUserAuthKeyChange(byteArray);
    }

    public void setUsmUserOwnPrivKeyChange(Byte[] byteArray) throws SnmpStatusException {
        this.setUsmUserPrivKeyChange(byteArray);
    }

    public Byte[] getUsmUserOwnPrivKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public Byte[] getUsmUserOwnAuthKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public void setUsmUserOwnAuthKeyChange(Byte[] byteArray) throws SnmpStatusException {
        this.setUsmUserAuthKeyChange(byteArray);
    }

    public String getUsmUserPrivProtocol() throws SnmpStatusException {
        return this.convertPrivAlgorithm();
    }

    public void setUsmUserPrivProtocol(String string) throws SnmpStatusException {
        super.setUsmUserPrivProtocol(string);
        if (logger.finestOn()) {
            logger.finest("setUsmUserPrivProtocol", "priv protocol : " + string);
        }
        this.user.setPrivAlgorithm(string);
    }

    public void checkUsmUserPrivProtocol(String string) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("checkUsmUserPrivProtocol", "priv protocol : " + string);
        }
        if (string.equals("1.3.6.1.6.3.10.1.2.1")) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivProtocol", "priv protocol will be set to no protocol");
            }
            return;
        }
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivProtocol", "Unsupported security level. Security level is : " + (this.getUser().getSecurityLevel() & 2));
            }
            throw new SnmpStatusException(12);
        }
        if (this.getUsmUserStatus().intValue() == 1) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivProtocol", "Status already active, failed");
            }
            throw new SnmpStatusException(12);
        }
        if (this.lcd.getAlgorithmManager().getAlgorithm(string) == null) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivProtocol", "Unknown algo : " + string);
            }
            throw new SnmpStatusException(10);
        }
    }

    public String getUsmUserAuthProtocol() throws SnmpStatusException {
        return this.convertAuthAlgorithm(this.user.getAuthPair().algo);
    }

    public void setUsmUserAuthProtocol(String string) throws SnmpStatusException {
        super.setUsmUserAuthProtocol(string);
        if (logger.finestOn()) {
            logger.finest("setUsmUserAuthProtocol", "auth protocol : " + string);
        }
        this.user.setAuthAlgorithm(string);
    }

    public void checkUsmUserAuthProtocol(String string) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("checkUsmUserAuthProtocol", "auth protocol : " + string);
        }
        if (string.equals("1.3.6.1.6.3.10.1.1.1")) {
            if ((this.getUser().getSecurityLevel() & 2) != 0) {
                if (logger.finestOn()) {
                    logger.finest("checkUsmUserAuthProtocol", "Unsupported security level. Security level is : " + (this.getUser().getSecurityLevel() & 2));
                }
                throw new SnmpStatusException(12);
            }
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthProtocol", "auth protocol is no protocol.");
            }
            return;
        }
        if (this.getUsmUserStatus().intValue() == 1) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthProtocol", "auth protocol already active. Failed");
            }
            throw new SnmpStatusException(12);
        }
        if (this.lcd.getAlgorithmManager().getAlgorithm(string) == null) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthProtocol", "Unknown algo : " + string);
            }
            throw new SnmpStatusException(10);
        }
    }

    public EnumUsmUserStorageType getUsmUserStorageType() throws SnmpStatusException {
        EnumUsmUserStorageType enumUsmUserStorageType = new EnumUsmUserStorageType(this.user.getStorageType());
        return enumUsmUserStorageType;
    }

    public void setUsmUserStorageType(EnumUsmUserStorageType enumUsmUserStorageType) throws SnmpStatusException {
        super.setUsmUserStorageType(enumUsmUserStorageType);
        if (logger.finestOn()) {
            logger.finest("setUsmUserStorageType", "Enum : " + enumUsmUserStorageType.toString());
        }
        this.user.setStorageType(enumUsmUserStorageType.intValue());
    }

    public void checkUsmUserStorageType(EnumUsmUserStorageType enumUsmUserStorageType) throws SnmpStatusException {
        if (enumUsmUserStorageType.intValue() != 3 && enumUsmUserStorageType.intValue() != 2) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserStorageType", "Wrong storage type :" + enumUsmUserStorageType.intValue());
            }
            throw new SnmpStatusException(10);
        }
        if (this.lcd.getStorageType() < enumUsmUserStorageType.intValue()) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserStorageType", "Unsupported storage type :" + enumUsmUserStorageType.intValue());
            }
            throw new SnmpStatusException(12);
        }
    }

    public Byte[] getUsmUserEngineID() throws SnmpStatusException {
        byte[] byArray = this.user.getEngineId().getBytes();
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        return byteArray;
    }

    public String getUsmUserName() throws SnmpStatusException {
        return this.user.getName();
    }

    public String getUsmUserCloneFrom() throws SnmpStatusException {
        return "0.0";
    }

    public void checkUsmUserCloneFrom(String string) throws SnmpStatusException {
        if (this.original != null) {
            return;
        }
        try {
            this.original = this.table.getCloneFromUser(string);
        }
        catch (SnmpStatusException snmpStatusException) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserCloneFrom", "Exception : " + snmpStatusException);
            }
            throw new SnmpStatusException(18);
        }
        if (this.original == null) {
            throw new SnmpStatusException(18);
        }
        this.UsmUserCloneFrom = string;
        EnumUsmUserStatus enumUsmUserStatus = this.original.getUsmUserStatus();
        if (enumUsmUserStatus.intValue() != 1) {
            throw new SnmpStatusException(18);
        }
    }

    public void setUsmUserCloneFrom(String string) throws SnmpStatusException {
        if (this.original == null) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserCloneFrom", "original == null");
            }
            throw new SnmpStatusException(18);
        }
        SnmpUsmSecureUser snmpUsmSecureUser = this.original.getUser();
        this.user.cloneAuthPair(snmpUsmSecureUser.getAuthPair());
        this.user.clonePrivPair(snmpUsmSecureUser.getPrivPair());
        super.setUsmUserCloneFrom(string);
    }

    public void setUsmUserStatus(EnumUsmUserStatus enumUsmUserStatus) throws SnmpStatusException {
        if (this.getUsmUserStatus().intValue() == 1) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserStatus", "Already active. Return");
            }
            return;
        }
        if (this.user.isTemplate()) {
            super.setUsmUserStatus(enumUsmUserStatus);
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserStatus", "Setting status to : " + enumUsmUserStatus.intValue());
        }
        if (enumUsmUserStatus.intValue() == 1) {
            try {
                this.lcd.addUser(this.user, false);
            }
            catch (SnmpUsmException snmpUsmException) {
                if (logger.finestOn()) {
                    logger.finest("setUsmUserStatus", " error when adding a user : " + snmpUsmException);
                }
                throw new SnmpStatusException(15);
            }
        }
        super.setUsmUserStatus(enumUsmUserStatus);
    }

    public void checkUsmUserStatus(EnumUsmUserStatus enumUsmUserStatus) throws SnmpStatusException {
        if (this.getUsmUserStatus().intValue() == 1) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserStatus", "Already active. Return");
            }
            return;
        }
        if (enumUsmUserStatus.intValue() == 1) {
            if (this.original == null) {
                if (logger.finestOn()) {
                    logger.finest("checkUsmUserStatus", "cloneFrom not done. Can't switch to active state.");
                }
                throw new SnmpStatusException(12);
            }
            if (this.user.getAuthPair().algo != null && this.user.getAuthPair().key != null && this.UsmUserAuthKeyChange == null) {
                if (logger.finestOn()) {
                    logger.finest("checkUsmUserStatus", "Auth key change not done. Can't switch to active state.");
                }
                throw new SnmpStatusException(12);
            }
            if (this.user.getPrivPair().algo != null && this.user.getPrivPair().key != null && this.UsmUserPrivKeyChange == null) {
                if (logger.finestOn()) {
                    logger.finest("checkUsmUserStatus", "Priv key change not done. Can't switch to active state.");
                }
                throw new SnmpStatusException(12);
            }
        }
    }
}

