/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpValue;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpString
extends SnmpValue {
    private static final long serialVersionUID = -7995335496739639922L;
    static final String name = "String";
    protected byte[] value = null;

    public SnmpString() {
        this.value = new byte[0];
    }

    public SnmpString(byte[] byArray) {
        this.value = (byte[])byArray.clone();
    }

    public SnmpString(Byte[] byteArray) {
        this.value = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            this.value[i] = byteArray[i];
        }
    }

    public SnmpString(String string) {
        this.value = string.getBytes();
    }

    public SnmpString(InetAddress inetAddress) {
        this.value = inetAddress.getAddress();
    }

    public InetAddress inetAddressValue() throws UnknownHostException {
        return InetAddress.getByAddress(this.value);
    }

    public static String BinToChar(String string) {
        char[] cArray = new char[string.length() / 8];
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)Integer.parseInt(string.substring(8 * i, 8 * i + 8), 2);
        }
        return new String(cArray);
    }

    public static String HexToChar(String string) {
        char[] cArray = new char[string.length() / 2];
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
        }
        return new String(cArray);
    }

    public byte[] byteValue() {
        return this.value;
    }

    public Byte[] toByte() {
        Byte[] byteArray = new Byte[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            byteArray[i] = new Byte(this.value[i]);
        }
        return byteArray;
    }

    public String toString() {
        return new String(this.value);
    }

    public SnmpOid toOid() {
        long[] lArray = new long[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            lArray[i] = this.value[i] & 0xFF;
        }
        return new SnmpOid(lArray);
    }

    public static SnmpOid toOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            if (lArray[n] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            int n2 = (int)lArray[n++];
            long[] lArray2 = new long[n2];
            for (int i = 0; i < n2; ++i) {
                lArray2[i] = lArray[n + i];
            }
            return new SnmpOid(lArray2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            int n2;
            if (lArray[n] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            if ((n += (n2 = (int)lArray[n++])) <= lArray.length) {
                return n;
            }
            throw new SnmpStatusException(2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        snmpOid2.append(snmpOid.getLength());
        snmpOid2.append(snmpOid);
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public synchronized Object clone() {
        SnmpString snmpString = null;
        try {
            snmpString = (SnmpString)super.clone();
            snmpString.value = new byte[this.value.length];
            System.arraycopy(this.value, 0, snmpString.value, 0, this.value.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return snmpString;
    }

    public String getTypeName() {
        return name;
    }
}

