/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class HttpsSocket
extends GenericHttpSocket {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.https", "HttpsSocket");
    private int backlog = 10;
    private Socket sckAccept = null;
    private SSLSocket clientSocket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private SSLServerSocket serverSocket = null;
    private SSLSocketFactory clientSocketFactory = null;
    private SSLServerSocketFactory serverSocketFactory = null;
    private boolean needClientAuth = true;
    static /* synthetic */ Class class$java$lang$String;

    public HttpsSocket() {
    }

    public HttpsSocket(int n) {
        this.port = n;
    }

    public HttpsSocket(int n, InetAddress inetAddress) {
        this.port = n;
        this.bindAddr = inetAddress;
    }

    public HttpsSocket(int n, InetAddress inetAddress, boolean bl) {
        this.port = n;
        this.bindAddr = inetAddress;
        this.needClientAuth = bl;
    }

    public GenericHttpSocket createServerSocket(int n) {
        HttpsSocket httpsSocket = new HttpsSocket(n, null, this.needClientAuth);
        httpsSocket.setTimeout(this.getTimeout());
        return httpsSocket;
    }

    public GenericHttpSocket createServerSocket(int n, InetAddress inetAddress) {
        HttpsSocket httpsSocket = new HttpsSocket(n, inetAddress, this.needClientAuth);
        httpsSocket.setTimeout(this.getTimeout());
        return httpsSocket;
    }

    public GenericHttpSocket createClientSocket() {
        HttpsSocket httpsSocket = new HttpsSocket(0);
        httpsSocket.setTimeout(this.getTimeout());
        return httpsSocket;
    }

    public String getProtocol() {
        return "https";
    }

    public void doBind() throws IOException {
        String[] stringArray;
        String string;
        int n;
        StringBuffer stringBuffer;
        this.serverSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        this.serverSocket = this.bindAddr == null ? (SSLServerSocket)this.serverSocketFactory.createServerSocket(this.port, this.backlog) : (SSLServerSocket)this.serverSocketFactory.createServerSocket(this.port, this.backlog, this.bindAddr);
        this.serverSocket.setNeedClientAuth(this.needClientAuth);
        String[] stringArray2 = this.serverSocket.getSupportedCipherSuites();
        if (logger.finerOn()) {
            logger.finer("doBind", "Supported Cipher Suites");
        }
        if (stringArray2 != null) {
            stringBuffer = new StringBuffer();
            for (n = 0; n < stringArray2.length; ++n) {
                stringBuffer.append(stringArray2[n]);
                if (n + 1 >= stringArray2.length) continue;
                stringBuffer.append(", ");
            }
            if (logger.finerOn()) {
                logger.finer("doBind", "[" + stringBuffer + "]");
            }
        } else if (logger.finerOn()) {
            logger.finer("doBind", "[]");
        }
        Vector<String> vector = new Vector<String>();
        n = 1;
        while ((string = System.getProperty("jdmk.ssl.cipher.suite." + String.valueOf(n))) != null) {
            vector.addElement(string);
            ++n;
        }
        if (logger.finerOn()) {
            logger.finer("doBind", "User Specified Cipher Suites");
            logger.finer("doBind", vector.toString());
        }
        Vector<String> vector2 = new Vector<String>();
        if (vector != null && vector.size() > 0) {
            stringArray = vector.elements();
            block2: while (stringArray.hasMoreElements()) {
                string = (String)stringArray.nextElement();
                if (stringArray2 == null) continue;
                for (n = 0; n < stringArray2.length; ++n) {
                    if (!stringArray2[n].equals(string)) continue;
                    vector2.addElement(string);
                    continue block2;
                }
            }
        }
        if (logger.finerOn()) {
            logger.finer("doBind", "Supported User Specified Cipher Suites");
            logger.finer("doBind", vector2.toString());
        }
        if (vector2 != null && vector2.size() > 0) {
            n = 0;
            stringArray = (String[])Array.newInstance(class$java$lang$String == null ? (class$java$lang$String = HttpsSocket.class$("java.lang.String")) : class$java$lang$String, vector2.size());
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                Array.set(stringArray, n, string);
                ++n;
            }
            this.serverSocket.setEnabledCipherSuites(stringArray);
        }
        stringArray = this.serverSocket.getEnabledCipherSuites();
        if (logger.finerOn()) {
            logger.finer("doBind", "Enabled Cipher Suites");
        }
        if (stringArray != null) {
            stringBuffer = new StringBuffer();
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append(stringArray[n]);
                if (n + 1 >= stringArray.length) continue;
                stringBuffer.append(", ");
            }
            if (logger.finerOn()) {
                logger.finer("doBind", "[" + stringBuffer + "]");
            }
        } else if (logger.finerOn()) {
            logger.finer("doBind", "[]");
        }
    }

    public void doUnbind() throws IOException {
        this.serverSocket.close();
    }

    public void doConnect(String string, int n) throws UnknownHostException, IOException, CommunicationException {
        String[] stringArray;
        String string2;
        int n2;
        StringBuffer stringBuffer;
        this.clientSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.clientSocket = (SSLSocket)this.clientSocketFactory.createSocket(string, n);
        this.clientSocket.setSoTimeout(this.getTimeout());
        String[] stringArray2 = this.clientSocket.getSupportedCipherSuites();
        if (logger.finerOn()) {
            logger.finer("doConnect", "Supported Cipher Suites");
        }
        if (stringArray2 != null) {
            stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                stringBuffer.append(stringArray2[n2]);
                if (n2 + 1 >= stringArray2.length) continue;
                stringBuffer.append(", ");
            }
            if (logger.finerOn()) {
                logger.finer("doConnect", "[" + stringBuffer + "]");
            }
        } else if (logger.finerOn()) {
            logger.finer("doConnect", "[]");
        }
        Vector<String> vector = new Vector<String>();
        n2 = 1;
        while ((string2 = System.getProperty("jdmk.ssl.cipher.suite." + String.valueOf(n2))) != null) {
            vector.addElement(string2);
            ++n2;
        }
        if (logger.finerOn()) {
            logger.finer("doConnect", "User Specified Cipher Suites");
            logger.finer("doConnect", vector.toString());
        }
        Vector<String> vector2 = new Vector<String>();
        if (vector != null && vector.size() > 0) {
            stringArray = vector.elements();
            block2: while (stringArray.hasMoreElements()) {
                string2 = (String)stringArray.nextElement();
                if (stringArray2 == null) continue;
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    if (!stringArray2[n2].equals(string2)) continue;
                    vector2.addElement(string2);
                    continue block2;
                }
            }
        }
        if (logger.finerOn()) {
            logger.finer("doConnect", "Supported User Specified Cipher Suites");
            logger.finer("doConnect", vector2.toString());
        }
        if (vector2 != null && vector2.size() > 0) {
            n2 = 0;
            stringArray = (String[])Array.newInstance(class$java$lang$String == null ? (class$java$lang$String = HttpsSocket.class$("java.lang.String")) : class$java$lang$String, vector2.size());
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                Array.set(stringArray, n2, string2);
                ++n2;
            }
            this.clientSocket.setEnabledCipherSuites(stringArray);
        }
        stringArray = this.clientSocket.getEnabledCipherSuites();
        if (logger.finerOn()) {
            logger.finer("doConnect", "Enabled Cipher Suites");
        }
        if (stringArray != null) {
            stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringBuffer.append(stringArray[n2]);
                if (n2 + 1 >= stringArray.length) continue;
                stringBuffer.append(", ");
            }
            if (logger.finerOn()) {
                logger.finer("doConnect", "[" + stringBuffer + "]");
            }
        } else if (logger.finerOn()) {
            logger.finer("doConnect", "[]");
        }
    }

    public void doDisconnect() throws IOException, CommunicationException {
        if (this.serverSocket != null) {
            this.sckAccept.close();
            this.sckAccept = null;
        } else if (this.clientSocket != null) {
            this.clientSocket.close();
            this.clientSocket = null;
        }
    }

    public void doSend(String string, byte[] byArray) throws IOException {
        this.outputStream = this.serverSocket != null ? this.sckAccept.getOutputStream() : this.clientSocket.getOutputStream();
        this.outputStream.write(string.getBytes());
        if (byArray != null) {
            this.outputStream.write(byArray);
        }
        this.outputStream.flush();
    }

    public InputStream doReceive() throws IOException {
        if (this.serverSocket != null) {
            this.sckAccept = this.serverSocket.accept();
            this.sckAccept.setSoTimeout(this.getTimeout());
            this.inputStream = this.sckAccept.getInputStream();
        } else {
            this.inputStream = this.clientSocket.getInputStream();
        }
        return this.inputStream;
    }

    public InputStream doGetInputStream() throws IOException {
        this.inputStream = this.serverSocket != null ? this.sckAccept.getInputStream() : this.clientSocket.getInputStream();
        return this.inputStream;
    }

    public OutputStream doGetOutputStream() throws IOException {
        this.outputStream = this.serverSocket != null ? this.sckAccept.getOutputStream() : this.clientSocket.getOutputStream();
        return this.outputStream;
    }

    public InetAddress getLocalAddress() {
        if (this.serverSocket != null) {
            return this.serverSocket.getInetAddress();
        }
        return this.clientSocket.getLocalAddress();
    }

    public int getLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.clientSocket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        if (this.serverSocket != null) {
            return this.sckAccept.getInetAddress();
        }
        return this.clientSocket.getInetAddress();
    }

    public int getRemotePort() {
        if (this.serverSocket != null) {
            return this.sckAccept.getPort();
        }
        return this.clientSocket.getPort();
    }

    public String toString() {
        return this.serverSocket.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

