/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.MBeanServerForwarder;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServerMBean;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class CommunicatorServer
implements Runnable,
MBeanRegistration,
NotificationBroadcaster,
CommunicatorServerMBean {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    public static final int RMI_TYPE = 1;
    public static final int HTTP_TYPE = 2;
    public static final int HTML_TYPE = 3;
    public static final int SNMP_TYPE = 4;
    public static final int HTTPS_TYPE = 5;
    volatile transient int state = 1;
    ObjectName objectName;
    MBeanServer topMBS;
    MBeanServer bottomMBS;
    transient String dbgTag = null;
    int maxActiveClientCount = 1;
    transient int servedClientCount = 0;
    String host = null;
    int port = -1;
    private transient Object stateLock = new Object();
    private transient Vector clientHandlerVector = new Vector();
    private transient Thread fatherThread = Thread.currentThread();
    private transient Thread mainThread = null;
    private volatile boolean stopRequested = false;
    private boolean interrupted = false;
    private transient long notifCount = 0L;
    private transient NotificationBroadcasterSupport notifBroadcaster = new NotificationBroadcasterSupport();
    private transient MBeanNotificationInfo[] notifInfos = null;
    transient ClassLogger logger;
    int infoType;
    static /* synthetic */ Class class$javax$management$AttributeChangeNotification;

    public CommunicatorServer(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                this.infoType = 256;
                break;
            }
            case 2: {
                this.infoType = 512;
                break;
            }
            case 3: {
                this.infoType = 16;
                break;
            }
            case 4: {
                this.infoType = 1024;
                break;
            }
            case 5: {
                this.infoType = 2048;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connector Type");
            }
        }
        this.dbgTag = this.makeDebugTag();
        this.logger = this.makeLogger(this.dbgTag);
    }

    ClassLogger makeLogger(String string) throws IllegalArgumentException {
        switch (this.infoType) {
            case 256: {
                return new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", string);
            }
            case 512: {
                return new ClassLogger("com.sun.jdmk.comm.legacy.connector.http", string);
            }
            case 16: {
                return new ClassLogger("com.sun.jdmk.html.adaptor", string);
            }
            case 1024: {
                return new ClassLogger("com.sun.jdmk.snmp.adaptor", string);
            }
            case 2048: {
                return new ClassLogger("com.sun.jdmk.comm.legacy.connector.https", string);
            }
        }
        throw new IllegalArgumentException("Invalid connector Type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean bl;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                this.waitState(1, 60000L);
            }
            boolean bl2 = bl = this.state == 1;
            if (bl) {
                this.changeState(3);
                this.stopRequested = false;
                this.interrupted = false;
            }
        }
        if (!bl) {
            if (this.logger.finerOn()) {
                this.logger.finer("start", "Connector is not OFFLINE");
            }
            return;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("start", "--> Start connector ");
        }
        this.mainThread = new Thread((Runnable)this, this.makeThreadName());
        if (Thread.currentThread().getPriority() < 10) {
            this.mainThread.setPriority(Thread.currentThread().getPriority() + 1);
        }
        this.mainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1 || this.state == 2) {
                if (this.logger.finerOn()) {
                    this.logger.finer("stop", "Connector is not ONLINE");
                }
                return;
            }
            this.changeState(2);
            if (this.logger.finerOn()) {
                this.logger.finer("stop", "Interrupt main thread");
            }
            this.stopRequested = true;
            if (!this.interrupted) {
                this.interrupted = true;
                this.mainThread.interrupt();
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("stop", "terminateAllClient");
        }
        this.terminateAllClient();
        if (this.state == 3) {
            this.changeState(1);
        }
    }

    public boolean isActive() {
        return this.state == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitState(int n, long l) {
        if (this.logger.finerOn()) {
            this.logger.finer("waitState", n + "(0on,1off,2st) TO=" + l + " ; current state = " + this.getStateString());
        }
        long l2 = 0L;
        if (l > 0L) {
            l2 = System.currentTimeMillis() + l;
        }
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state != n) {
                if (l < 0L) {
                    if (!this.logger.finerOn()) return false;
                    this.logger.finer("waitState", "timeout < 0, return without wait");
                    return false;
                }
                try {
                    if (l > 0L) {
                        long l3 = l2 - System.currentTimeMillis();
                        if (l3 <= 0L) {
                            if (!this.logger.finerOn()) return false;
                            this.logger.finer("waitState", "timed out");
                            return false;
                        }
                        this.stateLock.wait(l3);
                        continue;
                    }
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("waitState", "wait interrupted");
                    }
                    if (this.state != n) return false;
                    return true;
                }
            }
            if (!this.logger.finerOn()) return true;
            this.logger.finer("waitState", "returning in desired state");
            return true;
        }
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return CommunicatorServer.getStringForState(this.state);
    }

    public String getHost() {
        try {
            this.host = System.getProperty("jdmk.hostname");
            if (this.host == null) {
                this.host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Exception exception) {
            this.host = "Unknown host";
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int n) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
            this.port = n;
            this.dbgTag = this.makeDebugTag();
        }
    }

    public abstract String getProtocol();

    int getServedClientCount() {
        return this.servedClientCount;
    }

    int getActiveClientCount() {
        int n = this.clientHandlerVector.size();
        return n;
    }

    int getMaxActiveClientCount() {
        return this.maxActiveClientCount;
    }

    void setMaxActiveClientCount(int n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.maxActiveClientCount = n;
    }

    void notifyClientHandlerCreated(ClientHandler clientHandler) {
        this.clientHandlerVector.addElement(clientHandler);
    }

    synchronized void notifyClientHandlerDeleted(ClientHandler clientHandler) {
        this.clientHandlerVector.removeElement(clientHandler);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block58: {
            ThreadDeath threadDeath;
            block53: {
                int n = 0;
                boolean bl = false;
                try {
                    while (n < 50 && !bl) {
                        try {
                            this.doBind();
                            bl = true;
                        }
                        catch (CommunicationException communicationException) {
                            ++n;
                            Thread.sleep(100L);
                        }
                    }
                    if (!bl) {
                        this.doBind();
                    }
                }
                catch (Exception exception) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("run", "Unexpected exception = " + exception);
                    }
                    this.changeState(1);
                    if (this.logger.finerOn()) {
                        this.logger.finer("run", "State is OFFLINE");
                    }
                    this.doError(exception);
                    return;
                }
                threadDeath = null;
                this.changeState(0);
                if (this.logger.finerOn()) {
                    this.logger.finer("run", "State is ONLINE");
                }
                while (!this.stopRequested) {
                    ++this.servedClientCount;
                    this.doReceive();
                    this.waitIfTooManyClients();
                    this.doProcess();
                }
                if (!this.logger.finerOn()) break block53;
                this.logger.finer("run", "Stop has been requested");
            }
            Object var6_10 = null;
            Object object2222 = this.stateLock;
            synchronized (object2222) {
                this.interrupted = true;
                Thread.currentThread();
                Thread.interrupted();
            }
            try {
                this.doUnbind();
                this.waitClientTermination();
                this.changeState(1);
                if (this.logger.finerOn()) {
                    this.logger.finer("run", "State is OFFLINE");
                }
            }
            catch (Exception object2222) {
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "Unexpected exception = " + object2222);
                }
                this.changeState(1);
            }
            if (threadDeath != null) {
                throw threadDeath;
            }
            break block58;
            {
                catch (InterruptedException interruptedException) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("run", "Interrupt caught");
                    }
                    this.changeState(2);
                    Object var6_11 = null;
                    Object object32222 = this.stateLock;
                    synchronized (object32222) {
                        this.interrupted = true;
                        Thread.currentThread();
                        Thread.interrupted();
                    }
                    try {
                        this.doUnbind();
                        this.waitClientTermination();
                        this.changeState(1);
                        if (this.logger.finerOn()) {
                            this.logger.finer("run", "State is OFFLINE");
                        }
                    }
                    catch (Exception object32222) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("run", "Unexpected exception = " + object32222);
                        }
                        this.changeState(1);
                    }
                    if (threadDeath != null) {
                        throw threadDeath;
                    }
                    break block58;
                }
                catch (Exception exception) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("run", "Unexpected exception = " + exception);
                    }
                    this.changeState(2);
                    Object var6_12 = null;
                    Object object42222 = this.stateLock;
                    synchronized (object42222) {
                        this.interrupted = true;
                        Thread.currentThread();
                        Thread.interrupted();
                    }
                    try {
                        this.doUnbind();
                        this.waitClientTermination();
                        this.changeState(1);
                        if (this.logger.finerOn()) {
                            this.logger.finer("run", "State is OFFLINE");
                        }
                    }
                    catch (Exception object42222) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("run", "Unexpected exception = " + object42222);
                        }
                        this.changeState(1);
                    }
                    if (threadDeath != null) {
                        throw threadDeath;
                    }
                    break block58;
                }
                catch (ThreadDeath threadDeath2) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("run", "ThreadDeath caught");
                    }
                    threadDeath = threadDeath2;
                    this.changeState(2);
                    Object var6_13 = null;
                    Object object52222 = this.stateLock;
                    synchronized (object52222) {
                        this.interrupted = true;
                        Thread.currentThread();
                        Thread.interrupted();
                    }
                    try {
                        this.doUnbind();
                        this.waitClientTermination();
                        this.changeState(1);
                        if (this.logger.finerOn()) {
                            this.logger.finer("run", "State is OFFLINE");
                        }
                    }
                    catch (Exception object52222) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("run", "Unexpected exception = " + object52222);
                        }
                        this.changeState(1);
                    }
                    if (threadDeath != null) {
                        throw threadDeath;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_14 = null;
                Object object62222 = this.stateLock;
                synchronized (object62222) {
                    this.interrupted = true;
                    Thread.currentThread();
                    Thread.interrupted();
                }
                try {
                    this.doUnbind();
                    this.waitClientTermination();
                    this.changeState(1);
                    if (this.logger.finerOn()) {
                        this.logger.finer("run", "State is OFFLINE");
                    }
                }
                catch (Exception object62222) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("run", "Unexpected exception = " + object62222);
                    }
                    this.changeState(1);
                }
                if (threadDeath != null) {
                    throw threadDeath;
                }
                throw throwable;
            }
        }
    }

    protected abstract void doError(Exception var1) throws CommunicationException;

    protected abstract void doBind() throws CommunicationException, InterruptedException;

    protected abstract void doReceive() throws CommunicationException, InterruptedException;

    protected abstract void doProcess() throws CommunicationException, InterruptedException;

    protected abstract void doUnbind() throws CommunicationException, InterruptedException;

    public synchronized MBeanServer getMBeanServer() {
        return this.topMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMBeanServer(MBeanServer mBeanServer) throws IllegalArgumentException, IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
        }
        Vector<MBeanServer> vector = new Vector<MBeanServer>();
        MBeanServer mBeanServer2 = mBeanServer;
        while (mBeanServer2 != this.bottomMBS) {
            if (!(mBeanServer2 instanceof MBeanServerForwarder)) {
                throw new IllegalArgumentException("MBeanServer argument must be MBean server where this server is registered, or an MBeanServerForwarder leading to that server");
            }
            if (vector.contains(mBeanServer2)) {
                throw new IllegalArgumentException("MBeanServerForwarder loop");
            }
            vector.addElement(mBeanServer2);
            mBeanServer2 = ((MBeanServerForwarder)mBeanServer2).getMBeanServer();
        }
        this.topMBS = mBeanServer;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeState(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == n) {
                return;
            }
            int n2 = this.state;
            this.state = n;
            this.stateLock.notifyAll();
            this.sendStateChangeNotification(n2, n);
        }
    }

    String makeDebugTag() {
        return "CommunicatorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    String makeThreadName() {
        String string = this.objectName == null ? "CommunicatorServer" : this.objectName.toString();
        return string;
    }

    private synchronized void waitIfTooManyClients() throws InterruptedException {
        while (this.getActiveClientCount() >= this.maxActiveClientCount) {
            if (this.logger.finerOn()) {
                this.logger.finer("waitIfTooManyClients", "Waiting for a client to terminate");
            }
            this.wait();
        }
    }

    private void waitClientTermination() {
        int n = this.clientHandlerVector.size();
        if (this.logger.finerOn() && n >= 1) {
            this.logger.finer("waitClientTermination", "waiting for " + n + " clients to terminate");
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.join();
        }
        if (this.logger.finerOn() && n >= 1) {
            this.logger.finer("waitClientTermination", "Ok, let's go...");
        }
    }

    private void terminateAllClient() {
        int n = this.clientHandlerVector.size();
        if (this.logger.finerOn() && n >= 1) {
            this.logger.finer("terminateAllClient", "Interrupting " + n + " clients");
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.interrupt();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stateLock = new Object();
        this.state = 1;
        this.stopRequested = false;
        this.servedClientCount = 0;
        this.clientHandlerVector = new Vector();
        this.fatherThread = Thread.currentThread();
        this.mainThread = null;
        this.notifCount = 0L;
        this.notifInfos = null;
        this.notifBroadcaster = new NotificationBroadcasterSupport();
        this.dbgTag = this.makeDebugTag();
        this.logger = this.makeLogger(this.dbgTag);
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (this.logger.finestOn()) {
            this.logger.finest("addNotificationListener", "Adding listener " + notificationListener + " with filter " + notificationFilter + " and handback " + object);
        }
        this.notifBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (this.logger.finestOn()) {
            this.logger.finest("removeNotificationListener", "Removing listener " + notificationListener);
        }
        this.notifBroadcaster.removeNotificationListener(notificationListener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifInfos == null) {
            this.notifInfos = new MBeanNotificationInfo[1];
            String[] stringArray = new String[]{"jmx.attribute.change"};
            this.notifInfos[0] = new MBeanNotificationInfo(stringArray, (class$javax$management$AttributeChangeNotification == null ? (class$javax$management$AttributeChangeNotification = CommunicatorServer.class$("javax.management.AttributeChangeNotification")) : class$javax$management$AttributeChangeNotification).getName(), "Sent to notify that the value of the State attribute of this CommunicatorServer instance has changed.");
        }
        return this.notifInfos;
    }

    private void sendStateChangeNotification(int n, int n2) {
        String string = CommunicatorServer.getStringForState(n);
        String string2 = CommunicatorServer.getStringForState(n2);
        String string3 = this.dbgTag + " The value of attribute State has changed from " + n + " (" + string + ") to " + n2 + " (" + string2 + ").";
        ++this.notifCount;
        AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this, this.notifCount, System.currentTimeMillis(), string3, "State", "int", new Integer(n), new Integer(n2));
        if (this.logger.finestOn()) {
            this.logger.finest("sendStateChangeNotification", "Sending AttributeChangeNotification #" + this.notifCount + " with message: " + string3);
        }
        this.notifBroadcaster.sendNotification(attributeChangeNotification);
    }

    private static String getStringForState(int n) {
        switch (n) {
            case 0: {
                return "ONLINE";
            }
            case 3: {
                return "STARTING";
            }
            case 1: {
                return "OFFLINE";
            }
            case 2: {
                return "STOPPING";
            }
        }
        return "UNDEFINED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            if (this.bottomMBS != null) {
                throw new IllegalArgumentException("connector already registered in an MBean server");
            }
            this.topMBS = this.bottomMBS = mBeanServer;
        }
        this.dbgTag = this.makeDebugTag();
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRegister(Boolean bl) {
        if (!bl.booleanValue()) {
            CommunicatorServer communicatorServer = this;
            synchronized (communicatorServer) {
                this.bottomMBS = null;
                this.topMBS = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeregister() throws Exception {
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            this.bottomMBS = null;
            this.topMBS = null;
        }
        this.objectName = null;
        if (this.state == 0 || this.state == 3) {
            this.stop();
        }
    }

    public void postDeregister() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

