/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.ModifiableClassLoaderRepository;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;

class CompatibleClassLoaderRepositorySupport
implements ModifiableClassLoaderRepository {
    private final MBeanServer inner;
    private static final String unsupported = "Operation not supported in this implementation";

    public CompatibleClassLoaderRepositorySupport(MBeanServer mBeanServer) {
        if (mBeanServer == null) {
            throw new IllegalArgumentException("inner MBeanServer is null");
        }
        this.inner = mBeanServer;
    }

    public void addClassLoader(ClassLoader classLoader) {
        ClassLoaderRepository classLoaderRepository = this.inner.getClassLoaderRepository();
        if (!(classLoaderRepository instanceof ModifiableClassLoaderRepository)) {
            throw new UnsupportedOperationException(unsupported);
        }
        ((ModifiableClassLoaderRepository)classLoaderRepository).addClassLoader(classLoader);
    }

    public void removeClassLoader(ClassLoader classLoader) {
        ClassLoaderRepository classLoaderRepository = this.inner.getClassLoaderRepository();
        if (!(classLoaderRepository instanceof ModifiableClassLoaderRepository)) {
            throw new UnsupportedOperationException(unsupported);
        }
        ((ModifiableClassLoaderRepository)classLoaderRepository).removeClassLoader(classLoader);
    }

    public void addClassLoader(ObjectName objectName, ClassLoader classLoader) {
        ClassLoaderRepository classLoaderRepository = this.inner.getClassLoaderRepository();
        if (!(classLoaderRepository instanceof ModifiableClassLoaderRepository)) {
            throw new UnsupportedOperationException(unsupported);
        }
        ((ModifiableClassLoaderRepository)classLoaderRepository).addClassLoader(objectName, classLoader);
    }

    public void removeClassLoader(ObjectName objectName) {
        ClassLoaderRepository classLoaderRepository = this.inner.getClassLoaderRepository();
        if (!(classLoaderRepository instanceof ModifiableClassLoaderRepository)) {
            throw new UnsupportedOperationException(unsupported);
        }
        ((ModifiableClassLoaderRepository)classLoaderRepository).removeClassLoader(objectName);
    }

    public ClassLoader getClassLoader(ObjectName objectName) {
        try {
            return this.inner.getClassLoader(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return null;
        }
    }

    public final Class loadClass(String string) throws ClassNotFoundException {
        ClassLoaderRepository classLoaderRepository = this.inner.getClassLoaderRepository();
        if (classLoaderRepository == null) {
            throw new UnsupportedOperationException(unsupported);
        }
        return classLoaderRepository.loadClass(string);
    }

    public final Class loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
        ClassLoaderRepository classLoaderRepository = this.inner.getClassLoaderRepository();
        if (classLoaderRepository == null) {
            throw new UnsupportedOperationException(unsupported);
        }
        return classLoaderRepository.loadClassWithout(classLoader, string);
    }

    public final Class loadClassBefore(ClassLoader classLoader, String string) throws ClassNotFoundException {
        ClassLoaderRepository classLoaderRepository = this.inner.getClassLoaderRepository();
        if (classLoaderRepository == null) {
            throw new UnsupportedOperationException(unsupported);
        }
        return classLoaderRepository.loadClassBefore(classLoader, string);
    }
}

