/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CharStreamException;
import antlr.CodeGenerator;
import antlr.ExceptionHandler;
import antlr.ExceptionSpec;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.JavaBlockFinishingInfo;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RecognitionException;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.SatherCharFormatter;
import antlr.StringLiteralElement;
import antlr.StringLiteralSymbol;
import antlr.SynPredBlock;
import antlr.Token;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.TokenStreamException;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.actions.sather.ActionLexer;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SatherCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel;
    protected boolean genAST = false;
    protected boolean saveText = false;
    String labeledElementType;
    String labeledElementASTType;
    String labeledElementInit;
    String commonExtraArgs;
    String commonExtraParams;
    String commonLocalVars;
    String lt1Value;
    String exceptionThrown;
    String throwNoViable;
    RuleBlock currentRule;
    String currentASTResult;
    Hashtable treeVariableMap = new Hashtable();
    int astVarNumber = 1;
    protected static final String NONUNIQUE = new String();
    public static final int caseSizeThreshold = 127;
    private Vector semPreds;
    private static int satherBlockId;

    public SatherCodeGenerator() {
        this.charFormatter = new SatherCharFormatter();
    }

    protected int addSemPred(String string) {
        this.semPreds.appendElement((Object)string);
        return this.semPreds.size() - 1;
    }

    public void exitIfError() {
        if (this.tool.hasError) {
            System.out.println("Exiting due to errors.");
            System.exit(1);
        }
    }

    public void gen() {
        try {
            Object object;
            Enumeration enumeration = this.behavior.grammars.elements();
            while (enumeration.hasMoreElements()) {
                object = (Grammar)enumeration.nextElement();
                ((Grammar)object).setGrammarAnalyzer(this.analyzer);
                ((Grammar)object).setCodeGenerator(this);
                this.analyzer.setGrammar((Grammar)object);
                this.setupGrammarParameters((Grammar)object);
                ((Grammar)object).generate();
                this.exitIfError();
            }
            object = this.behavior.tokenManagers.elements();
            while (object.hasMoreElements()) {
                TokenManager tokenManager = (TokenManager)object.nextElement();
                if (!tokenManager.isReadOnly()) {
                    this.genTokenTypes(tokenManager);
                    this.genTokenInterchange(tokenManager);
                }
                this.exitIfError();
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
    }

    public void gen(ActionElement actionElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genAction(" + actionElement + ")");
        }
        if (actionElement.isSemPred) {
            this.genSemPred(actionElement.actionText, actionElement.line);
            return;
        }
        if (this.grammar.hasSyntacticPredicate) {
            this.println("if ( input_state.guessing = 0 ) then");
            ++this.tabs;
        }
        ActionTransInfo actionTransInfo = new ActionTransInfo();
        String string = this.processActionForTreeSpecifiers(actionElement.actionText, actionElement.getLine(), this.currentRule, actionTransInfo);
        if (actionTransInfo.refRuleRoot != null) {
            this.println(String.valueOf(actionTransInfo.refRuleRoot) + " := current_ast.root;");
        }
        this.printAction(string);
        if (actionTransInfo.assignToRoot) {
            this.println("current_ast.root := " + actionTransInfo.refRuleRoot + ";");
            this.println("if ( ~void( " + actionTransInfo.refRuleRoot + " ) and ~void( " + actionTransInfo.refRuleRoot + ".first_child ) ) then");
            ++this.tabs;
            this.println("current_ast.child := " + actionTransInfo.refRuleRoot + ".first_child");
            --this.tabs;
            this.println("else");
            ++this.tabs;
            this.println("current_ast.child := " + actionTransInfo.refRuleRoot + ";");
            --this.tabs;
            this.println("end; -- if");
            this.println("current_ast.advance_child_to_end;");
        }
        if (this.grammar.hasSyntacticPredicate) {
            --this.tabs;
            this.println("end; -- if");
        }
    }

    public void gen(AlternativeBlock alternativeBlock) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen(" + alternativeBlock + ")");
        }
        this.genBlockPreamble(alternativeBlock);
        String string = this.currentASTResult;
        if (alternativeBlock.getLabel() != null) {
            this.currentASTResult = alternativeBlock.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(alternativeBlock);
        JavaBlockFinishingInfo javaBlockFinishingInfo = this.genCommonBlock(alternativeBlock, true);
        this.genBlockFinish(javaBlockFinishingInfo, this.throwNoViable);
        this.println("");
        this.currentASTResult = string;
    }

    public void gen(BlockEndElement blockEndElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleEnd(" + blockEndElement + ")");
        }
    }

    public void gen(CharLiteralElement charLiteralElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genChar(" + charLiteralElement + ")");
        }
        if (charLiteralElement.getLabel() != null) {
            this.println(String.valueOf(charLiteralElement.getLabel()) + " := " + this.lt1Value + ";");
        }
        boolean bl = this.saveText;
        this.saveText = this.saveText && charLiteralElement.getAutoGenType() == 1;
        this.genMatch(charLiteralElement);
        this.saveText = bl;
    }

    public void gen(CharRangeElement charRangeElement) {
        if (charRangeElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(charRangeElement.getLabel()) + " := " + this.lt1Value + ";");
        }
        this.println("match_range( " + charRangeElement.beginText + ", " + charRangeElement.endText + " );");
    }

    public void gen(LexerGrammar lexerGrammar) throws IOException {
        GrammarSymbol grammarSymbol;
        GrammarSymbol grammarSymbol2;
        Object object;
        if (lexerGrammar.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(lexerGrammar);
        if (!(this.grammar instanceof LexerGrammar)) {
            Tool.panic((String)"Internal error generating lexer");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println(this.grammar.preambleAction.getText());
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass : "ANTLR_CHAR_SCANNER{TOKEN}";
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + "{TOKEN} < $ANTLR_TOKEN_STREAM{TOKEN} , $ANTLR_FILE_CURSOR is ");
        ++this.tabs;
        this.println("include " + string + " create -> private char_scanner_create;");
        this.println("include " + this.grammar.tokenManager.getName() + "_TOKENTYPES;");
        this.println("");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule, null));
        this.println("create ( istr : $ISTREAM ) : SAME is");
        ++this.tabs;
        this.println("inp : ANTLR_BYTE_BUFFER := #ANTLR_BYTE_BUFFER( istr );");
        this.println("res : SAME := #SAME( inp );");
        this.println("res.EOF_CHAR := istr.eof_char;");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( bb : ANTLR_BYTE_BUFFER ) : SAME is");
        ++this.tabs;
        this.println("state : ANTLR_LEXER_SHARED_INPUT_STATE := #ANTLR_LEXER_SHARED_INPUT_STATE( bb );");
        this.println("res: SAME := #SAME( state );");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( state : ANTLR_LEXER_SHARED_INPUT_STATE ) : SAME is ");
        ++this.tabs;
        this.println("res : SAME := char_scanner_create( state );");
        this.println("res.literals := #MAP{STR,INT};");
        Enumeration enumeration = this.grammar.tokenManager.getTokenSymbolKeys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).charAt(0) != '\"' || !((grammarSymbol2 = this.grammar.tokenManager.getTokenSymbol((String)object)) instanceof StringLiteralSymbol)) continue;
            grammarSymbol = (StringLiteralSymbol)grammarSymbol2;
            this.println("res.literals[ " + grammarSymbol.getId() + " ] := " + ((TokenSymbol)grammarSymbol).getTokenType() + ";");
        }
        this.println("res.case_sensitive_literals := " + lexerGrammar.caseSensitiveLiterals + ";");
        this.println("res.case_sensitive := " + lexerGrammar.caseSensitive + ";");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        if (this.grammar.debuggingOutput) {
            this.println("private const sa_rule_names : ARRAY{STR} := |");
            object = this.grammar.rules.elements();
            while (object.hasMoreElements()) {
                grammarSymbol2 = (GrammarSymbol)object.nextElement();
                if (!(grammarSymbol2 instanceof RuleSymbol)) continue;
                this.println("  \"" + ((RuleSymbol)grammarSymbol2).getId() + "\",");
            }
            this.println("|;");
        }
        this.genNextToken();
        object = this.grammar.rules.elements();
        int n = 0;
        while (object.hasMoreElements()) {
            grammarSymbol = (RuleSymbol)object.nextElement();
            if (!grammarSymbol.getId().equals("mnextToken")) {
                this.genRule((RuleSymbol)grammarSymbol, false, n++);
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
        this.println("");
        --this.tabs;
        this.println("end; -- class");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(OneOrMoreBlock oneOrMoreBlock) {
        Object object;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen+(" + oneOrMoreBlock + ")");
        }
        this.genBlockPreamble(oneOrMoreBlock);
        String string = oneOrMoreBlock.getLabel() != null ? String.valueOf(SatherCodeGenerator.getNextSatherPrefix()) + "_cnt_" + oneOrMoreBlock.getLabel() : String.valueOf(SatherCodeGenerator.getNextSatherPrefix()) + "_cnt" + oneOrMoreBlock.ID;
        this.println(String.valueOf(string) + " : INT := 0;");
        this.println("loop");
        ++this.tabs;
        String string2 = this.currentASTResult;
        if (oneOrMoreBlock.getLabel() != null) {
            this.currentASTResult = oneOrMoreBlock.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(oneOrMoreBlock);
        boolean bl = false;
        int n = this.grammar.maxk;
        if (!oneOrMoreBlock.greedy && oneOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk && oneOrMoreBlock.exitCache[oneOrMoreBlock.exitLookaheadDepth].containsEpsilon()) {
            bl = true;
            n = oneOrMoreBlock.exitLookaheadDepth;
        } else if (!oneOrMoreBlock.greedy && oneOrMoreBlock.exitLookaheadDepth == Integer.MAX_VALUE) {
            bl = true;
        }
        if (bl) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)+ loop; exit depth is " + oneOrMoreBlock.exitLookaheadDepth);
            }
            object = this.getLookaheadTestExpression(oneOrMoreBlock.exitCache, n);
            this.println("-- nongreedy exit test");
            this.println("if ( " + string + " >= 1 and " + (String)object + " ) then break! end; -- if");
        }
        object = this.genCommonBlock(oneOrMoreBlock, false);
        this.genBlockFinish((JavaBlockFinishingInfo)object, "if ( " + string + " >= 1 ) then break! else " + this.throwNoViable + " end; -- if");
        this.println(String.valueOf(string) + " := " + string + " + 1;");
        --this.tabs;
        this.println("end; -- loop");
        this.currentASTResult = string2;
    }

    public void gen(ParserGrammar parserGrammar) throws IOException {
        Enumeration enumeration;
        if (parserGrammar.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(parserGrammar);
        if (!(this.grammar instanceof ParserGrammar)) {
            Tool.panic((String)"Internal error generating parser");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println(this.grammar.preambleAction.getText());
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass.toUpperCase() : "ANTLR_" + this.grammar.getSuperClass().toUpperCase();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + "{ TOKEN < $ANTLR_TOKEN, AST < $ANTLR_AST{AST} } is");
        ++this.tabs;
        this.println("include " + string + "{ TOKEN, " + this.labeledElementASTType + " } create -> super_create;");
        this.println("include " + this.grammar.tokenManager.getName() + "_" + CodeGenerator.TokenTypesFileSuffix.toUpperCase() + ";");
        this.println("");
        if (this.grammar.debuggingOutput) {
            this.println("const sa_rule_names : ARRAY{STR} := |");
            enumeration = this.grammar.rules.elements();
            while (enumeration.hasMoreElements()) {
                GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
                if (!(grammarSymbol instanceof RuleSymbol)) continue;
                this.println("  \"" + ((RuleSymbol)grammarSymbol).getId() + "\",");
            }
            this.println("|;");
        }
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule, null));
        this.println("");
        this.println("create ( token_buf : ANTLR_TOKEN_BUFFER{TOKEN} , k : INT ) : SAME is");
        ++this.tabs;
        this.println("res : SAME := super_create( token_buf, k );");
        this.println("res.token_names := sa_token_names;");
        if (this.grammar.debuggingOutput) {
            this.println("res.rule_names  := sa_rule_names;");
            this.println("res.sem_pred_names := sa_sem_pred_names;");
            this.println("res.setup_debugging( token_buf );");
        }
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( token_buf : ANTLR_TOKEN_BUFFER{TOKEN} ) : SAME is");
        ++this.tabs;
        this.println("return #SAME( token_buf, " + this.grammar.maxk + ");");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( lexer : $ANTLR_TOKEN_STREAM{TOKEN} , k : INT ) : SAME is");
        ++this.tabs;
        this.println("res : SAME := super_create( lexer, k );");
        this.println("res.token_names := sa_token_names;");
        if (this.grammar.debuggingOutput) {
            this.println("res.rule_names := sa_rule_names;");
            this.println("res.sem_pred_names := sa_sem_pred_names;");
            this.println("res.setup_debugging( lexer );");
        }
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create( lexer : $ANTLR_TOKEN_STREAM{TOKEN} ) : SAME is");
        ++this.tabs;
        this.println("res : SAME := #SAME( lexer, " + this.grammar.maxk + ");");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        this.println("create ( state : ANTLR_PARSER_SHARED_INPUT_STATE{TOKEN} ) : SAME is ");
        ++this.tabs;
        this.println("res : SAME := super_create( state," + this.grammar.maxk + ");");
        this.println("res.token_names := sa_token_names;");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        enumeration = this.grammar.rules.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (grammarSymbol instanceof RuleSymbol) {
                RuleSymbol ruleSymbol = (RuleSymbol)grammarSymbol;
                this.genRule(ruleSymbol, ruleSymbol.references.size() == 0, n++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.println("");
        --this.tabs;
        this.println("end; -- class");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement ruleRefElement) {
        RuleSymbol ruleSymbol;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRR(" + ruleRefElement + ")");
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule)) == null || !ruleSymbol.isDefined()) {
            this.tool.error("Rule '" + ruleRefElement.targetRule + "' is not defined", this.grammar.getFilename(), ruleRefElement.getLine());
            return;
        }
        if (!(ruleSymbol instanceof RuleSymbol)) {
            this.tool.error("'" + ruleRefElement.targetRule + "' does not name a grammar rule", this.grammar.getFilename(), ruleRefElement.getLine());
            return;
        }
        this.genErrorTryForElement(ruleRefElement);
        if (this.grammar instanceof TreeWalkerGrammar && ruleRefElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println("if ( SYS::is_eq( sa_t , " + this.labeledElementASTType + "::ASTNULL ) ) then");
            ++this.tabs;
            this.println(String.valueOf(ruleRefElement.getLabel()) + " := void;");
            --this.tabs;
            this.println("else");
            this.println(String.valueOf(ruleRefElement.getLabel()) + " := " + this.lt1Value + ";");
            this.println("end; -- if");
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || ruleRefElement.getAutoGenType() == 3)) {
            this.println("sa_save_index := text.length;");
        }
        this.printTabs();
        if (ruleRefElement.idAssign != null) {
            if (ruleSymbol.block.returnAction == null) {
                Tool.warning((String)("Rule '" + ruleRefElement.targetRule + "' has no return type"), (String)this.grammar.getFilename(), (int)ruleRefElement.getLine());
            }
            this._print(String.valueOf(ruleRefElement.idAssign) + ":=");
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && ruleSymbol.block.returnAction != null) {
            Tool.warning((String)("Rule '" + ruleRefElement.targetRule + "' returns a value"), (String)this.grammar.getFilename(), (int)ruleRefElement.getLine());
        }
        this.GenRuleInvocation(ruleRefElement);
        if (this.grammar instanceof LexerGrammar && (!this.saveText || ruleRefElement.getAutoGenType() == 3)) {
            this.println("text := text.substring( 0, sa_save_index); -- truncate");
        }
        if (this.syntacticPredLevel == 0) {
            boolean bl;
            boolean bl2 = bl = this.grammar.hasSyntacticPredicate && (this.grammar.buildAST && ruleRefElement.getLabel() != null || this.genAST && ruleRefElement.getAutoGenType() == 1);
            if (bl) {
                this.println("if ( input_state.guessing = 0 ) then");
                ++this.tabs;
            }
            if (this.grammar.buildAST && ruleRefElement.getLabel() != null) {
                this.println(String.valueOf(ruleRefElement.getLabel()) + "_ast := return_ast;");
            }
            if (this.genAST) {
                switch (ruleRefElement.getAutoGenType()) {
                    case 1: {
                        this.println("current_ast.add_child( return_ast );");
                        break;
                    }
                    case 2: {
                        this.tool.error("Internal: encountered ^ after rule reference");
                        break;
                    }
                }
            }
            if (this.grammar instanceof LexerGrammar && ruleRefElement.getLabel() != null) {
                this.println(String.valueOf(ruleRefElement.getLabel()) + " := sa_return_token;");
            }
            if (bl) {
                --this.tabs;
                this.println("end;");
            }
        }
        this.genErrorCatchForElement(ruleRefElement);
    }

    public void gen(StringLiteralElement stringLiteralElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genString(" + stringLiteralElement + ")");
        }
        if (stringLiteralElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(stringLiteralElement.getLabel()) + " := " + this.lt1Value + ";");
        }
        this.genElementAST(stringLiteralElement);
        boolean bl = this.saveText;
        this.saveText = this.saveText && stringLiteralElement.getAutoGenType() == 1;
        this.genMatch(stringLiteralElement);
        this.saveText = bl;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa_t.next_sibling;");
        }
    }

    public void gen(TokenRangeElement tokenRangeElement) {
        this.genErrorTryForElement(tokenRangeElement);
        if (tokenRangeElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(tokenRangeElement.getLabel()) + " := " + this.lt1Value + ";");
        }
        this.genElementAST(tokenRangeElement);
        this.println("match_range( " + tokenRangeElement.beginText + ", " + tokenRangeElement.endText + " );");
        this.genErrorCatchForElement(tokenRangeElement);
    }

    public void gen(TokenRefElement tokenRefElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genTokenRef(" + tokenRefElement + ")");
        }
        if (this.grammar instanceof LexerGrammar) {
            Tool.panic((String)"Token reference found in lexer");
        }
        this.genErrorTryForElement(tokenRefElement);
        if (tokenRefElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(tokenRefElement.getLabel()) + " := " + this.lt1Value + ";");
        }
        this.genElementAST(tokenRefElement);
        this.genMatch(tokenRefElement);
        this.genErrorCatchForElement(tokenRefElement);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa_t.next_sibling;");
        }
    }

    public void gen(TreeElement treeElement) {
        this.println("sa__t" + treeElement.ID + " : " + this.labeledElementASTType + " := sa_t;");
        if (treeElement.root.getLabel() != null) {
            this.println("if ( SYS::is_eq( sa_t , AST::ASTNULL ) ) then");
            ++this.tabs;
            this.println(String.valueOf(treeElement.root.getLabel()) + " := void;");
            this.println("else");
            this.println(String.valueOf(treeElement.root.getLabel()) + " := sa_t;");
            this.println("end; -- if");
        }
        this.genElementAST(treeElement.root);
        if (this.grammar.buildAST) {
            this.println("sa__current_ast" + treeElement.ID + " : ANTLR_AST_PAIR{AST} := current_ast.copy;");
            this.println("current_ast.root := current_ast.child;");
            this.println("current_ast.child := void;");
        }
        this.genMatch(treeElement.root);
        this.println("sa_t := sa_t.first_child;");
        int n = 0;
        while (n < treeElement.getAlternatives().size()) {
            Alternative alternative = treeElement.getAlternativeAt(n);
            AlternativeElement alternativeElement = alternative.head;
            while (alternativeElement != null) {
                alternativeElement.generate();
                alternativeElement = alternativeElement.next;
            }
            ++n;
        }
        if (this.grammar.buildAST) {
            this.println("current_ast := sa__current_ast" + treeElement.ID + ";");
        }
        this.println("sa_t := sa__t" + treeElement.ID + ";");
        this.println("sa_t := sa_t.next_sibling;");
    }

    public void gen(TreeWalkerGrammar treeWalkerGrammar) throws IOException {
        this.setGrammar(treeWalkerGrammar);
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            Tool.panic((String)"Internal error generating tree-walker");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println(this.grammar.preambleAction.getText());
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass.toUpperCase() : "ANTLR_TREE_PARSER";
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + "{AST < $ANTLR_AST{AST} } is");
        this.println("");
        ++this.tabs;
        this.println("include " + string + "{" + this.labeledElementASTType + "} create -> tree_parser_create;");
        this.println("include " + this.grammar.tokenManager.getName() + "_" + CodeGenerator.TokenTypesFileSuffix.toUpperCase() + ";");
        this.println("");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule, null));
        this.println("attr token_names : ARRAY{STR};");
        this.println("");
        this.println("create : SAME is");
        ++this.tabs;
        this.println("res : SAME := tree_parser_create;");
        this.println("res.token_names := sa_token_names;");
        this.println("return res;");
        --this.tabs;
        this.println("end; -- create");
        this.println("");
        Enumeration enumeration = this.grammar.rules.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (grammarSymbol instanceof RuleSymbol) {
                RuleSymbol ruleSymbol = (RuleSymbol)grammarSymbol;
                this.genRule(ruleSymbol, ruleSymbol.references.size() == 0, n++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        --this.tabs;
        this.println("end; -- class");
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wildcardElement) {
        if (wildcardElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(wildcardElement.getLabel()) + " := " + this.lt1Value + ";");
        }
        this.genElementAST(wildcardElement);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("if ( void(sa_t) ) then");
            ++this.tabs;
            this.println("raise #ANTLR_MISMATCHED_TOKEN_EXCEPTION;");
            --this.tabs;
            this.println("end;");
        } else if (this.grammar instanceof LexerGrammar) {
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wildcardElement.getAutoGenType() == 3)) {
                this.println("sa_save_index := text.length;");
            }
            this.println("match_not(EOF_CHAR);");
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wildcardElement.getAutoGenType() == 3)) {
                this.println("text := text.substring( 0 , sa_save_index);");
            }
        } else {
            this.println("match_not(" + this.getValueString(1) + ");");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa_t.next_sibling;");
        }
    }

    public void gen(ZeroOrMoreBlock zeroOrMoreBlock) {
        Object object;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen*(" + zeroOrMoreBlock + ")");
        }
        this.genBlockPreamble(zeroOrMoreBlock);
        if (zeroOrMoreBlock.getLabel() != null) {
            String string = zeroOrMoreBlock.getLabel();
        } else {
            String string = "_loop" + zeroOrMoreBlock.ID;
        }
        this.println("loop");
        ++this.tabs;
        String string = this.currentASTResult;
        if (zeroOrMoreBlock.getLabel() != null) {
            this.currentASTResult = zeroOrMoreBlock.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(zeroOrMoreBlock);
        boolean bl = false;
        int n = this.grammar.maxk;
        if (!zeroOrMoreBlock.greedy && zeroOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk && zeroOrMoreBlock.exitCache[zeroOrMoreBlock.exitLookaheadDepth].containsEpsilon()) {
            bl = true;
            n = zeroOrMoreBlock.exitLookaheadDepth;
        } else if (!zeroOrMoreBlock.greedy && zeroOrMoreBlock.exitLookaheadDepth == Integer.MAX_VALUE) {
            bl = true;
        }
        if (bl) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)* loop; exit depth is " + zeroOrMoreBlock.exitLookaheadDepth);
            }
            object = this.getLookaheadTestExpression(zeroOrMoreBlock.exitCache, n);
            this.println("-- nongreedy exit test");
            this.println("if ( " + (String)object + " ) then break! end; -- if");
        }
        object = this.genCommonBlock(zeroOrMoreBlock, false);
        this.genBlockFinish((JavaBlockFinishingInfo)object, "break!;");
        --this.tabs;
        this.println("end; -- loop ");
        this.currentASTResult = string;
    }

    protected void genAlt(Alternative alternative, AlternativeBlock alternativeBlock) {
        boolean bl = this.genAST;
        this.genAST = this.genAST && alternative.getAutoGen();
        boolean bl2 = this.saveText;
        this.saveText = this.saveText && alternative.getAutoGen();
        Hashtable hashtable = this.treeVariableMap;
        this.treeVariableMap = new Hashtable();
        if (alternative.exceptionSpec != null) {
            this.println("protect -- for error handling");
            ++this.tabs;
        }
        AlternativeElement alternativeElement = alternative.head;
        while (!(alternativeElement instanceof BlockEndElement)) {
            alternativeElement.generate();
            alternativeElement = alternativeElement.next;
        }
        if (this.genAST) {
            if (alternativeBlock instanceof RuleBlock) {
                RuleBlock ruleBlock = (RuleBlock)alternativeBlock;
                this.println(String.valueOf(ruleBlock.getRuleName()) + "_ast := current_ast.root;");
            } else {
                alternativeBlock.getLabel();
            }
        }
        if (alternative.exceptionSpec != null) {
            --this.tabs;
            this.genErrorHandler(alternative.exceptionSpec);
        }
        this.genAST = bl;
        this.saveText = bl2;
        this.treeVariableMap = hashtable;
    }

    protected void genBitsets(Vector vector, int n) {
        SatherCharFormatter satherCharFormatter = new SatherCharFormatter();
        this.println("");
        if (this.grammar instanceof LexerGrammar) {
            int n2 = 0;
            while (n2 < vector.size()) {
                BitSet bitSet = (BitSet)vector.elementAt(n2);
                bitSet.growToInclude(n);
                String string = satherCharFormatter.BitSet2BoolList(bitSet, ", ");
                String string2 = "sa" + this.getBitsetName(n2);
                String string3 = String.valueOf(string2) + "_data_";
                this.println("const " + string3 + " : ARRAY{BOOL} := " + "| " + string + " |;");
                this.println("const " + string2 + " : CHAR_SET := bitset( " + string3 + " );");
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            BitSet bitSet = (BitSet)vector.elementAt(n3);
            bitSet.growToInclude(n);
            String string = satherCharFormatter.BitSet2IntList(bitSet, ", ");
            String string4 = "sa" + this.getBitsetName(n3);
            String string5 = String.valueOf(string4) + "_data_";
            this.println("const " + string5 + " : ARRAY{INT} := " + "| " + string + " |;");
            this.println("const " + string4 + " : INT_SET := int_set( " + string5 + " );");
            ++n3;
        }
    }

    private void genBlockFinish(JavaBlockFinishingInfo javaBlockFinishingInfo, String string) {
        if (javaBlockFinishingInfo.needAnErrorClause && (javaBlockFinishingInfo.generatedAnIf || javaBlockFinishingInfo.generatedSwitch)) {
            if (javaBlockFinishingInfo.generatedAnIf) {
                ++this.tabs;
                this.println("else");
            }
            ++this.tabs;
            this.println(string);
            --this.tabs;
            if (javaBlockFinishingInfo.generatedAnIf) {
                this.println("end; -- if");
                --this.tabs;
            }
            if (javaBlockFinishingInfo.generatedSwitch) {
                this.println("end; -- case");
            }
        }
        if (!javaBlockFinishingInfo.needAnErrorClause && javaBlockFinishingInfo.generatedSwitch) {
            this.println("end; -- case");
        }
        if (javaBlockFinishingInfo.postscript != null) {
            this.println(javaBlockFinishingInfo.postscript);
        }
    }

    protected void genBlockPreamble(AlternativeBlock alternativeBlock) {
        if (alternativeBlock instanceof RuleBlock) {
            RuleBlock ruleBlock = (RuleBlock)alternativeBlock;
            if (ruleBlock.labeledElements != null) {
                int n = 0;
                while (n < ruleBlock.labeledElements.size()) {
                    AlternativeElement alternativeElement = (AlternativeElement)ruleBlock.labeledElements.elementAt(n);
                    if (alternativeElement instanceof RuleRefElement || alternativeElement instanceof AlternativeBlock && !(alternativeElement instanceof RuleBlock) && !(alternativeElement instanceof SynPredBlock)) {
                        if (!(alternativeElement instanceof RuleRefElement) && ((AlternativeBlock)alternativeElement).not && this.analyzer.subruleCanBeInverted((AlternativeBlock)alternativeElement, this.grammar instanceof LexerGrammar)) {
                            this.println(String.valueOf(alternativeElement.getLabel()) + " : " + this.labeledElementType + " := " + this.labeledElementInit + ";");
                            if (this.grammar.buildAST) {
                                this.println(String.valueOf(alternativeElement.getLabel()) + "_ast : " + this.labeledElementASTType + ";");
                            }
                        } else {
                            if (this.grammar.buildAST) {
                                this.println(String.valueOf(alternativeElement.getLabel()) + "_ast : " + this.labeledElementASTType + ";");
                            }
                            if (this.grammar instanceof LexerGrammar) {
                                this.println(String.valueOf(alternativeElement.getLabel()) + " : $ANTLR_TOKEN; ");
                            }
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println(String.valueOf(alternativeElement.getLabel()) + " : " + this.labeledElementType + " := " + this.labeledElementInit + ";");
                            }
                        }
                    } else {
                        this.println(String.valueOf(alternativeElement.getLabel()) + " : " + this.labeledElementType + " := " + this.labeledElementInit + ";");
                        if (this.grammar.buildAST) {
                            this.println(String.valueOf(alternativeElement.getLabel()) + "_ast : " + this.labeledElementASTType + ";");
                        }
                    }
                    ++n;
                }
            }
        }
        if (alternativeBlock.initAction != null) {
            this.printAction(this.processActionForTreeSpecifiers(alternativeBlock.initAction, 0, this.currentRule, null));
        }
    }

    protected void genCases(BitSet bitSet) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCases(" + bitSet + ")");
        }
        int[] nArray = bitSet.toArray();
        int n = this.grammar instanceof LexerGrammar ? 4 : 1;
        int n2 = 1;
        boolean bl = true;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n2 == 1) {
                this.print("");
            } else {
                this._print("  ");
            }
            if (n3 == 0) {
                this._print("when " + this.getValueString(nArray[n3]));
            } else {
                this._print(", " + this.getValueString(nArray[n3]));
            }
            if (n2 == n) {
                this._println("");
                bl = true;
                n2 = 1;
            } else {
                ++n2;
                bl = false;
            }
            ++n3;
        }
        if (!bl) {
            this._println("");
        }
    }

    public JavaBlockFinishingInfo genCommonBlock(AlternativeBlock alternativeBlock, boolean bl) {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        JavaBlockFinishingInfo javaBlockFinishingInfo = new JavaBlockFinishingInfo();
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCommonBlk(" + alternativeBlock + ")");
        }
        boolean bl3 = this.genAST;
        this.genAST = this.genAST && alternativeBlock.getAutoGen();
        boolean bl4 = this.saveText;
        boolean bl5 = this.saveText = this.saveText && alternativeBlock.getAutoGen();
        if (alternativeBlock.not && this.analyzer.subruleCanBeInverted(alternativeBlock, this.grammar instanceof LexerGrammar)) {
            Lookahead lookahead = this.analyzer.look(1, alternativeBlock);
            if (alternativeBlock.getLabel() != null && this.syntacticPredLevel == 0) {
                this.println(String.valueOf(alternativeBlock.getLabel()) + " := " + this.lt1Value + ";");
            }
            this.genElementAST(alternativeBlock);
            String string = "";
            if (this.grammar instanceof TreeWalkerGrammar) {
                string = "sa_t,";
            }
            this.println("match( sa" + string + this.getBitsetName(this.markBitsetForGen(lookahead.fset)) + ");");
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("sa_t := sa_t.next_sibling;");
            }
            return javaBlockFinishingInfo;
        }
        if (alternativeBlock.getAlternatives().size() == 1) {
            Alternative alternative = alternativeBlock.getAlternativeAt(0);
            if (alternative.synPred != null) {
                Tool.warning((String)"Syntactic predicate superfluous for single alternative", (String)this.grammar.getFilename(), (int)alternativeBlock.getAlternativeAt((int)0).synPred.getLine());
            }
            if (bl) {
                if (alternative.semPred != null) {
                    this.genSemPred(alternative.semPred, alternativeBlock.line);
                }
                this.genAlt(alternative, alternativeBlock);
                return javaBlockFinishingInfo;
            }
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < alternativeBlock.getAlternatives().size()) {
            object3 = alternativeBlock.getAlternativeAt(n6);
            if (SatherCodeGenerator.suitableForCaseExpression((Alternative)object3)) {
                ++n5;
            }
            ++n6;
        }
        if (n5 >= this.makeSwitchThreshold) {
            object3 = this.lookaheadString(1);
            bl2 = true;
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("if ( void(sa_t) ) then");
                ++this.tabs;
                this.println("sa_t := AST::ASTNULL;");
                --this.tabs;
                this.println("end; -- if");
            }
            this.println("case ( " + (String)object3 + " )");
            n2 = 0;
            while (n2 < alternativeBlock.alternatives.size()) {
                object2 = alternativeBlock.getAlternativeAt(n2);
                if (SatherCodeGenerator.suitableForCaseExpression((Alternative)object2)) {
                    object = ((Alternative)object2).cache[1];
                    if (((Lookahead)object).fset.degree() == 0 && !((Lookahead)object).containsEpsilon()) {
                        Tool.warning((String)"Alternate omitted due to empty prediction set", (String)this.grammar.getFilename(), (int)((Alternative)object2).head.getLine());
                    } else {
                        this.genCases(((Lookahead)object).fset);
                        this.println("then");
                        ++this.tabs;
                        this.genAlt((Alternative)object2, alternativeBlock);
                        --this.tabs;
                    }
                }
                ++n2;
            }
            this.println("else -- default");
            ++this.tabs;
        }
        n2 = n = this.grammar instanceof LexerGrammar ? this.grammar.maxk : 0;
        while (n2 >= 0) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("checking depth " + n2);
            }
            int n7 = 0;
            while (n7 < alternativeBlock.alternatives.size()) {
                block45: {
                    String string;
                    int n8;
                    boolean bl6;
                    block48: {
                        block46: {
                            block47: {
                                block44: {
                                    object = alternativeBlock.getAlternativeAt(n7);
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("genAlt: " + n7);
                                    }
                                    if (!bl2 || !SatherCodeGenerator.suitableForCaseExpression((Alternative)object)) break block44;
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("ignoring alt because it was in the switch");
                                    }
                                    break block45;
                                }
                                bl6 = false;
                                if (!(this.grammar instanceof LexerGrammar)) break block46;
                                n8 = ((Alternative)object).lookaheadDepth;
                                if (n8 == Integer.MAX_VALUE) {
                                    n8 = this.grammar.maxk;
                                }
                                while (n8 >= 1 && ((Alternative)object).cache[n8].containsEpsilon()) {
                                    --n8;
                                }
                                if (n8 == n2) break block47;
                                if (this.DEBUG_CODE_GENERATOR) {
                                    System.out.println("ignoring alt because effectiveDepth!=altDepth;" + n8 + "/=" + n2);
                                }
                                break block45;
                            }
                            bl6 = this.lookaheadIsEmpty((Alternative)object, n8);
                            string = this.getLookaheadTestExpression((Alternative)object, n8);
                            break block48;
                        }
                        bl6 = this.lookaheadIsEmpty((Alternative)object, this.grammar.maxk);
                        string = this.getLookaheadTestExpression((Alternative)object, this.grammar.maxk);
                    }
                    n8 = 1;
                    if (((Alternative)object).cache[1].fset.degree() > 127) {
                        if (n3 == 0) {
                            this.println("if " + string + " then");
                        } else {
                            this.println("elsif " + string + " then");
                        }
                    } else if (bl6 && ((Alternative)object).semPred == null && ((Alternative)object).synPred == null) {
                        if (n3 != 0) {
                            this.println("else ");
                            n8 = 0;
                        }
                        javaBlockFinishingInfo.needAnErrorClause = false;
                    } else {
                        if (((Alternative)object).semPred != null) {
                            ActionTransInfo actionTransInfo = new ActionTransInfo();
                            String string2 = this.processActionForTreeSpecifiers(((Alternative)object).semPred, alternativeBlock.line, this.currentRule, actionTransInfo);
                            string = (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar) && this.grammar.debuggingOutput ? "(" + string + " and fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.PREDICTING," + this.addSemPred(this.charFormatter.escapeString(string2)) + "," + string2 + "))" : "(" + string + " and (" + string2 + "))";
                        }
                        if (n3 > 0) {
                            if (((Alternative)object).synPred != null) {
                                this.println("else");
                                ++this.tabs;
                                this.genSynPred(((Alternative)object).synPred, string);
                                ++n4;
                            } else {
                                this.println("elsif " + string + " then");
                            }
                        } else if (((Alternative)object).synPred != null) {
                            this.genSynPred(((Alternative)object).synPred, string);
                        } else {
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println("if ( void(sa_t) ) then");
                                ++this.tabs;
                                this.println("sa_t := AST::ASTNULL;");
                                --this.tabs;
                                this.println("end; -- if");
                            }
                            this.println("if " + string + " then");
                        }
                    }
                    ++n3;
                    ++this.tabs;
                    this.genAlt((Alternative)object, alternativeBlock);
                    --this.tabs;
                    if (n8 == 0) {
                        this.println("end; -- if");
                    }
                }
                ++n7;
            }
            --n2;
        }
        object2 = "";
        int n9 = 1;
        while (n9 <= n4) {
            object2 = String.valueOf(object2) + "end;";
            ++n9;
        }
        this.genAST = bl3;
        this.saveText = bl4;
        if (bl2) {
            --this.tabs;
            javaBlockFinishingInfo.postscript = object2;
            javaBlockFinishingInfo.generatedSwitch = true;
            javaBlockFinishingInfo.generatedAnIf = n3 > 0;
        } else {
            javaBlockFinishingInfo.postscript = object2;
            javaBlockFinishingInfo.generatedSwitch = false;
            javaBlockFinishingInfo.generatedAnIf = n3 > 0;
        }
        return javaBlockFinishingInfo;
    }

    private static boolean suitableForCaseExpression(Alternative alternative) {
        return alternative.lookaheadDepth == 1 && alternative.semPred == null && !alternative.cache[1].containsEpsilon() && alternative.cache[1].fset.degree() <= 127;
    }

    private void genElementAST(AlternativeElement alternativeElement) {
        if (this.grammar instanceof TreeWalkerGrammar && !this.grammar.buildAST) {
            if (alternativeElement.getLabel() == null) {
                String string = this.lt1Value;
                String string2 = "tmp" + this.astVarNumber + "_ast";
                ++this.astVarNumber;
                this.mapTreeVariable(alternativeElement, string2);
                this.println(String.valueOf(string2) + "_in : " + this.labeledElementASTType + " := " + string + ";");
            }
            return;
        }
        if (this.grammar.buildAST && this.syntacticPredLevel == 0) {
            Object object;
            String string;
            String string3;
            boolean bl;
            boolean bl2 = bl = this.grammar.hasSyntacticPredicate && (alternativeElement.getLabel() != null || alternativeElement.getAutoGenType() != 3);
            if (alternativeElement.getLabel() != null) {
                string3 = alternativeElement.getLabel();
                string = String.valueOf(alternativeElement.getLabel()) + "_ast";
            } else {
                string3 = this.lt1Value;
                string = "tmp" + this.astVarNumber + "_ast";
                ++this.astVarNumber;
                object = (GrammarAtom)alternativeElement;
                if (((GrammarAtom)object).getASTNodeType() != null) {
                    this.println(String.valueOf(string) + " : " + ((GrammarAtom)object).getASTNodeType() + " := void;");
                } else {
                    this.println(String.valueOf(string) + " : " + this.labeledElementASTType + ";");
                }
                this.mapTreeVariable(alternativeElement, string);
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(String.valueOf(string) + "_in : " + this.labeledElementASTType + ";");
                }
            }
            if (bl) {
                this.println("if ( input_state.guessing = 0 ) then");
                ++this.tabs;
            }
            object = this.labeledElementASTType;
            GrammarAtom grammarAtom = (GrammarAtom)alternativeElement;
            if (grammarAtom != null && grammarAtom.getASTNodeType() != null) {
                this.labeledElementASTType = object = grammarAtom.getASTNodeType();
            }
            String string4 = this.grammar instanceof TreeWalkerGrammar ? String.valueOf(object) + "::create_from_ast( " + string3 + " )" : String.valueOf(object) + "::create_from_token( " + string3 + " )";
            if (alternativeElement.getLabel() != null) {
                this.println(String.valueOf(string) + " := " + string4 + ";");
            } else {
                string3 = this.lt1Value;
                this.println(String.valueOf(string) + " := " + string4 + ";");
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(String.valueOf(string) + "_in := " + string3 + ";");
                }
            }
            if (this.genAST) {
                switch (alternativeElement.getAutoGenType()) {
                    case 1: {
                        this.println("current_ast.add_child( " + string + " );");
                        break;
                    }
                    case 2: {
                        this.println("current_ast.make_root( " + string + " );");
                        break;
                    }
                }
            }
            if (bl) {
                --this.tabs;
                this.println("end; -- if?");
            }
        }
    }

    private void genErrorCatchForElement(AlternativeElement alternativeElement) {
        ExceptionSpec exceptionSpec;
        RuleSymbol ruleSymbol;
        if (alternativeElement.getLabel() == null) {
            return;
        }
        String string = alternativeElement.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            string = CodeGenerator.lexerRuleName(alternativeElement.enclosingRuleName);
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string)) == null) {
            Tool.panic((String)"Enclosing rule not found!");
        }
        if ((exceptionSpec = ruleSymbol.block.findExceptionSpec(alternativeElement.getLabel())) != null) {
            --this.tabs;
            this.println("}*28");
            this.genErrorHandler(exceptionSpec);
        }
    }

    private void genErrorHandler(ExceptionSpec exceptionSpec) {
        int n = 0;
        while (n < exceptionSpec.handlers.size()) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)exceptionSpec.handlers.elementAt(n);
            this.println("when " + this.extractTypeOfAction(exceptionHandler.exceptionTypeAndName) + " then");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if ( input_state.guessing = 0 ) then");
                ++this.tabs;
            }
            this.printAction(this.processActionForTreeSpecifiers(exceptionHandler.action.getText(), 0, this.currentRule, null));
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("else");
                ++this.tabs;
                this.println("raise exception");
                --this.tabs;
                this.println("end; -- if");
            }
            --this.tabs;
            ++n;
        }
        this.println("end; -- protect");
    }

    private void genErrorTryForElement(AlternativeElement alternativeElement) {
        ExceptionSpec exceptionSpec;
        RuleSymbol ruleSymbol;
        if (alternativeElement.getLabel() == null) {
            return;
        }
        String string = alternativeElement.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            string = CodeGenerator.lexerRuleName(alternativeElement.enclosingRuleName);
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string)) == null) {
            Tool.panic((String)"Enclosing rule not found!");
        }
        if ((exceptionSpec = ruleSymbol.block.findExceptionSpec(alternativeElement.getLabel())) != null) {
            this.println("try { // for error handling");
            ++this.tabs;
        }
    }

    protected void genHeader() {
        this.println("-- $ANTLR 2.7.1: \"" + Tool.fileMinusPath((String)this.tool.grammarFile) + "\"" + " -> " + "\"" + this.grammar.getClassName() + ".sa\"$");
    }

    private void genLiteralsTest() {
        this.println("sa_ttype := test_literals_table(sa_ttype);");
    }

    private void genLiteralsTestForPartialToken() {
        this.println("sa_ttype := test_literals_table( text.substring( sa_begin, text.length - sa_begin ), sa_ttype );");
    }

    protected void genMatch(BitSet bitSet) {
    }

    protected void genMatch(GrammarAtom grammarAtom) {
        if (grammarAtom instanceof StringLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(grammarAtom);
                return;
            }
            this.genMatchUsingAtomTokenType(grammarAtom);
            return;
        }
        if (grammarAtom instanceof CharLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(grammarAtom);
                return;
            }
            this.tool.error("cannot ref character literals in grammar: " + grammarAtom);
            return;
        }
        if (grammarAtom instanceof TokenRefElement) {
            this.genMatchUsingAtomText(grammarAtom);
        }
    }

    protected void genMatchUsingAtomText(GrammarAtom grammarAtom) {
        String string = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            string = "sa_t,";
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || grammarAtom.getAutoGenType() == 3)) {
            this.println("sa_save_index := text.length;");
        }
        this.print(grammarAtom.not ? "match_not(" : "match(");
        this._print(string);
        if (grammarAtom.atomText.equals("EOF")) {
            this._print("ANTLR_COMMON_TOKEN::EOF_TYPE");
        } else {
            this._print(grammarAtom.atomText);
        }
        this._println(");");
        if (this.grammar instanceof LexerGrammar && (!this.saveText || grammarAtom.getAutoGenType() == 3)) {
            this.println("text := text.substring( 0 , sa_save_index);");
        }
    }

    protected void genMatchUsingAtomTokenType(GrammarAtom grammarAtom) {
        String string = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            string = "sa_t,";
        }
        String string2 = String.valueOf(string) + this.getValueString(grammarAtom.getType());
        this.println(String.valueOf(grammarAtom.not ? "match_not(" : "match(") + string2 + ");");
    }

    public void genNextToken() {
        Object object;
        Object object2;
        boolean bl = false;
        int n = 0;
        while (n < this.grammar.rules.size()) {
            object2 = (RuleSymbol)this.grammar.rules.elementAt(n);
            if (((RuleSymbol)object2).isDefined() && ((RuleSymbol)object2).access.equals("public")) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.println("");
            this.println("next_token : TOKEN is ");
            ++this.tabs;
            this.println("protect");
            ++this.tabs;
            this.println("upon_eof;");
            --this.tabs;
            this.println("when $ANTLR_CHAR_STREAM_EXCEPTION then");
            ++this.tabs;
            this.println("raise #ANTLR_TOKEN_STREAM_EXCEPTION( exception.str );");
            --this.tabs;
            this.println("end; -- protect");
            this.println("return #ANTLR_COMMON_TOKEN( ANTLR_COMMON_TOKEN::EOF_TYPE, \"\");");
            --this.tabs;
            this.println("end;");
            this.println("");
            return;
        }
        object2 = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol ruleSymbol = new RuleSymbol("mnextToken");
        ruleSymbol.setDefined();
        ruleSymbol.setBlock((RuleBlock)object2);
        ruleSymbol.access = "private";
        this.grammar.define(ruleSymbol);
        this.grammar.theLLkAnalyzer.deterministic((AlternativeBlock)object2);
        String string = null;
        if (((LexerGrammar)this.grammar).filterMode) {
            string = ((LexerGrammar)this.grammar).filterRule;
        }
        this.println("");
        this.println("next_token : TOKEN is");
        ++this.tabs;
        this.println("theRetToken : TOKEN;");
        this.println("continue : BOOL := true;");
        this.println("loop");
        ++this.tabs;
        this.println("sa_ttype : INT := ANTLR_COMMON_TOKEN::INVALID_TYPE;");
        if (((LexerGrammar)this.grammar).filterMode) {
            this.println("commit_to_path := false;");
            this.println("continue := true;");
            if (string != null) {
                if (!this.grammar.isDefined(CodeGenerator.lexerRuleName(string))) {
                    this.grammar.tool.error("Filter rule " + string + " does not exist in this lexer");
                } else {
                    RuleSymbol ruleSymbol2 = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.lexerRuleName(string));
                    if (!ruleSymbol2.isDefined()) {
                        this.grammar.tool.error("Filter rule " + string + " does not exist in this lexer");
                    } else if (ruleSymbol2.access.equals("public")) {
                        this.grammar.tool.error("Filter rule " + string + " must be protected");
                    }
                }
                this.println("sa_m : INT := mark;");
            }
        }
        this.println("reset_text;");
        this.println("protect   -- for char stream error handling");
        ++this.tabs;
        this.println("protect   -- for lexical error handling");
        ++this.tabs;
        int n2 = 0;
        while (n2 < ((AlternativeBlock)object2).getAlternatives().size()) {
            object = ((AlternativeBlock)object2).getAlternativeAt(n2);
            if (((Alternative)object).cache[1].containsEpsilon()) {
                Tool.warning((String)"found optional path in nextToken()");
            }
            ++n2;
        }
        object = System.getProperty("line.separator");
        JavaBlockFinishingInfo javaBlockFinishingInfo = this.genCommonBlock((AlternativeBlock)object2, false);
        String string2 = "if ( LA(1) = EOF_CHAR ) then upon_eof; sa_return_token := make_token( ANTLR_COMMON_TOKEN::EOF_TYPE);";
        string2 = String.valueOf(string2) + (String)object + "\t\t\t\t";
        string2 = ((LexerGrammar)this.grammar).filterMode ? (string == null ? String.valueOf(string2) + "\telse consume; continue := false; end; -- if" : String.valueOf(string2) + "\telse" + (String)object + "\t\t\t\t\t\tcommit;" + (String)object + "\t\t\t\t\t\tprotect" + (String)object + "\t\t\t\t\t\t\tm" + string + "(false);" + (String)object + "\t\t\t\t\t\twhen $ANTLR_RECOGNITION_EXCEPTION then" + (String)object + "\t\t\t\t\t\t\t-- catastrophic failure" + (String)object + "\t\t\t\t\t\t\treport_error( exception );" + (String)object + "\t\t\t\t\t\t\tconsume;" + (String)object + "\t\t\t\t\t\tend; -- protect" + (String)object + "\t\t\t\t\t\tcontinue := false;" + (String)object + "\t\t\t\t\tend; -- if") : String.valueOf(string2) + "\t\telse " + this.throwNoViable + " end; -- if";
        this.genBlockFinish(javaBlockFinishingInfo, string2);
        if (((LexerGrammar)this.grammar).filterMode && string != null) {
            this.println("if continue then");
            ++this.tabs;
            this.println("commit;");
            --this.tabs;
            this.println("end; -- if");
        }
        this.println("if ( ~void(sa_return_token) and continue ) then;");
        ++this.tabs;
        this.println("sa_ttype := sa_return_token.ttype;");
        if (((LexerGrammar)this.grammar).getTestLiterals()) {
            this.genLiteralsTest();
        }
        this.println("sa_return_token.ttype := sa_ttype;");
        this.println("return sa_return_token;");
        --this.tabs;
        this.println("end; -- if");
        --this.tabs;
        this.println("when $ANTLR_RECOGNITION_EXCEPTION then");
        ++this.tabs;
        if (((LexerGrammar)this.grammar).filterMode) {
            if (string == null) {
                this.println("if ( ~commit_to_path ) then");
                ++this.tabs;
                this.println("consume;");
                --this.tabs;
                this.println("end; -- if");
            } else {
                this.println("if ( ~commit_to_path ) then");
                ++this.tabs;
                this.println("rewind( sa_m );");
                this.println("reset_text;");
                this.println("protect");
                ++this.tabs;
                this.println("m" + string + "(false);");
                --this.tabs;
                this.println("when $ANTLR_RECOGNITION_EXCEPTION then");
                ++this.tabs;
                this.println("-- horrendous failure: error in filter rule");
                this.println("report_error( exception );");
                this.println("consume;");
                --this.tabs;
                this.println("end; -- protect");
                --this.tabs;
                this.println("end; -- if");
            }
        } else if (((RuleBlock)object2).getDefaultErrorHandler()) {
            this.println("report_error( exception );");
            this.println("consume;");
        } else {
            this.println("raise #ANTLR_TOKEN_STREAM_RECOGNITION_EXCEPTION( exception.str );");
        }
        --this.tabs;
        this.println("end; -- protect");
        --this.tabs;
        this.println("when $ANTLR_CHAR_STREAM_EXCEPTION then");
        ++this.tabs;
        this.println("raise #ANTLR_TOKEN_STREAM_EXCEPTION( exception.message );");
        --this.tabs;
        this.println("end; -- protect");
        --this.tabs;
        this.println("end; -- loop");
        --this.tabs;
        this.println("end; -- next_token");
        this.println("");
    }

    public void genRule(RuleSymbol ruleSymbol, boolean bl, int n) {
        String string;
        Object object;
        RuleBlock ruleBlock;
        this.tabs = 1;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRule(" + ruleSymbol.getId() + ")");
        }
        if (!ruleSymbol.isDefined()) {
            this.tool.error("undefined rule: " + ruleSymbol.getId());
            return;
        }
        this.labeledElementASTType = "AST";
        this.currentRule = ruleBlock = ruleSymbol.getBlock();
        this.currentASTResult = ruleSymbol.getId();
        boolean bl2 = this.genAST;
        this.genAST = this.genAST && ruleBlock.getAutoGen();
        this.saveText = ruleBlock.getAutoGen();
        if (ruleSymbol.comment != null) {
            this._println(ruleSymbol.comment);
        }
        this.print(ruleSymbol.getId());
        boolean bl3 = false;
        if (this.commonExtraParams.length() != 0) {
            bl3 = true;
            this._print("( " + this.commonExtraParams);
            if (ruleBlock.argAction != null) {
                this._print(",");
            }
        }
        if (ruleBlock.argAction != null && !bl3) {
            bl3 = true;
            this._print("( ");
        }
        if (ruleBlock.argAction != null) {
            this.print(ruleBlock.argAction);
        }
        if (bl3) {
            this._print(" )");
        }
        if (ruleBlock.returnAction != null) {
            this._print(" : " + this.extractSatherTypeOfAction(ruleBlock.returnAction));
        }
        this._println(" is");
        ++this.tabs;
        if (ruleBlock.returnAction != null) {
            this.println(String.valueOf(ruleBlock.returnAction) + ";");
        }
        this.println(this.commonLocalVars);
        if (this.grammar.traceRules) {
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("trace_in(\"" + ruleSymbol.getId() + "\",sa_t);");
            } else {
                this.println("trace_in(\"" + ruleSymbol.getId() + "\");");
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            if (ruleSymbol.getId().equals("mEOF")) {
                this.println("sa_ttype := ANTLR_COMMON_TOKEN::EOF_TYPE;");
            } else {
                this.println("sa_ttype := " + ruleSymbol.getId().substring(1) + ";");
            }
            this.println("sa_save_index : INT;");
        }
        if (this.grammar.debuggingOutput) {
            if (this.grammar instanceof ParserGrammar) {
                this.println("fire_enter_rule( " + n + ", 0 );");
            } else if (this.grammar instanceof LexerGrammar) {
                this.println("fire_enter_rule( " + n + ", sa_ttype );");
            }
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            this.println("protect -- debugging output");
            ++this.tabs;
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println(String.valueOf(ruleSymbol.getId()) + "_ast_in : " + this.labeledElementASTType + " := sa_t;");
        }
        if (this.grammar.buildAST) {
            this.println("return_ast := void;");
            this.println("current_ast ::= #ANTLR_AST_PAIR{AST};");
            this.println(String.valueOf(ruleSymbol.getId()) + "_ast : " + this.labeledElementASTType + ";");
        }
        this.genBlockPreamble(ruleBlock);
        this.println("");
        ExceptionSpec exceptionSpec = ruleBlock.findExceptionSpec("");
        if (exceptionSpec != null || ruleBlock.getDefaultErrorHandler()) {
            this.println("protect -- for error handling");
            ++this.tabs;
        }
        if (ruleBlock.alternatives.size() == 1) {
            object = ruleBlock.getAlternativeAt(0);
            string = ((Alternative)object).semPred;
            if (string != null) {
                this.genSemPred(string, this.currentRule.line);
            }
            if (((Alternative)object).synPred != null) {
                Tool.warning((String)"Syntactic predicate ignored for single alternative", (String)this.grammar.getFilename(), (int)((Alternative)object).synPred.getLine());
            }
            this.genAlt((Alternative)object, ruleBlock);
        } else {
            this.grammar.theLLkAnalyzer.deterministic(ruleBlock);
            object = this.genCommonBlock(ruleBlock, false);
            this.genBlockFinish((JavaBlockFinishingInfo)object, this.throwNoViable);
        }
        if (exceptionSpec != null || ruleBlock.getDefaultErrorHandler()) {
            --this.tabs;
        }
        if (exceptionSpec != null) {
            this.genErrorHandler(exceptionSpec);
        } else if (ruleBlock.getDefaultErrorHandler()) {
            this.println("when " + this.exceptionThrown + " then");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if ( input_state.guessing = 0 ) then");
                ++this.tabs;
            }
            this.println("report_error( exception );");
            if (!(this.grammar instanceof TreeWalkerGrammar)) {
                object = this.grammar.theLLkAnalyzer.FOLLOW(1, ruleBlock.endNode);
                string = "sa" + this.getBitsetName(this.markBitsetForGen(((Lookahead)object).fset));
                this.println("consume;");
                this.println("consume_until( " + string + " );");
            } else {
                this.println("if ( ~void(sa_t) ) then");
                ++this.tabs;
                this.println("sa_t := sa_t.next_sibling;");
                --this.tabs;
                this.println("end; -- if");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("else");
                ++this.tabs;
                this.println("raise exception;");
                --this.tabs;
                this.println("end; -- if");
            }
            --this.tabs;
            this.println("end; -- protect");
        }
        if (this.grammar.buildAST) {
            this.println("return_ast := " + ruleSymbol.getId() + "_ast;");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_ret_tree := sa_t;");
        }
        if (ruleBlock.getTestLiterals()) {
            if (ruleSymbol.access.equals("protected")) {
                this.genLiteralsTestForPartialToken();
            } else {
                this.genLiteralsTest();
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            this.println("if ( sa_create_token and void(sa_token) and sa_ttype /= ANTLR_COMMON_TOKEN::SKIP ) then");
            ++this.tabs;
            this.println("sa_token := make_token( sa_ttype );");
            this.println("sa_token.text := text.substring( sa_begin, text.length - sa_begin );");
            --this.tabs;
            this.println("end; -- if");
            this.println("sa_return_token := sa_token;");
        }
        if (ruleBlock.returnAction != null) {
            this.println("return " + this.extractSatherIdOfAction(ruleBlock.returnAction, ruleBlock.getLine()) + ";");
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            --this.tabs;
            this.println("when $STR then -- assume this will catch everything");
            ++this.tabs;
            object = null;
            string = null;
            if (this.grammar.debuggingOutput) {
                if (this.grammar instanceof ParserGrammar) {
                    object = "fire_exit_rule(" + n + ",0);";
                } else if (this.grammar instanceof LexerGrammar) {
                    object = "fire_exit_rule(" + n + ", sa_ttype);";
                }
            }
            if (this.grammar.traceRules) {
                string = this.grammar instanceof TreeWalkerGrammar ? "trace_out(\"" + ruleSymbol.getId() + "\", sa_t);" : "trace_out(\"" + ruleSymbol.getId() + "\");";
            }
            if (object != null) {
                this.println((String)object);
            }
            if (string != null) {
                this.println(string);
            }
            this.println("raise exception;");
            --this.tabs;
            this.println("end; -- protect");
            if (object != null) {
                this.println((String)object);
            }
            if (string != null) {
                this.println(string);
            }
        }
        --this.tabs;
        this.println("end; -- rule");
        this.println("");
        this.genAST = bl2;
    }

    private void GenRuleInvocation(RuleRefElement ruleRefElement) {
        this._print(ruleRefElement.targetRule);
        boolean bl = false;
        if (this.grammar instanceof LexerGrammar) {
            bl = true;
            if (ruleRefElement.getLabel() != null) {
                this._print("( true");
            } else {
                this._print("( false");
            }
            if (this.commonExtraArgs.length() != 0 || ruleRefElement.args != null) {
                this._print(",");
            }
        } else if (this.commonExtraArgs.length() != 0 || ruleRefElement.args != null) {
            bl = true;
            this._print("( ");
        }
        this._print(this.commonExtraArgs);
        if (this.commonExtraArgs.length() != 0 && ruleRefElement.args != null) {
            this._print(",");
        }
        RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule);
        if (ruleRefElement.args != null) {
            ActionTransInfo actionTransInfo = new ActionTransInfo();
            String string = this.processActionForTreeSpecifiers(ruleRefElement.args, 0, this.currentRule, actionTransInfo);
            if (actionTransInfo.assignToRoot || actionTransInfo.refRuleRoot != null) {
                this.tool.error("Arguments of rule reference '" + ruleRefElement.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName() + " on line " + ruleRefElement.getLine());
            }
            this._print(string);
            if (ruleSymbol.block.argAction == null) {
                Tool.warning((String)("Rule '" + ruleRefElement.targetRule + "' accepts no arguments"), (String)this.grammar.getFilename(), (int)ruleRefElement.getLine());
            }
        } else if (ruleSymbol.block.argAction != null) {
            Tool.warning((String)("Missing parameters on reference to rule " + ruleRefElement.targetRule), (String)this.grammar.getFilename(), (int)ruleRefElement.getLine());
        }
        if (bl) {
            this._print(" )");
        }
        this._println(";");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa_ret_tree;");
        }
    }

    protected void genSemPred(String string, int n) {
        ActionTransInfo actionTransInfo = new ActionTransInfo();
        string = this.processActionForTreeSpecifiers(string, n, this.currentRule, actionTransInfo);
        String string2 = this.charFormatter.escapeString(string);
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            string = "fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.VALIDATING," + this.addSemPred(string2) + "," + string + ")";
        }
        this.println("if (~(" + string + ")) then");
        ++this.tabs;
        this.println("raise #ANTLR_SEMANTIC_EXCEPTION(\"" + string2 + "\");");
        --this.tabs;
        this.println("end;");
    }

    protected void genSemPredMap() {
        Enumeration enumeration = this.semPreds.elements();
        this.println("private String _semPredNames[] = {");
        while (enumeration.hasMoreElements()) {
            this.println("\"" + enumeration.nextElement() + "\",");
        }
        this.println("};");
    }

    protected void genSynPred(SynPredBlock synPredBlock, String string) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen=>(" + synPredBlock + ")");
        }
        this.println("syn_pred_matched" + synPredBlock.ID + " : BOOL := false;");
        this.println("if (" + string + ") then");
        ++this.tabs;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa__t" + synPredBlock.ID + " " + this.labeledElementASTType + " := sa_t;");
        } else {
            this.println("sa_m" + synPredBlock.ID + " : INT := mark;");
        }
        this.println("syn_pred_matched" + synPredBlock.ID + " := true;");
        this.println("input_state.guessing := input_state.guessing + 1;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("fireSyntacticPredicateStarted();");
        }
        ++this.syntacticPredLevel;
        this.println("protect");
        ++this.tabs;
        this.gen(synPredBlock);
        --this.tabs;
        this.println("when " + this.exceptionThrown + " then");
        ++this.tabs;
        this.println("syn_pred_matched" + synPredBlock.ID + " := false;");
        --this.tabs;
        this.println("end; -- protect");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("sa_t := sa__t" + synPredBlock.ID + ";");
        } else {
            this.println("rewind( sa_m" + synPredBlock.ID + " );");
        }
        this.println("input_state.guessing := input_state.guessing - 1;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("if ( syn_pred_matched" + synPredBlock.ID + " ) then");
            ++this.tabs;
            this.println("fireSyntacticPredicateSucceeded();");
            --this.tabs;
            this.println("else");
            ++this.tabs;
            this.println("  fireSyntacticPredicateFailed();");
            --this.tabs;
            this.println("end; -- if");
        }
        --this.syntacticPredLevel;
        --this.tabs;
        this.println("end; -- if");
        this.println("if ( syn_pred_matched" + synPredBlock.ID + " ) then");
    }

    public void genTokenStrings() {
        this.println("");
        this.println("const sa_token_names : ARRAY{STR} := |");
        ++this.tabs;
        Vector vector = this.grammar.tokenManager.getVocabulary();
        int n = 0;
        while (n < vector.size()) {
            TokenSymbol tokenSymbol;
            String string = (String)vector.elementAt(n);
            if (string == null) {
                string = "<" + String.valueOf(n) + ">";
            }
            if (!string.startsWith("\"") && !string.startsWith("<") && (tokenSymbol = this.grammar.tokenManager.getTokenSymbol(string)) != null && tokenSymbol.getParaphrase() != null) {
                string = Tool.stripFrontBack((String)tokenSymbol.getParaphrase(), (String)"\"", (String)"\"");
            }
            this.print(this.charFormatter.literalString(string));
            if (n != vector.size() - 1) {
                this._print(",");
            }
            this._println("");
            ++n;
        }
        --this.tabs;
        this.println("|;");
    }

    protected void genTokenTypes(TokenManager tokenManager) throws IOException {
        this.setupOutput(String.valueOf(tokenManager.getName()) + "_" + CodeGenerator.TokenTypesFileSuffix.toUpperCase());
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("class " + tokenManager.getName() + "_" + CodeGenerator.TokenTypesFileSuffix.toUpperCase() + " is");
        ++this.tabs;
        Vector vector = tokenManager.getVocabulary();
        this.println("const EOF : INT := " + 1 + ";");
        this.println("const NULL_TREE_LOOKAHEAD : INT := " + 3 + ";");
        int n = 4;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string != null) {
                if (string.startsWith("\"")) {
                    StringLiteralSymbol stringLiteralSymbol = (StringLiteralSymbol)tokenManager.getTokenSymbol(string);
                    if (stringLiteralSymbol == null) {
                        Tool.panic((String)("String literal " + string + " not in symbol table"));
                    } else if (stringLiteralSymbol.label != null) {
                        this.println("const " + stringLiteralSymbol.label + " : INT" + " := " + n + ";");
                    } else {
                        String string2 = this.mangleLiteral(string);
                        if (string2 != null) {
                            this.println("const " + string2 + " : INT" + " := " + n + ";");
                            stringLiteralSymbol.label = string2;
                        } else {
                            this.println("-- " + string + " := " + n);
                        }
                    }
                } else if (!string.startsWith("<")) {
                    this.println("const " + string + " : INT" + " := " + n + ";");
                }
            }
            ++n;
        }
        this.println("");
        this.println("bitset ( bool_array : ARRAY{BOOL} ) : CHAR_SET is");
        ++this.tabs;
        this.println("return #CHAR_SET( bool_array );");
        --this.tabs;
        this.println("end;");
        this.println("");
        this.println("int_set ( int_array : ARRAY{INT} ) : INT_SET is");
        ++this.tabs;
        this.println("return #INT_SET( int_array );");
        --this.tabs;
        this.println("end;");
        --this.tabs;
        this.println("end; -- class");
        this.currentOutput.close();
        this.currentOutput = null;
        this.exitIfError();
    }

    public String getASTCreateString(Vector vector) {
        if (vector.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ANTLR_AST_UTIL{AST}::make( ( #ANTLR_AST_ARRAY{AST}(" + vector.size() + "))");
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append(".add(" + vector.elementAt(n) + ")");
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getASTCreateString(GrammarAtom grammarAtom, String string) {
        if (grammarAtom != null && grammarAtom.getASTNodeType() != null) {
            return String.valueOf(grammarAtom.getASTNodeType()) + "::create(" + string + ")";
        }
        return String.valueOf(this.labeledElementASTType) + "::create( " + string + " )";
    }

    protected String getLookaheadTestExpression(Lookahead[] lookaheadArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = true;
        stringBuffer.append("(");
        int n2 = 1;
        while (n2 <= n) {
            BitSet bitSet = lookaheadArray[n2].fset;
            if (!bl) {
                stringBuffer.append(") and (");
            }
            bl = false;
            if (lookaheadArray[n2].containsEpsilon()) {
                stringBuffer.append("true");
            } else {
                stringBuffer.append(this.getLookaheadTestTerm(n2, bitSet));
            }
            ++n2;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected String getLookaheadTestExpression(Alternative alternative, int n) {
        int n2 = alternative.lookaheadDepth;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.grammar.maxk;
        }
        if (n == 0) {
            return "true";
        }
        return "(" + this.getLookaheadTestExpression(alternative.cache, n2) + ")";
    }

    protected String getLookaheadTestTerm(int n, BitSet bitSet) {
        String string = this.lookaheadString(n);
        int[] nArray = bitSet.toArray();
        if (CodeGenerator.elementsAreRange(nArray)) {
            return this.getRangeExpression(n, nArray);
        }
        int n2 = bitSet.degree();
        if (n2 == 0) {
            return "true";
        }
        if (n2 >= this.bitsetTestThreshold) {
            int n3 = this.markBitsetForGen(bitSet);
            return "sa" + this.getBitsetName(n3) + ".member(" + string + ")";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < nArray.length) {
            String string2 = this.getValueString(nArray[n4]);
            if (n4 > 0) {
                stringBuffer.append(" or ");
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String getRangeExpression(int n, int[] nArray) {
        if (!CodeGenerator.elementsAreRange(nArray)) {
            Tool.panic((String)"getRangeExpression called with non-range");
        }
        int n2 = nArray[0];
        int n3 = nArray[nArray.length - 1];
        return "(" + this.lookaheadString(n) + " >= " + this.getValueString(n2) + " and " + this.lookaheadString(n) + " <= " + this.getValueString(n3) + ")";
    }

    private String getValueString(int n) {
        String string;
        if (this.grammar instanceof LexerGrammar) {
            string = this.charFormatter.literalChar(n);
        } else {
            TokenSymbol tokenSymbol = this.grammar.tokenManager.getTokenSymbolAt(n);
            if (tokenSymbol == null) {
                return String.valueOf(n);
            }
            String string2 = tokenSymbol.getId();
            if (tokenSymbol instanceof StringLiteralSymbol) {
                StringLiteralSymbol stringLiteralSymbol = (StringLiteralSymbol)tokenSymbol;
                String string3 = stringLiteralSymbol.getLabel();
                if (string3 != null) {
                    string = string3;
                } else {
                    string = this.mangleLiteral(string2);
                    if (string == null) {
                        string = String.valueOf(n);
                    }
                }
            } else {
                string = string2;
            }
        }
        return string;
    }

    protected boolean lookaheadIsEmpty(Alternative alternative, int n) {
        int n2 = alternative.lookaheadDepth;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.grammar.maxk;
        }
        int n3 = 1;
        while (n3 <= n2 && n3 <= n) {
            BitSet bitSet = alternative.cache[n3].fset;
            if (bitSet.degree() != 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private String lookaheadString(int n) {
        if (this.grammar instanceof TreeWalkerGrammar) {
            return "sa_t.ttype";
        }
        return "LA(" + n + ")";
    }

    private String mangleLiteral(String string) {
        String string2 = Tool.literalsPrefix;
        int n = 1;
        while (n < string.length() - 1) {
            if (!Character.isLetter(string.charAt(n)) && string.charAt(n) != '_') {
                return null;
            }
            string2 = String.valueOf(string2) + string.charAt(n);
            ++n;
        }
        if (Tool.upperCaseMangledLiterals) {
            string2 = string2.toUpperCase();
        }
        return string2;
    }

    public String mapTreeId(String string, ActionTransInfo actionTransInfo) {
        Object object;
        if (this.currentRule == null) {
            return string;
        }
        boolean bl = false;
        String string2 = string;
        if (this.grammar instanceof TreeWalkerGrammar) {
            if (!this.grammar.buildAST) {
                bl = true;
            } else if (string2.length() > 3 && string2.lastIndexOf("_in") == string2.length() - 3) {
                string2 = string2.substring(0, string2.length() - 3);
                bl = true;
            }
        }
        int n = 0;
        while (n < this.currentRule.labeledElements.size()) {
            object = (AlternativeElement)this.currentRule.labeledElements.elementAt(n);
            if (((AlternativeElement)object).getLabel().equals(string2)) {
                if (bl) {
                    return string2;
                }
                return String.valueOf(string2) + "_ast";
            }
            ++n;
        }
        object = (String)this.treeVariableMap.get(string2);
        if (object != null) {
            if (object == NONUNIQUE) {
                return null;
            }
            if (((String)object).equals(this.currentRule.getRuleName())) {
                return null;
            }
            if (bl) {
                return String.valueOf(object) + "_in";
            }
            return object;
        }
        if (string2.equals(this.currentRule.getRuleName())) {
            String string3;
            String string4 = string3 = bl ? String.valueOf(string2) + "_ast_in" : String.valueOf(string2) + "_ast";
            if (actionTransInfo != null && !bl) {
                actionTransInfo.refRuleRoot = string3;
            }
            return string3;
        }
        return string2;
    }

    private void mapTreeVariable(AlternativeElement alternativeElement, String string) {
        if (alternativeElement instanceof TreeElement) {
            this.mapTreeVariable(((TreeElement)alternativeElement).root, string);
            return;
        }
        String string2 = null;
        if (alternativeElement.getLabel() == null) {
            if (alternativeElement instanceof TokenRefElement) {
                string2 = ((TokenRefElement)alternativeElement).atomText;
            } else if (alternativeElement instanceof RuleRefElement) {
                string2 = ((RuleRefElement)alternativeElement).targetRule;
            }
        }
        if (string2 != null) {
            if (this.treeVariableMap.get(string2) != null) {
                this.treeVariableMap.remove(string2);
                this.treeVariableMap.put(string2, NONUNIQUE);
                return;
            }
            this.treeVariableMap.put(string2, string);
        }
    }

    private void setupGrammarParameters(Grammar grammar) {
        if (grammar instanceof ParserGrammar) {
            this.labeledElementASTType = "AST";
            this.labeledElementType = "$ANTLR_TOKEN";
            this.labeledElementInit = "void";
            this.commonExtraArgs = "";
            this.commonExtraParams = "";
            this.commonLocalVars = "";
            this.lt1Value = "LT(1)";
            this.exceptionThrown = "$ANTLR_RECOGNITION_EXCEPTION";
            this.throwNoViable = "raise ANTLR_NO_VIABLE_ALT_EXCEPTION{AST}::create_from_token(LT(1), file_name );";
            return;
        }
        if (grammar instanceof LexerGrammar) {
            this.labeledElementType = "CHAR ";
            this.labeledElementInit = "'\\0'";
            this.commonExtraArgs = "";
            this.commonExtraParams = "sa_create_token : BOOL";
            this.commonLocalVars = "sa_ttype : INT; sa_token : TOKEN; sa_begin : INT := text.length;";
            this.lt1Value = "LA(1)";
            this.exceptionThrown = "$ANTLR_RECOGNITION_EXCEPTION";
            this.throwNoViable = "raise #ANTLR_NO_VIABLE_ALT_FOR_CHAR_EXCEPTION( LA(1), file_name, line );";
            return;
        }
        if (grammar instanceof TreeWalkerGrammar) {
            this.labeledElementType = this.labeledElementASTType = "AST";
            if (!grammar.hasOption("ASTLabelType")) {
                grammar.setOption("ASTLabelType", new Token(6, "AST"));
            }
            this.labeledElementInit = "void";
            this.commonExtraArgs = "sa_t";
            this.commonExtraParams = "sa_t : " + this.labeledElementASTType;
            this.commonLocalVars = "";
            this.lt1Value = "sa_t";
            this.exceptionThrown = "$ANTLR_RECOGNITION_EXCEPTION";
            this.throwNoViable = "raise #ANTLR_NO_VIABLE_ALT_EXCEPTION{AST}(sa_t);";
            return;
        }
        Tool.panic((String)"Unknown grammar type");
    }

    public void setupOutput(String string) throws IOException {
        this.currentOutput = Tool.openOutputFile((String)(String.valueOf(string) + ".sa"));
    }

    private static synchronized String getNextSatherPrefix() {
        String string = "sa" + satherBlockId;
        ++satherBlockId;
        return string;
    }

    protected String extractSatherTypeOfAction(String string) {
        int n = string.length();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (string.charAt(n2) == ':') {
                return string.substring(n2 + 1, n);
            }
            --n2;
        }
        Tool.warning((String)"Unable to determine Sather type");
        return "";
    }

    protected String extractSatherIdOfAction(String string, int n) {
        int n2 = string.length();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (string.charAt(n3) == ':') {
                return string.substring(0, n3);
            }
            --n3;
        }
        Tool.warning((String)"Unable to determine Sather return identifier");
        return "";
    }

    protected String processActionForTreeSpecifiers(String string, int n, RuleBlock ruleBlock, ActionTransInfo actionTransInfo) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.grammar == null) {
            return string;
        }
        if (this.grammar.buildAST && string.indexOf(64) != -1 || this.grammar instanceof TreeWalkerGrammar || this.grammar instanceof LexerGrammar && string.indexOf(37) != -1) {
            ActionLexer actionLexer = new ActionLexer(string, ruleBlock, this, actionTransInfo);
            actionLexer.setLineOffset(n);
            actionLexer.setTool(this.tool);
            try {
                actionLexer.mACTION(true);
                string = actionLexer.getTokenObject().getText();
            }
            catch (RecognitionException recognitionException) {
                actionLexer.reportError(recognitionException);
                return string;
            }
            catch (TokenStreamException tokenStreamException) {
                Tool.panic((String)("Error reading action:" + string));
                return string;
            }
            catch (CharStreamException charStreamException) {
                Tool.panic((String)("Error reading action:" + string));
                return string;
            }
        }
        return string;
    }
}

